/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bG7C
 */

// forked from Saqoosha's Rybczyński Effect
// write as3 code here..
package {
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.PixelSnapping;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.media.Camera;
    import flash.media.Video;
    
    import net.hires.debug.Stats;
    
    [SWF(frameRate=60)]
    
    public class Hoge extends Sprite {
        
        private static const NUM_STRIP:int = 120;
        
        private var _camera:Camera;
        private var _video:Video;
        private var _images:Array = [];
        private var _canvas:BitmapData;
        private var _index:int = 0;
        
        public function Hoge() {
            this._camera = Camera.getCamera();
            if (!this._camera) {
                throw new Error('No Camera!');
            }
            this._camera.setMode(320, 240, 30);
            this._video = new Video(320, 240);
            this._video.attachCamera(this._camera);
            this._canvas = new BitmapData(320, 240, false, 0x0);
            var bm:Bitmap = this.addChild(new Bitmap(this._canvas, PixelSnapping.AUTO, true)) as Bitmap;
            bm.scaleX = bm.scaleY = 465 / 240;
            bm.x = -(bm.width - 465) / 2;
            
            for (var i:int = 0; i < NUM_STRIP; i++) {
                this._images.push(new BitmapData(320, 240, false, 0x0));
            }
            
            this.addEventListener(Event.ENTER_FRAME, this._update);
            
//            this.addChild(new Stats());
        }
        
        private function _update(e:Event):void {
            var b:BitmapData = this._images[this._index];
            b.draw(this._video);
            
            var rect:Rectangle = new Rectangle(0, 0, 320, 240 / NUM_STRIP);
            var pt:Point = new Point();
            for (var i:int = 0; i < NUM_STRIP; i++) {
                pt.y = rect.y = i / NUM_STRIP * 240;
                this._canvas.copyPixels(this._images[(this._index + i) % NUM_STRIP], rect, pt);
            }
            
            if (++this._index == NUM_STRIP) {
                this._index = 0;
            }
        }
    }
}