/**
 * Copyright littlepad ( http://wonderfl.net/user/littlepad )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bFYl
 */

package {
    import flash.events.TimerEvent;
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.utils.Timer;
    public class CountDown extends Sprite {
        private var _tf:TextField;
        private var _timer:Timer;
        private var _goalDate:Date;
        
        public function CountDown() {
            init();
        }
        
        private function init():void {
            _tf = new TextField();
            _tf.x = _tf.y = 10;
            _tf.width = _tf.height = 445;
            addChild(_tf);
            
            // ゴール日時の設定（2020年11月1日10時）
            _goalDate = new Date(2020, 11 - 1, 1, 10, 0);
            
            _timer = new Timer(1000);
            _timer.addEventListener(TimerEvent.TIMER, onTimer);
            _timer.start();
        }
        
        private function onTimer(e:TimerEvent):void {
            var currentDate:Date = new Date();
            var leftTime:int;
            var date:int;
            var hour:int;
            var min:int;
            var sec:int;
            
            leftTime = (_goalDate.getTime() - currentDate.getTime()) / 1000;
            
            date = leftTime / (60 * 60 * 24);
            hour = leftTime / (60 * 60) - date * 24;
            min = leftTime / 60 - (hour * 60 + date * 24 * 60);
            sec = leftTime - (hour * 60 * 60 + date * 24 * 60 * 60 + min * 60);
            
            _tf.text = String(_goalDate.getFullYear()) + "年" + 
                String(_goalDate.getMonth() + 1) + "月" + 
                String(_goalDate.getDate()) + "日" + 
                String(_goalDate.getHours()) + "時" + 
                String(_goalDate.getMinutes()) + "分" + "まで\n";
            _tf.appendText( "あと" + String(date) + "日" + hour + "時間" + min + "分" + sec + "秒");
        }

    }
}