/**
 * Copyright paq ( http://wonderfl.net/user/paq )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bFUy
 */

package 
{
    //--------------------------------------------------------------------------
    
    import flash.display.Sprite;
    import flash.events.Event;
    
    //--------------------------------------------------------------------------
    
    /**
     * ...。
     * 
     * @author paq
     */
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="60")]
    public class GlobalSign extends Sprite 
    {
        //==========================================================================
        // プロパティ
        //--------------------------------------------------------------------------
        
        private var _icons:Vector.<Icon> = new Vector.<Icon>();
        
        //==========================================================================
        // メソッド
        //--------------------------------------------------------------------------
        
        /**
         * コンストラクタ
         */
        public function GlobalSign() 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        /**
         * アプリケーションを初期化します.
         * 
         * @param    event
         */
        private function init(event:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            var i:int = 0;
            
            for (i = 0; i < 2; i++ )
            {
                _icons[i] = new Icon();
                _icons[i].x = stage.stageWidth;
                _icons[i].y = stage.stageWidth / 2 - _icons[i].width / 2;
                addChild(_icons[i]);
            }
            
            var len:int = _icons.length;
            for (i = 0; i < len; i++ )
            {
                if (i+1 == len)
                {
                    _icons[i].next = _icons[0];
                    continue;
                }
                _icons[i].next = _icons[i + 1];
            }
            
            _icons[0].x -= 1;
            
            addEventListener(Event.ENTER_FRAME, mainLoop);
        }
        
        //==========================================================================
        // イベントハンドラー
        //--------------------------------------------------------------------------
        
        /**
         * メインループ
         * 
         * @param    event
         */
        private function mainLoop(event:Event):void 
        {
            for (var i:int = 0, len:int = _icons.length; i < len; i++ )
            {
                var icon:Icon = _icons[i];
                
                if (icon.x < stage.stageWidth)
                    icon.x -= 1;
                    
                if (icon.x < 40 && icon.next.x >= stage.stageWidth)
                    icon.next.x -= 1;
                    
                if (icon.x < -icon.width)
                {
                    icon.clear();
                    icon.x = stage.stageWidth;
                }
            }
        }
    }
    
}

//--------------------------------------------------------------------------

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import frocessing.shape.FShapeSVG;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.Back;

//--------------------------------------------------------------------------

/**
 * Icon クラスは、 <code>Sprite</code> クラスを継承した Adobe 風のアイコンです.
 * クリックすると、目が付きます.
 */
internal class Icon extends Sprite
{
    //==========================================================================
    // プロパティ
    //--------------------------------------------------------------------------
    
    private static const SVG:XML = 
        <svg>
            <linearGradient id="SVGID_1_" gradientUnits="userSpaceOnUse" x1="0" y1="116.1748" x2="231.6665" y2="116.1748">
                <stop  offset="0" style="stop-color:#CDC4C5"/>
                <stop  offset="1" style="stop-color:#878282"/>
            </linearGradient>
            <polyline fill="url(#SVGID_1_)" points="0,232.35 0,0 231.667,0 231.667,107.174 "/>
            <linearGradient id="SVGID_2_" gradientUnits="userSpaceOnUse" x1="117.0005" y1="119.1338" x2="117.0005" y2="140.3136">
                <stop  offset="0" style="stop-color:#252121"/>
                <stop  offset="1" style="stop-color:#000000"/>
            </linearGradient>
            <polyline fill="url(#SVGID_2_)" points="233.175,231.841 14.493,245.507 0.826,231.841 0.826,0.175 "/>
            <linearGradient id="SVGID_3_" gradientUnits="userSpaceOnUse" x1="130.6675" y1="11.1738" x2="130.6675" y2="243.1738">
                <stop  offset="0" style="stop-color:#514849"/>
                <stop  offset="1" style="stop-color:#000000"/>
            </linearGradient>
            <rect x="14.493" y="13.841" fill="url(#SVGID_3_)" width="232.35" height="231.666"/>
            <path fill="#EEEEEE" d="M151.493,157.245c-9.825,0-17.921-5.262-19.152-12.07c-0.107,0.591-0.181,1.188-0.181,1.798\
                c0,7.659,8.656,13.868,19.333,13.868c10.678,0,19.334-6.209,19.334-13.868c0-0.61-0.074-1.207-0.182-1.798\
                C169.415,151.983,161.319,157.245,151.493,157.245z"/>
            <path fill="#EEEEEE" d="M112.993,157.245c-9.825,0-17.921-5.262-19.152-12.07c-0.107,0.591-0.181,1.188-0.181,1.798\
                c0,7.659,8.656,13.868,19.333,13.868c10.678,0,19.334-6.209,19.334-13.868c0-0.61-0.074-1.207-0.182-1.798\
                C130.915,151.983,122.819,157.245,112.993,157.245z"/>
        </svg>;
    
    private static const SHAPE_DATA:FShapeSVG = new FShapeSVG(SVG);
    
    public var next:Icon;
    
    private var _sprite:Sprite;
    private var _eyes:Vector.<Eye> = new Vector.<Eye>();
    
    //==========================================================================
    // メソッド
    //--------------------------------------------------------------------------

    /**
     * 新しい Icon クラスのインスタンスを作成します.
     */
    public function Icon()
    {
        _sprite = SHAPE_DATA.toSprite();
        addChild(_sprite);
        
        addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
    }
    
    /**
     * このオブジェクトに置かれている目をすべて消去します.
     */
    public function clear():void
    {
        for (var i:int, len:int = _eyes.length; i < len; i++)
        {
            removeChild(_eyes[i]);
        }
        _eyes.length = 0;
    }
    
    //==========================================================================
    // イベントハンドラー
    //--------------------------------------------------------------------------
    
    /**
     * @param    event
     */
    private function mouseDownHandler(event:MouseEvent):void 
    {
        var eye:Eye = new Eye();
        
        eye.x = mouseX;
        eye.y = mouseY;
        
        eye.scaleX = eye.scaleY = 0;
        BetweenAS3.tween(eye, { scaleX: 1, scaleY: 1 }, null, 0.1, Back.easeOut).play();
        
        addChild(eye);
        
        _eyes.push(eye);
    }
}

//--------------------------------------------------------------------------

/**
 * Eye クラスは、 <code>Sprite</code> クラスを継承した Adobe AIR の証明書を発行してくれるあれのロゴに似たものです.
 */
internal class Eye extends Sprite
{
    //==========================================================================
    // プロパティ
    //--------------------------------------------------------------------------
    
    private static const SVG:XML = 
        <svg>
            <radialGradient id="SVGID_4_" cx="19.25" cy="19.25" r="19.25" gradientUnits="userSpaceOnUse">
                <stop  offset="0" style="stop-color:#50E0B9"/>
                <stop  offset="0.7692" style="stop-color:#1150A0"/>
                <stop  offset="1" style="stop-color:#11246B"/>
            </radialGradient>
            <circle fill="url(#SVGID_4_)" cx="19.25" cy="19.25" r="19.25"/>
            <circle cx="19.25" cy="19.25" r="9.972"/>
            <circle fill="#FFFFFF" cx="12.608" cy="10.36" r="4.414"/>
        </svg>;
    
    private static const SHAPE_DATA:FShapeSVG = new FShapeSVG(SVG);
    
    private var _sprite:Sprite;
    
    //==========================================================================
    // メソッド
    //--------------------------------------------------------------------------

    /**
     * 新しい Eye クラスのインスタンスを作成します.
     */
    public function Eye()
    {
        _sprite = SHAPE_DATA.toSprite();
        _sprite.x = -_sprite.width / 2;
        _sprite.y = -_sprite.height / 2;
        addChild(_sprite);
    }
}