/**
 * Copyright Hrundik ( http://wonderfl.net/user/Hrundik )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bFKI
 */

package {
    import flash.ui.Mouse;
    import flash.filters.DropShadowFilter;
    import flash.filters.GlowFilter;
    import flash.filters.BlurFilter;
    import flash.events.MouseEvent;
    import flash.display.Shape;
    import flash.net.URLRequest;
    import flash.display.Loader;
    import flash.display.Graphics;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private var loader:Loader;
        private var blurredLoader:Loader;
        private var loaderMask:Shape;
        private var brush:Shape;
        private var isDrawing : Boolean;
        
        private function onMouseMove(e:MouseEvent):void
        {
            brush.x= e.localX;
            brush.y=e.localY;
            
            if (isDrawing)
            {
                loaderMask.graphics.beginFill(0);
                loaderMask.graphics.drawCircle(e.localX, e.localY, 30);
                loaderMask.graphics.endFill();
            }
        }
        
        private function onMouseDown(e:MouseEvent):void
        {
           isDrawing = true;
        }
        
        private function onMouseUp(e:MouseEvent) : void
        {
           isDrawing = false;
        }

        public function FlashTest() {
            Mouse.hide();
            
            loader = new Loader();
            loader.load(new URLRequest("https://www.google.com/logos/2012/rossini12-hp.jpg"));
            addChild(loader);
            
            loaderMask = new Shape();
            addChild(loaderMask);
            
            blurredLoader = new Loader();
            blurredLoader.load(new URLRequest("https://www.google.com/logos/2012/rossini12-hp.jpg"));
            addChild(blurredLoader);
            blurredLoader.filters = [new BlurFilter(10, 10)];
            blurredLoader.mask = loaderMask;
            
            brush = new Shape();
            var g:Graphics = brush.graphics;
            g.beginFill(0x000000);
            g.drawCircle(0, 0, 10);
            g.endFill();
            addChild(brush);
            
            brush.filters = [new DropShadowFilter(4, 45, 0xFFFFFF, 1, 4, 4, 1, 1, false, true)];
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            
            
        }
    }
}