/**
 * Copyright jong ( http://wonderfl.net/user/jong )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bF9a
 */

// forked from sion0303's 3DStar
/*
    星を作ってみました。
    星を作るときに使用可能なマテリアルと
    使用不可なマテリアルもあるみたいです。
    すべて確認してはいません。すみません・・
*/
package {
    import flash.events.Event;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.view.BasicView;
    [SWF(backgroundColor=0x0)]
    public class PV3D_Star extends BasicView
    {
        private var star:Star3D;
        private var cnt:Number;
        private var light:PointLight3D;
        public function PV3D_Star()
        {    
            cnt = 0;
            light = new PointLight3D();
            //var material:FlatShadeMaterial = new FlatShadeMaterial(light, 0xffff00, 0x111111, 50);
            var material:FlatShadeMaterial = new FlatShadeMaterial(light, 0x00ff00, 0x111111, 100);
            material.doubleSided = true;
            
            star = new Star3D(material);
            
            scene.addChild(star);
            
            graphics.beginFill(0x0);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            
            startRendering();
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        private function onEnterFrame(event:Event):void
        {            
            star.rotationZ+=2;
            cnt += 0.01;
            light.x = 1000 * Math.cos(cnt);
            light.z = 1000 * Math.sin(cnt);
        }
    }
}

import org.papervision3d.core.geom.TriangleMesh3D;
import org.papervision3d.core.geom.renderables.Triangle3D;
import org.papervision3d.core.geom.renderables.Vertex3D;
import org.papervision3d.core.proto.MaterialObject3D;
import org.papervision3d.objects.DisplayObject3D;

/* 3D星クラス */
class Star3D extends DisplayObject3D
{
    public var meshes:Array;            
    public var divide:int;            
    public var angle:Number;        
    private var radius:Number;        
    /*
        第一引数：マテリアル
        第二引数：大きさ
        第三引数：分割数
        第四引数：両面作成するかどうか
    */
    public function Star3D(material:MaterialObject3D=null, radius:Number=500, divide:int=5, side:Boolean=true)
    {
        // 大きさ
        if(radius < 10)
            this.radius = 10;
        else
            this.radius = radius;
        
        // 分割数
        this.divide = divide;
                
        // 角度
        // 分割数が3未満の場合
        if(divide < 3)
             this.angle = 360 / (3 * 2);
        // 分割数が3以上の場合
        else 
            this.angle = 360 / (divide * 2);
            
        // 片面だけ作るか両面作るか
        var num:int = 1;
        if(side)
            num = 2;
        
        // 星の作成
        meshes = [];
        for(var i:int = 0; i < num; i++) {
            for(var j:int = 0; j < divide * 2; j++) {
                var vertices:Array = [];
                var x1:Number;
                var y1:Number;
                var x2:Number;
                var y2:Number
                var p1:int;
                var p2:int;
                var vx:Number;
                var vy:Number;
                // 1つ目の頂点
                if(i % 2)
                    vertices.push(new Vertex3D(0, 0, radius/3));
                else
                    vertices.push(new Vertex3D(0, 0, -radius/3));
                
                if(j % 2) {
                    p1 = j;
                    p2 = j + 1;
                } else {
                    p1 = j + 1;
                    p2 = j;
                }
                // 2つ目の頂点
                x1 = radius / 2 * Math.cos(this.angle * p1 * Math.PI / 180);
                y1 = radius / 2 * Math.sin(this.angle * p1 * Math.PI / 180);
                vertices.push(new Vertex3D(x1, y1, 0));
                
                // 3つ目の頂点
                x2 = radius * Math.cos(this.angle * p2 * Math.PI / 180);
                y2 = radius * Math.sin(this.angle * p2 * Math.PI / 180);
                vertices.push(new Vertex3D(x2, y2, 0));
                
                // メッシュ作成
                var mesh:TriangleMesh3D = new TriangleMesh3D(material, [], []);
                
                // メッシュに頂点の配列を追加して頂点座標を指定
                mesh.geometry.vertices = vertices;
                
                // メッシュに面を追加
                mesh.geometry.faces.push(new Triangle3D(mesh, vertices));
                
                // メッシュを格納
                this.meshes.push(mesh);
                
                // DisplayObject3Dに追加
                this.addChild(mesh);
            }
        }
    }
}
