/**
 * Copyright UNDERCOVER ( http://wonderfl.net/user/UNDERCOVER )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bEkh
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.filters.*;
	import flash.geom.Rectangle;

	public class Main extends Sprite 
	{
		private var colors:Array = [0xE5E5D9, 0xF5DAAF, 0x252122, 0xFEA610];
		private var colorIndex:int
		private var oldPoint:Point
		private var bm:BitmapData
		private var radius:Number
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			bm = new BitmapData(500, 500, false, 0x000000);
			addChild(new  Bitmap(bm)) as Bitmap;
			oldPoint = new Point(mouseX, mouseY);
			stage.addEventListener(MouseEvent.MOUSE_MOVE,_move)

		}
		private function _move(e:MouseEvent):void {
			var newPoint:Point = new Point(mouseX, mouseY);
			var dist:Number = Point.distance(oldPoint, newPoint);
			if (dist>.1) {
				radius = 19-Math.min(16, dist);
				var dx:Number = new Point(mouseX, oldPoint.y).subtract(oldPoint).x;
				var dy:Number = new Point(oldPoint.x, mouseY).subtract(oldPoint).y;
				for (var i:int = 0; i<120; i++) {
					draws(mouseX+(dx*4)*Math.random(), mouseY+(dy*4)*Math.random(), radius*Math.random(),1);
				}
			}
			oldPoint = newPoint;

		}
		private function draws(x:Number, y:Number, radius:Number, color:Number):void {
			bm.lock();
			for (var i:int = -radius/2; i<radius/2; i++) {
				for (var j:int = -radius/2; j<radius/2; j++) {
					/*check if the point is within the circle*/
					if (Math.sqrt(i * i + j * j) < radius / 2) {
						bm.setPixel(x + i, y + j, colors[int(Math.random()*4)]);
					}
				}
			}
			bm.unlock();
		}	
	}
}