/**
 * Copyright clockmaker ( http://wonderfl.net/user/clockmaker )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bEUY
 */

// forked from mash's papervision3d simple example (cube)
/**
* ReflectionViewを使った反射バージョン
*/
package {
    import flash.events.*;
    import flash.filters.*;
    import flash.utils.*;
    import org.papervision3d.materials.shadematerials.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.core.effects.view.ReflectionView;
    import org.papervision3d.lights.*;

    [SWF(frameRate="60")]
    public class Main extends ReflectionView {

        public function Main() {
            // 立方体を作成します
            var cube:Cube = Cube(scene.addChild(new Cube(new MaterialsList(
            {
                all : new FlatShadeMaterial(new PointLight3D(), 0x2288CC, 0x004466)
            }))));
            
            // 反射を設定します
            surfaceHeight = -600
            viewportReflection.filters = [new BlurFilter(8, 8, 2)];
            viewportReflection.alpha = .4;
            
            // アニメーションを設定してます
            addEventListener(Event.ENTER_FRAME,function():void {
                cube.yaw(2)
                camera.y = 500 + 800 * Math.sin(getTimer() / 1000);
                singleRender()
            });
        }
    }
}
