/**
 * Copyright gaziya ( http://wonderfl.net/user/gaziya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bEQW
 */

package {
    import flash.geom.Point;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.events.Event;
    import flash.display.Shape;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            //graphics.beginFill(0x008833)                
            //graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight)
            opaqueBackground = 0x008833
            stage.frameRate = 60
            var bitmatData:BitmapData=new BitmapData(stage.stageWidth,stage.stageHeight,true,0x0)
            addChild(new Bitmap(bitmatData))
            var shape:Shape = new Shape
            shape.graphics.beginFill(0xff3300)
            shape.graphics.drawCircle(0,0,5)                
            var points:Vector.<Point> = new Vector.<Point>
            for (var i:int=0; i<4; i++) {
                points.push(new Point(stage.stageWidth*Math.random(), stage.stageHeight*Math.random()))
            }           
            var tightness:int = 60
            var n:int = 1
            addEventListener(Event.ENTER_FRAME,function(e:Event):void {
                var colorTransform:ColorTransform = new ColorTransform
                colorTransform.alphaMultiplier = 0.995
                bitmatData.colorTransform(bitmatData.rect, colorTransform)
                for (var i:int=0; i<4; i++) {
                    var matrix:Matrix = new Matrix
                    matrix.translate(points[i].x, points[i].y)
                    var color:ColorTransform = new ColorTransform
                    color.color = 0xff
                    bitmatData.draw(shape,matrix,color)
                }
                var px:Number = spline(points[0].x, points[1].x, points[2].x, points[3].x, n/tightness);
                var py:Number = spline(points[0].y, points[1].y, points[2].y, points[3].y, n/tightness);
                var matrix2:Matrix = new Matrix
                matrix2.translate(px, py)
                bitmatData.draw(shape,matrix2)                
                n++
                if (n>tightness) {
                    points.shift()
                    points.push(new Point(stage.stageWidth*Math.random(), stage.stageHeight*Math.random()))
                    n=1
                }
            })
            function spline(p0:Number, p1:Number, p2:Number, p3:Number, t:Number):Number {
                var v0:Number = (p2 - p0) * 0.5;
                var v1:Number = (p3 - p1) * 0.5;
                var t2:Number = t * t;
                var t3:Number = t2 * t;
                return (2 * p1 - 2 * p2 + v0 + v1) * t3 + ( -3 * p1 + 3 * p2 - 2 * v0 - v1) * t2 + v0 * t + p1;
            }      
        }
    }
}