/**
 * Copyright kawamura ( http://wonderfl.net/user/kawamura )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bEDU
 */

package 
{
    import net.hires.debug.Stats;
    import flash.display.Sprite;
    import flash.events.Event;
    
    /**
     * ...
     * @author jaiko
     */
    [SWF(width ="465" , height ="465" , frameRate ="60")]
    public class Main2 extends Sprite 
    {
        public function Main2():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            /*
            var loader:DataLoader = new DataLoader();
            loader.startPublic();
            */
            var viewManager:ViewManager = new ViewManager();
            addChild(viewManager);
            viewManager.init();
            /*
            var star:Starling = new Starling(StarlingManager, stage);
            star.start();
            */
                        var stats:Stats = new Stats();
            addChild(stats);
            
        }    
    }
}
import flash.display.Graphics;
import flash.display.Shape;
import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.utils.clearInterval;
import flash.utils.setInterval;
import flash.utils.setTimeout;

/**
 * ...
 * @author jaiko
 */
class ViewManager extends Sprite 
{
    private var posionList:Array = [[236.4 , 453.15, 0.109375,true], [225.45 , 452.95, 0.23828125,true], [210.45 , 451.85, 0.4140625,true], [200.55 , 450.5, 0.53125,true], [189.75 , 448.55, 0.66015625,true], [180.95 , 446.55, 0.765625,true], [173.25 , 444.45, 0.859375,true], [165.6 , 442.1, 0.953125,true], [158.05 , 439.45, 1], [150.6 , 436.55, 1], [143.25 , 433.4, 1], [136.05 , 429.95, 1], [128.95 , 426.25, 1], [122 , 422.3, 1], [115.2 , 418.05, 1], [108.55 , 413.6, 1], [102.05 , 408.9, 1], [95.75 , 404, 1], [89.65 , 398.85, 1], [83.7 , 393.45, 1], [78 , 387.85, 1], [72.5 , 382.1, 1], [67.2 , 376.1, 1], [59.65 , 366.75, 1], [50.95 , 354.5, 1], [42.65 , 340.85, 1], [35.35 , 326.6, 1], [29.5 , 312.8, 1], [24.6 , 298.65, 1], [21.35 , 287.1, 1], [19 , 276.35, 1], [16.6 , 261.55, 1], [15.2 , 245.6, 1], [14.95 , 229.6, 1], [15.8 , 214.65, 1], [17.85 , 198.75, 1], [20.85 , 184.05, 1], [25.1 , 168.65, 1], [30.15 , 154.55, 1], [36.15 , 140.8, 1], [43.1 , 127.5, 1], [50.95 , 114.7, 1], [59.05 , 103.3, 1], [67.2 , 93.2, 1], [77.35 , 82.15, 1], [89 , 71.2, 1], [100.65 , 61.7, 1], [112.9 , 53.1, 1], [125.75 , 45.35, 1], [140 , 38.05, 1], [153.8 , 32.25, 1], [168 , 27.35, 1], [182.5 , 23.5, 1], [197.2 , 20.65, 1], [212.1 , 18.85, 1], [227.1 , 18.1, 1], [242.1 , 18.4, 1], [258 , 19.85, 1], [272.8 , 22.3, 1], [287.4 , 25.8, 1], [301.7 , 30.3, 1], [315.65 , 35.75, 1], [330.1 , 42.7, 1], [343.95 , 50.65, 1], [357.15 , 59.65, 1], [368.15 , 68.3, 1], [379.3 , 78.4, 1], [390.35 , 89.95, 1], [399.85 , 101.5, 1], [409.1 , 114.55, 1], [416.9 , 127.4, 1], [423.7 , 140.75, 1], [429.95 , 155.5, 1], [434.75 , 169.7, 1], [438.55 , 184.2, 1], [441.3 , 198.95, 1], [443 , 213.85, 1], [443.65 , 228.85, 1], [443.25 , 243.8, 1], [441.75 , 258.75, 1], [439.2 , 273.5, 1], [435.6 , 288.1, 1], [431 , 302.35, 1], [425 , 317.15, 1], [418.3 , 330.6, 1], [411.8 , 341.85, 1], [404 , 353.45, 1], [394.8 , 365.3, 1], [386.15 , 375.05, 1], [376.95 , 384.2, 1], [371 , 389.55, 1], [364.85 , 394.65, 1], [358.5 , 399.55, 1], [351.95 , 404.15, 1], [345.3 , 408.55, 1], [338.4 , 412.65, 1], [331.4 , 416.5, 1], [324.25 , 420.1, 1], [316.95 , 423.4, 1], [309.55 , 426.4, 1], [302.05 , 429.15, 1], [294.45 , 431.6, 1], [286.75 , 433.75, 1], [278.95 , 435.6, 1], [271.1 , 437.15, 1], [263.2 , 438.4, 1], [255.25 , 439.35, 1], [247.3 , 440, 1], [235.3 , 440.4, 1], [219.3 , 439.85, 1], [204.4 , 438.2, 1], [189.65 , 435.5, 1], [175.15 , 431.7, 1], [160 , 426.55, 1], [146.2 , 420.65, 1], [132.85 , 413.75, 1], [119.25 , 405.4, 1], [107.1 , 396.6, 1], [95.6 , 386.95, 1], [84.85 , 376.5, 1], [74.25 , 364.5, 1], [64.65 , 351.75, 1], [56.55 , 339.1, 1], [49.35 , 325.95, 1], [42.8 , 311.35, 1], [37.7 , 297.25, 1], [33.65 , 282.85, 1], [30.65 , 268.15, 1], [28.75 , 253.25, 1], [27.9 , 238.3, 1], [28.25 , 222.3, 1], [29.85 , 206.35, 1], [32.45 , 191.6, 1], [36.15 , 177.05, 1], [40.9 , 162.85, 1], [46.65 , 149, 1], [53.95 , 134.75, 1], [61.75 , 121.95, 1], [71.1 , 109, 1], [80.8 , 97.5, 1], [92 , 86.1, 1], [104.05 , 75.65, 1], [116.95 , 66.15, 1], [129.65 , 58.15, 1], [142.9 , 51.2, 1], [156.65 , 45.2, 1], [171.8 , 39.95, 1], [187.25 , 35.9, 1], [202 , 33.25, 1], [216.95 , 31.7, 1], [232.9 , 31.25, 1], [247.9 , 32, 1], [263.75 , 34.05, 1], [278.45 , 37.1, 1], [292.85 , 41.2, 1], [306.95 , 46.4, 1], [321.45 , 53.1, 1], [334.55 , 60.4, 1], [347.9 , 69.25, 1], [359.7 , 78.5, 1], [370.8 , 88.6, 1], [381.75 , 100.25, 1], [389.9 , 110.35, 1], [399.05 , 123.5, 1], [405.7 , 134.65, 1], [412.45 , 148.05, 1], [418.15 , 161.95, 1], [423.05 , 177.15, 1], [426.5 , 191.75, 1], [429 , 207.55, 1], [430.15 , 222.5, 1], [430.15 , 237.5, 1], [429.05 , 252.45, 1], [426.8 , 267.25, 1], [423.2 , 282.85, 1], [418.65 , 297.15, 1], [413.05 , 311.05, 1], [405.9 , 325.35, 1], [397.65 , 339.05, 1], [388.9 , 351.25, 1], [379.25 , 362.7, 1], [368.75 , 373.45, 1], [357.45 , 383.3, 1], [344.65 , 392.85, 1], [331.95 , 400.85, 1], [318.65 , 407.8, 1], [304.9 , 413.75, 1], [289.75 , 418.9, 1], [274.2 , 422.8, 1], [258.45 , 425.4, 1], [243.5 , 426.65, 1], [228.5 , 426.75, 1], [212.55 , 425.6, 1], [197.75 , 423.3, 1], [183.15 , 419.9, 1], [167.9 , 415, 1], [153.1 , 408.85, 1], [139.75 , 402.05, 1], [127 , 394.2, 1], [114.85 , 385.4, 1], [103.45 , 375.65, 1], [94.2 , 366.5, 1], [85.6 , 356.8, 1], [76.5 , 344.85, 1], [69.35 , 334, 1], [62.1 , 320.85, 1], [55.5 , 306.3, 1], [51.05 , 294.1, 1], [47.2 , 280.65, 1], [44.15 , 265.95, 1], [42.9 , 257.05, 1], [42.15 , 249.05, 1], [41.7 , 241.1, 1], [41.6 , 233.1, 1], [41.85 , 225.1, 1], [42.4 , 217.1, 1], [43.3 , 209.15, 1], [44.55 , 201.25, 1], [46.1 , 193.4, 1], [48 , 185.65, 1], [50.25 , 177.95, 1], [52.8 , 170.35, 1], [55.65 , 162.9, 1], [58.8 , 155.55, 1], [62.3 , 148.35, 1], [66.05 , 141.3, 1], [70.15 , 134.4, 1], [74.5 , 127.7, 1], [81.55 , 118, 1], [91.2 , 106.55, 1], [102.5 , 95.2, 1], [114.7 , 84.85, 1], [126.9 , 76.1, 1], [140.6 , 67.9, 1], [154.05 , 61.25, 1], [168 , 55.75, 1], [183.3 , 51.1, 1], [197.95 , 47.9, 1], [213.8 , 45.85, 1], [228.8 , 45.15, 1], [243.8 , 45.6, 1], [259.65 , 47.45, 1], [275.35 , 50.65, 1], [290.7 , 55.15, 1], [305.6 , 61, 1], [319.05 , 67.6, 1], [331.95 , 75.25, 1], [345 , 84.5, 1], [356.4 , 94.2, 1], [367.05 , 104.8, 1], [376.8 , 116.2, 1], [385.55 , 128.35, 1], [393.35 , 141.2, 1], [400.05 , 154.6, 1], [405.6 , 168.5, 1], [410.05 , 182.85, 1], [413.5 , 198.45, 1], [415.6 , 214.3, 1], [416.25 , 229.3, 1], [415.65 , 245.3, 1], [413.8 , 260.15, 1], [410.75 , 274.85, 1], [406.2 , 290.2, 1], [400.3 , 305.05, 1], [393.6 , 318.5, 1], [385.3 , 332.15, 1], [376.45 , 344.25, 1], [365.95 , 356.3, 1], [355.15 , 366.75, 1], [343.55 , 376.25, 1], [330.4 , 385.3, 1], [317.35 , 392.7, 1], [303.7 , 399, 1], [289.65 , 404.1, 1], [275.15 , 408.1, 1], [260.45 , 410.85, 1], [244.5 , 412.4, 1], [228.5 , 412.55, 1], [213.55 , 411.4, 1], [198.75 , 409.05, 1], [184.2 , 405.4, 1], [170 , 400.6, 1], [155.35 , 394.2, 1], [141.35 , 386.5, 1], [128.85 , 378.15, 1], [116.4 , 368.15, 1], [105.55 , 357.8, 1], [95 , 345.75, 1], [86.1 , 333.7, 1], [78.25 , 320.9, 1], [71.55 , 307.5, 1], [65.95 , 293.6, 1], [61.6 , 279.25, 1], [58.45 , 264.6, 1], [56.45 , 248.7, 1], [55.9 , 232.7, 1], [56.75 , 217.75, 1], [58.8 , 202.9, 1], [62.4 , 187.3, 1], [67.05 , 173.05, 1], [72.9 , 159.25, 1], [79.95 , 146, 1], [88.05 , 133.4, 1], [97.85 , 120.75, 1], [108.8 , 109.05, 1], [119.95 , 99.05, 1], [131.95 , 90.05, 1], [144.65 , 82.1, 1], [158.9 , 74.9, 1], [172.85 , 69.3, 1], [187.2 , 64.95, 1], [201.85 , 61.9, 1], [217.75 , 60, 1], [232.75 , 59.6, 1], [248.7 , 60.55, 1], [263.55 , 62.8, 1], [278.1 , 66.35, 1], [292.3 , 71.15, 1], [306.95 , 77.6, 1], [320.05 , 84.85, 1], [332.5 , 93.25, 1], [344.9 , 103.35, 1], [355.65 , 113.8, 1], [366 , 126, 1], [374.65 , 138.25, 1], [382.2 , 151.2, 1], [388.6 , 164.75, 1], [394.05 , 179.8, 1], [398.1 , 195.25, 1], [400.5 , 210.05, 1], [401.65 , 225, 1], [401.45 , 240, 1], [399.75 , 255.9, 1], [396.8 , 270.6, 1], [392.55 , 285, 1], [387.05 , 298.95, 1], [380.35 , 312.35, 1], [372.45 , 325.1, 1], [362.8 , 337.9, 1], [352.75 , 348.95, 1], [341.7 , 359.1, 1], [329.75 , 368.2, 1], [316.2 , 376.7, 1], [302.8 , 383.45, 1], [287.95 , 389.3, 1], [272.55 , 393.7, 1], [257.8 , 396.45, 1], [241.9 , 397.9, 1], [225.9 , 397.8, 1], [210.95 , 396.3, 1], [195.3 , 393.25, 1], [179.95 , 388.65, 1], [166.05 , 383.05, 1], [152.7 , 376.15, 1], [139.25 , 367.55, 1], [126.7 , 357.65, 1], [115.85 , 347.3, 1], [106 , 336, 1], [97.2 , 323.85, 1], [89.1 , 310.05, 1], [82.4 , 295.5, 1], [77.45 , 281.35, 1], [73.6 , 265.85, 1], [71.45 , 251, 1], [70.65 , 235.05, 1], [71.3 , 220.05, 1], [73.55 , 204.2, 1], [77.1 , 189.65, 1], [81.95 , 175.45, 1], [88.1 , 161.8, 1], [95.5 , 148.75, 1], [104.7 , 135.65, 1], [114.5 , 124.3, 1], [125.3 , 113.9, 1], [137 , 104.55, 1], [149.55 , 96.35, 1], [162.8 , 89.35, 1], [176.7 , 83.65, 1], [192 , 79, 1], [207.7 , 75.95, 1], [223.6 , 74.5, 1], [238.6 , 74.55, 1], [254.5 , 76.25, 1], [269.2 , 79.25, 1], [284.45 , 84, 1], [298.3 , 89.85, 1], [311.5 , 96.95, 1], [324.75 , 105.9, 1], [336.25 , 115.5, 1], [347.5 , 126.9, 1], [356.9 , 138.55, 1], [365.2 , 151.05, 1], [372.2 , 164.3, 1], [377.9 , 178.2, 1], [382.25 , 192.55, 1], [385.3 , 208.2, 1], [386.7 , 223.15, 1], [386.6 , 239.15, 1], [385 , 254.05, 1], [381.95 , 268.75, 1], [377.5 , 283.05, 1], [371.25 , 297.75, 1], [363.45 , 311.75, 1], [354.9 , 324.05, 1], [345.15 , 335.45, 1], [333.6 , 346.5, 1], [320.9 , 356.25, 1], [308.2 , 364.15, 1], [293.8 , 371.15, 1], [278.75 , 376.6, 1], [263.25 , 380.45, 1], [248.4 , 382.55, 1], [232.4 , 383.15, 1], [216.45 , 382, 1], [201.7 , 379.45, 1], [186.3 , 375.1, 1], [171.45 , 369.15, 1], [157.35 , 361.6, 1], [144.9 , 353.25, 1], [133.4 , 343.65, 1], [122.2 , 332.2, 1], [112.35 , 319.6, 1], [104.35 , 306.95, 1], [97.7 , 293.5, 1], [92.45 , 279.45, 1], [88.45 , 263.95, 1], [86.25 , 249.15, 1], [85.55 , 234.15, 1], [86.5 , 218.2, 1], [89.15 , 202.45, 1], [93.2 , 188, 1], [98.75 , 174.05, 1], [106.15 , 159.9, 1], [115.1 , 146.65, 1], [124.75 , 135.15, 1], [135.55 , 124.75, 1], [147.35 , 115.5, 1], [160.9 , 107.05, 1], [174.4 , 100.5, 1], [188.5 , 95.4, 1], [204.05 , 91.65, 1], [218.9 , 89.7, 1], [234.9 , 89.35, 1], [249.85 , 90.6, 1], [264.55 , 93.45, 1], [279.85 , 98.2, 1], [294.5 , 104.6, 1], [308.35 , 112.6, 1], [320.4 , 121.5, 1], [331.5 , 131.6, 1], [342.05 , 143.6, 1], [350.65 , 155.85, 1], [357.9 , 169, 1], [363.75 , 182.8, 1], [368.05 , 197.15, 1], [370.8 , 211.9, 1], [371.95 , 227.85, 1], [371.4 , 242.85, 1], [369.2 , 257.65, 1], [365.45 , 272.2, 1], [360.15 , 286.2, 1], [352.85 , 300.45, 1], [344.6 , 312.95, 1], [334.3 , 325.2, 1], [323.45 , 335.55, 1], [311.55 , 344.6, 1], [298.7 , 352.35, 1], [284.15 , 359, 1], [269.9 , 363.65, 1], [255.2 , 366.7, 1], [239.3 , 368.2, 1], [224.3 , 367.85, 1], [209.45 , 365.85, 1], [193.95 , 361.95, 1], [179.9 , 356.65, 1], [166.6 , 349.8, 1], [154.1 , 341.5, 1], [141.85 , 331.2, 1], [131.6 , 320.3, 1], [122.05 , 307.45, 1], [114.55 , 294.45, 1], [108.6 , 280.7, 1], [103.95 , 265.4, 1], [101.2 , 249.65, 1], [100.4 , 233.7, 1], [101.35 , 218.7, 1], [104.3 , 203, 1], [109.1 , 187.75, 1], [115.25 , 174.1, 1], [123.45 , 160.35, 1], [132.65 , 148.5, 1], [143.15 , 137.8, 1], [155.6 , 127.8, 1], [168.35 , 119.85, 1], [181.9 , 113.45, 1], [196.1 , 108.65, 1], [210.75 , 105.55, 1], [225.65 , 104.15, 1], [240.65 , 104.5, 1], [255.5 , 106.6, 1], [270 , 110.4, 1], [283.95 , 115.9, 1], [297.15 , 123, 1], [308.65 , 131, 1], [319.9 , 140.9, 1], [329.9 , 152.05, 1], [339.05 , 165.2, 1], [346.05 , 178.45, 1], [351.1 , 191.5, 1], [354.85 , 206, 1], [356.9 , 220.85, 1], [357.15 , 234.85, 1], [355.85 , 248.75, 1], [352.95 , 262.45, 1], [348.55 , 275.75, 1], [342.7 , 288.45, 1], [334.9 , 301.25, 1], [326.25 , 312.25, 1], [315.65 , 322.85, 1], [304.65 , 331.5, 1], [291.85 , 339.35, 1], [278.2 , 345.55, 1], [264.9 , 349.8, 1], [250.15 , 352.6, 1], [236.2 , 353.6, 1], [221.25 , 352.85, 1], [207.45 , 350.45, 1], [194 , 346.5, 1], [180.25 , 340.6, 1], [168.15 , 333.55, 1], [157 , 325.15, 1], [146.15 , 314.75, 1], [137.35 , 303.9, 1], [129.85 , 292.1, 1], [123.8 , 279.45, 1], [119.25 , 266.25, 1], [116.3 , 252.55, 1], [115.05 , 238.6, 1], [115.4 , 224.65, 1], [117.45 , 210.8, 1], [121.1 , 197.3, 1], [126.4 , 184.3, 1], [133.15 , 172.1, 1], [141.35 , 160.75, 1], [150.85 , 150.5, 1], [161.55 , 141.45, 1], [173.25 , 133.75, 1], [184.85 , 127.95, 1], [196.1 , 123.75, 1], [209.65 , 120.4, 1], [223.55 , 118.75, 1], [237.55 , 118.8, 1], [251.45 , 120.55, 1], [265 , 124, 1], [277.1 , 128.7, 1], [288.6 , 134.7, 1], [299.35 , 142.05, 1], [309.85 , 151.25, 1], [319.15 , 161.7, 1], [327.1 , 173.25, 1], [333.5 , 185.7, 1], [338.3 , 198.8, 1], [341.45 , 212.45, 1], [342.8 , 226.4, 1], [342.4 , 240.35, 1], [340.25 , 254.2, 1], [336.3 , 267.6, 1], [330.75 , 280.45, 1], [323.55 , 292.45, 1], [314.9 , 303.45, 1], [305.65 , 312.6, 1], [294.55 , 321.1, 1], [282.45 , 328.15, 1], [270.5 , 333.2, 1], [257.05 , 337, 1], [243.2 , 339, 1], [229.2 , 339.2, 1], [216.3 , 337.75, 1], [203.65 , 334.75, 1], [191.5 , 330.2, 1], [179.95 , 324.2, 1], [169.25 , 316.85, 1], [159.55 , 308.25, 1], [150.35 , 297.7, 1], [143.15 , 286.9, 1], [137.35 , 275.25, 1], [133.3 , 263.95, 1], [130.4 , 251.3, 1], [129.1 , 238.35, 1], [129.5 , 225.4, 1], [131.7 , 211.55, 1], [135.75 , 198.2, 1], [141.55 , 185.45, 1], [147.9 , 175.3, 1], [156.05 , 165.2, 1], [165.45 , 156.2, 1], [175.9 , 148.5, 1], [186.35 , 142.6, 1], [197.45 , 138, 1], [209 , 134.8, 1], [220.85 , 132.95, 1], [232.85 , 132.5, 1], [245.75 , 133.7, 1], [258.45 , 136.55, 1], [270.65 , 141, 1], [282.15 , 147.05, 1], [292.75 , 154.5, 1], [303 , 164.05, 1], [311.15 , 174.15, 1], [317.95 , 185.25, 1], [323.2 , 197.1, 1], [326.85 , 209.6, 1], [328.75 , 222.45, 1], [328.95 , 235.4, 1], [327.2 , 249.3, 1], [323.45 , 262.8, 1], [318.25 , 274.7, 1], [311.5 , 285.8, 1], [303.3 , 295.85, 1], [293.8 , 304.7, 1], [283.15 , 312.15, 1], [271.6 , 318.1, 1], [259.35 , 322.4, 1], [246.6 , 324.95, 1], [233.65 , 325.75, 1], [220.7 , 324.7, 1], [208.05 , 321.9, 1], [195.85 , 317.3, 1], [184.45 , 311.1, 1], [174.05 , 303.3, 1], [164.85 , 294.15, 1], [157.05 , 283.75, 1], [150.8 , 272.4, 1], [146.5 , 261.2, 1], [143.55 , 248.55, 1], [142.5 , 235.6, 1], [143.3 , 222.6, 1], [145.95 , 209.9, 1], [150.4 , 197.7, 1], [156.6 , 186.3, 1], [164.4 , 175.9, 1], [173.6 , 166.75, 1], [184.05 , 159.05, 1], [195.55 , 153, 1], [207.8 , 148.7, 1], [220.55 , 146.3, 1], [234.55 , 145.8, 1], [247.45 , 147.4, 1], [259 , 150.55, 1], [270.9 , 155.75, 1], [281.9 , 162.7, 1], [291.7 , 171.25, 1], [300.05 , 181.15, 1], [306.85 , 192.25, 1], [311.85 , 204.25, 1], [314.95 , 216.85, 1], [316.05 , 228.8, 1], [315.4 , 240.75, 1], [312.8 , 253.45, 1], [308.25 , 265.65, 1], [301.85 , 276.95, 1], [293.75 , 287.1, 1], [284.2 , 295.85, 1], [274.2 , 302.5, 1], [263.35 , 307.6, 1], [251.85 , 311.05, 1], [239 , 312.8, 1], [226 , 312.5, 1], [213.25 , 310.1, 1], [201.05 , 305.65, 1], [189.75 , 299.3, 1], [180.35 , 291.85, 1], [172.15 , 283.05, 1], [165.4 , 273.15, 1], [160.3 , 262.3, 1], [156.65 , 249.85, 1], [155.15 , 237.95, 1], [155.55 , 225.95, 1], [158.05 , 213.25, 1], [162.25 , 202, 1], [168.1 , 191.55, 1], [176.25 , 181.45, 1], [185.2 , 173.45, 1], [195.3 , 166.95, 1], [206.25 , 162.15, 1], [217.9 , 159.2, 1], [228.8 , 158.1, 1], [241.8 , 158.95, 1], [253.45 , 161.7, 1], [265.4 , 166.8, 1], [275.45 , 173.3, 1], [284.35 , 181.35, 1], [292.35 , 191.55, 1], [298 , 202.15, 1], [301.8 , 213.5, 1], [303.7 , 225.35, 1], [303.6 , 237.3, 1], [301.45 , 249.1, 1], [297.8 , 259.45, 1], [291.45 , 270.8, 1], [283.15 , 280.75, 1], [273.95 , 288.45, 1], [263.55 , 294.45, 1], [253.3 , 298.35, 1], [241.5 , 300.6, 1], [229.55 , 300.85, 1], [217.7 , 298.95, 1], [205.45 , 294.6, 1], [195.1 , 288.6, 1], [185.95 , 280.85, 1], [178.35 , 271.6, 1], [172.5 , 261.15, 1], [168.65 , 249.8, 1], [166.9 , 237.95, 1], [167.3 , 225.95, 1], [169.9 , 214.25, 1], [174.6 , 203.25, 1], [180.6 , 194.05, 1], [188.1 , 186, 1], [197.7 , 178.85, 1], [208.5 , 173.6, 1], [220.05 , 170.45, 1], [232 , 169.55, 1], [243.9 , 170.95, 1], [255.3 , 174.55, 1], [265.85 , 180.3, 1], [274.35 , 187.25, 1], [282.05 , 196.45, 1], [287.8 , 206.95, 1], [291.6 , 219.35, 1], [292.7 , 232.3, 1], [291.2 , 244.15, 1], [287.35 , 255.5, 1], [281.35 , 265.85, 1], [273.35 , 274.8, 1], [263.7 , 281.95, 1], [252.85 , 286.95, 1], [241.15 , 289.6, 1], [228.2 , 289.75, 1], [216.45 , 287.25, 1], [206.4 , 282.9, 1], [196.6 , 276, 1], [189.05 , 268, 1], [182.4 , 256.9, 1], [178.65 , 245.5, 1], [177.5 , 233.6, 1], [178.9 , 221.7, 1], [182.9 , 210.4, 1], [188.6 , 201.05, 1], [196.9 , 192.4, 0.921875], [206.9 , 185.8, 0.828125], [218.1 , 181.6, 0.734375], [227.95 , 180.1, 0.65625], [235.95 , 180.25, 0.59375], [246.7 , 182.45, 0.5078125], [256.75 , 186.85, 0.421875], [265.65 , 193.3, 0.3359375], [273 , 201.5, 0.25], [278.4 , 211.05, 0.1640625], [281.4 , 220.55, 0.0859375], [282.5 , 230.5, 0.0078125]];
    private var scx:Number;
    private var scy:Number;
    private var textList:Array;
    private var id:uint;
    private var shakeID:uint;
    private var tripleID:uint;
    private var check:Boolean = true;
    private var startCount:Number = 0;
    private var searchWord:SearchWord = new SearchWord();
    private var wordList:Array = [];
    public function ViewManager() 
    {
        
    }
    public function init():void
    {
        scx = stage.stageWidth * 0.5;
        scy = stage.stageHeight * 0.5;
        //
        textList = [];
        searchWord.addEventListener(TwitterEvent.COMPLETE, initCompleteListener);
        searchWord.seach();
        stage.addEventListener(MouseEvent.CLICK, clickListener);
        
        //
    }
    private function initCompleteListener(event:TwitterEvent):void
    {
        check = true;
        textList = textList.concat(event.stringList);
        if (textList.length > 1000) {
            setPosition();
            searchWord.removeEventListener(TwitterEvent.COMPLETE, initCompleteListener);
            searchWord.addEventListener(TwitterEvent.COMPLETE, completeListener);
            shakeID = setInterval(shakeClosure, 2000);
        }else {
            searchWord.seach();
        }
    }
    private function setPosition():void
    {
        
        var word:Word;
        var i:uint;
        var n:uint;
        //
        n = posionList.length;
        for (i = 0; i < n; i++) {
            word = new Word();
            addChild(word);
            word.x = posionList[i][0];
            word.y = posionList[i][1];
            word.start(textList.shift(),posionList[i][3]);
            word.alpha = posionList[i][2];
            wordList.push(word);
            word.addEventListener(WordEvent.COMPLETE, wordCompleteListener);
        }
    }
    private function shakeClosure():void 
    {
        shake();
        setTimeout(shake, 150);
        setTimeout(shake, 300);
    }
    private function shake():void
    {
        var i:uint;
        var n:uint;
        var word:Word;
        n = wordList.length;
        for (i = 0; i < n; i++) {
            word = wordList[i];
            word.shake(10*(n-i));
        }
    }
    private function clickListener(e:MouseEvent):void 
    {
        var serchWord:SearchWord = new SearchWord();
        serchWord.seach();
        serchWord.addEventListener(TwitterEvent.COMPLETE, function(event:TwitterEvent):void {
            var xml:XML = event.xml;
        });
    }
    private function completeListener(event:TwitterEvent):void 
    {
        check = true;
        textList = textList.concat(event.stringList);
    }

    private function startClosure():void
    {
        var word:Word;
        word = new Word();
        addChild(word);
        //
        startCount += 0.005;
        if (startCount > 2 * Math.PI) {
            startCount -= 2 * Math.PI;
        }
        
        word.x = scx + 50 * Math.cos(startCount);
        word.y = scy + 50 * Math.sin(startCount);
        wordList.push(word);
        word.addEventListener(WordEvent.COMPLETE, wordCompleteListener);
        word.start(textList.shift());
        if (textList.length < 30 && check)
        {
            check = false;
            searchWord.seach();
        }else if (textList.length == 0) {
            clearInterval(id);
        }
    }
    
    private function wordCompleteListener(event:WordEvent):void 
    {
        var word:Word;
        word = wordList.shift();
        word.removeEventListener(WordEvent.COMPLETE, wordCompleteListener);
        removeChild(word);
        //
        startClosure();
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
import flash.display.Shape;
import flash.display.Sprite;
import flash.events.Event;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.utils.clearTimeout;
import flash.utils.setInterval;
import flash.utils.setTimeout;
/**
 * ...
 * @author jaiko
 */
class Word extends Sprite
{
    public var textData:String;
    private var K:Number = 0.05;
    private var U:Number = 0.1;
    private var removeFlag:Boolean = true;
    private var count:uint;
    private var scx:Number;
    private var scy:Number;
    private var _x:Number;
    private var _y:Number;
    private var _vx:Number = 0;
    private var _vy:Number = 0;
    private var _kx:Number = 0;
    private var _ky:Number = 0;
    private var _scale:Number = 1;
    private var _vscale:Number = 0;
    private var _v:Number = -1;
    private var shakeValue:Number = 0;
    private var id:uint;
    public function Word() 
    {
        
    }
    public function shake(time:Number):void
    {
        id = setTimeout(setShakeClouser, time);
    }
    
    private function setShakeClouser():void
    {
        var theta:Number = Math.atan2( _y - scy , _x - scx);
        _vx += shakeValue * Math.cos(theta);
        _vy += shakeValue * Math.sin(theta);
        
        _vscale = 0.2;
    }
    
    
    public function start(string:String,flag:Boolean = false):void 
    {
        textData = string;
        var tf:TextField = new TextField();
        
        var format:TextFormat = new TextFormat();
        format.size = 32;
        tf.defaultTextFormat = format;
        tf.text = string;
        
        var bmd:BitmapData = new BitmapData(tf.textWidth+5, tf.textHeight+5,true,0x00FFFFFF);
        bmd.draw(tf);
        var bm:Bitmap = new Bitmap(bmd, "auto", true);
        addChild(bm);
        bm.x = bm.width * -0.5;
        bm.y = bm.height * -0.5;
        bm.scaleX = bm.scaleY = 1/2;
        //
        _x = this.x;
        _y = this.y;
        //
        scx = stage.stageWidth * 0.5;
        scy = stage.stageHeight * 0.5;
        
        count = 0;
        enterFrameListener();
        addEventListener(Event.ENTER_FRAME, enterFrameListener);
        
        if (flag) {
            removeFlag = false;
            addEventListener(Event.ENTER_FRAME, removeEnterFrameListener);
        }else {
            this.alpha = 0;
            addEventListener(Event.ENTER_FRAME, startEnterFrameListener);
        }
    }
    
    private function startEnterFrameListener(e:Event):void 
    {
        this.alpha += 0.01;
        if (this.alpha >= 1) {
            this.alpha = 1;
            removeEventListener(Event.ENTER_FRAME, startEnterFrameListener);
        }
    }
    
    private function enterFrameListener(event:Event = null):void 
    {
        //count++;
        var R:Number = Math.sqrt(Math.pow(scx - _x, 2) + Math.pow(scy - _y, 2));
        var theta:Number = Math.atan2( _y - scy , _x - scx) +0.025 * (1 - (R / 300));
        /**/
        if (R > 220 && removeFlag) {
            removeFlag = false;
            addEventListener(Event.ENTER_FRAME, removeEnterFrameListener);
        }
        
        /**/
        _x += _v * -Math.sin(theta);
        _y += _v * Math.cos(theta);

        var ax:Number = K * (0 - _kx);
        var ay:Number = K * (0 - _ky);
        
        _vx += ax - U * _vx;
        _vy += ay - U * _vy;
        
        _kx += _vx;
        _ky += _vy;
        
        var ascale:Number = K * (1 - _scale);
        _vscale += ascale - U * _vscale;
        _scale += _vscale;
        
        this.x = _x  +_kx;
        this.y = _y  +_ky;
        
        this.scaleX = _scale;
        this.scaleY = _scale;
        this.rotation = 90 + theta * 180/Math.PI;
    }
    
    
    private function removeEnterFrameListener(e:Event):void 
    {
        this.alpha -= 0.01;
        if (this.alpha < 0.01) {
            clearTimeout(id);
            removeEventListener(Event.ENTER_FRAME, enterFrameListener);
            removeEventListener(Event.ENTER_FRAME, removeEnterFrameListener);
            //
            var wordEvent:WordEvent = new WordEvent(WordEvent.COMPLETE);
            dispatchEvent(wordEvent);
        }
    }
}
import flash.events.Event;

/**
 * ...
 * @author jaiko
 */
class WordEvent extends Event 
{
    public static const COMPLETE:String = "complete";
    public function WordEvent(type:String, bubbles:Boolean=false, cancelable:Boolean=false) 
    { 
        super(type, bubbles, cancelable);
        
    } 
    
    public override function clone():Event 
    { 
        return new WordEvent(type, bubbles, cancelable);
    } 
    
    public override function toString():String 
    { 
        return formatToString("WordEvent", "type", "bubbles", "cancelable", "eventPhase"); 
    }
    
}

import flash.events.Event;
import flash.events.EventDispatcher;
import flash.net.URLLoader;
import flash.net.URLRequest;
/**
 * ...
 * @author jaiko
 */
class DataLoader extends EventDispatcher
{
    
    public function DataLoader()
    {
        
    }
    public function startTag( tag:String ):void
    {
        var loader:URLLoader = new URLLoader();
        var url:String = "http://search.twitter.com/search.atom?q=" + tag;
        var request:URLRequest = new URLRequest(url);
        loader.addEventListener(Event.COMPLETE, completeListener);
        loader.load(request);
    }
    
    public function startPublic():void
    {
        var loader:URLLoader = new URLLoader();
        //var url:String = "http://www.shink.org/twitter/xmlloader.php";
        //var url:String = "http://crossdomain-proxy.appspot.com/?url=http://api.twitter.com/statuses/public_timeline.xml";
        var url:String = "http://api.twitter.com/statuses/public_timeline.xml";
        var request:URLRequest = new URLRequest(url);
        loader.addEventListener(Event.COMPLETE, completeListener);
        loader.load(request);
    }
    
    private function completeListener(event:Event):void 
    {
        var xml:XML;
        var ns:Namespace;
        var i:uint;
        var n:uint;
        xml = new XML(event.currentTarget.data);
        //
        var twitterEvent:TwitterEvent = new TwitterEvent(TwitterEvent.COMPLETE);
        twitterEvent.xml = xml;
        dispatchEvent(twitterEvent);
    }
}

import flash.events.EventDispatcher;
/**
 * ...
 * @author jaiko
 */
class SearchWord extends EventDispatcher
{
    private var searchWords:Array = ["adobe", "flash", "cs6", "as3"];
    private var searchCount:uint = 0;
    private var loader:DataLoader = new DataLoader();
    
    public function SearchWord() 
    {
        loader.addEventListener(TwitterEvent.COMPLETE, completeListener);
    }
    private function parser(xml:XML):Array
    {
        var i:uint;
        var j:uint;
        var n:uint;
        var m:uint;
        var ns:Namespace = new Namespace("http://www.w3.org/2005/Atom");
        var stringList:Array = [];
        var string:String;
        
        n = xml.ns::entry.length();
        for (i = 0; i < n; i++) {
            string = xml.ns::entry[i].ns::title;
            m = string.length;
            for (j = 0; j < m; j++) {
                stringList.push( string.substr(j, 1) );
            }
        }
        return stringList;
    }
    private function completeListener(event:TwitterEvent):void 
    {
        var stringList:Array = parser(event.xml);

        var twitterEvent:TwitterEvent = new TwitterEvent(TwitterEvent.COMPLETE);
        twitterEvent.stringList = stringList;
        //trace(stringList.length)
        dispatchEvent(twitterEvent);
    }
    
    public function seach():void
    {
        loader.startTag(searchWords[searchCount++]);
            if (searchCount == searchWords.length) {
                searchCount = 0;
            }
    }
}

import flash.events.Event;

/**
 * ...
 * @author jaiko
 */
class TwitterEvent extends Event 
{
    public var xml:XML;
    public var stringList:Array;
    public static const COMPLETE:String = "complete";
    public function TwitterEvent(type:String, bubbles:Boolean=false, cancelable:Boolean=false) 
    { 
        super(type, bubbles, cancelable);
        
    } 
    
    public override function clone():Event 
    { 
        return new TwitterEvent(type, bubbles, cancelable);
    } 
    
    public override function toString():String 
    { 
        return formatToString("TwitterEvent", "type", "bubbles", "cancelable", "eventPhase"); 
    }
    
}


