/**
 * Copyright xsd ( http://wonderfl.net/user/xsd )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bE10
 */

package {
    // Yet another implementation of Langton's ant
    // This is made for "どう書く？org", http://ja.doukaku.org/276/
    // This code is written by xsd.
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Rectangle;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFormat;

    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="30")]
    public class LangtonsAnt extends Sprite {
	private const SCREEN_WIDTH:int = 465;
	private const SCREEN_HEIGHT:int = 465;
	private const CELL_SIZE:int = 4;
	private const STEP:int = 10;

	private var bm:BitmapData;
	private var bmp:Bitmap;
	private var tf:TextField;
	private var xAnt:int = 200;
	private var yAnt:int = 200;
	private var vx:int = 1;
	private var vy:int = 0;
	private var count:int = 0;
		
	public function LangtonsAnt():void {
            bm = new BitmapData(SCREEN_WIDTH, SCREEN_HEIGHT, false, 0xFFFFFF);
            bmp = new Bitmap(bm);
            this.addChild(bmp);

            tf = new TextField();
            tf.defaultTextFormat = new TextFormat("_Serif", 24, 0, true);
            tf.x = 0; tf.y = SCREEN_HEIGHT - 32; tf.width = SCREEN_HEIGHT; tf.height = 32;
            tf.selectable = false;
            this.addChild(tf);
            this.addEventListener(Event.ENTER_FRAME, update);
        }
		
        public function update(event:Event):void {
            bm.lock();
            var t:int, i:int;
	
            for (i = 0; i < STEP; i++) {
                xAnt += vx * CELL_SIZE;
                yAnt += vy * CELL_SIZE;
                var a:int = bm.getPixel(xAnt, yAnt);
                if (a == 0) {
                    bm.fillRect(new Rectangle(xAnt, yAnt, CELL_SIZE, CELL_SIZE), 0xFFFFFF);
                    t = vx; vx = vy; vy = -t;
                } else {
                    bm.fillRect(new Rectangle(xAnt, yAnt, CELL_SIZE, CELL_SIZE), 0x000000);
		    t = vy; vy = vx; vx = -t;
                }
                bm.unlock();
                if (xAnt <= CELL_SIZE || xAnt >= SCREEN_WIDTH - CELL_SIZE ||
                    yAnt <= CELL_SIZE || yAnt >= SCREEN_HEIGHT - CELL_SIZE) {
                    this.removeEventListener(Event.ENTER_FRAME, update);
                    break;
                }
                count++;
                tf.text = "Step: "+count;
            }
        }
    }
}
