/**
 * Copyright kazy ( http://wonderfl.net/user/kazy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bDML
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.ui.Keyboard;
	import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
	/**
	 * Main.
	 * ARROW CONTROLS
	 * @since 2009/06/01 22:39
	 */
	public class Main extends Sprite
	{
		private var arrow:Sprite;
		private var vr:Number = 0;
		private var thrust:Number = 0;
		private var vx:Number = 0;
		private var vy:Number = 0;
		private var outputText:TextField = new TextField();
		/**
		 * コンストラクタ.
		 */
		public function Main()
		{
			init();
		}
		/**
		 * 初期化.
		 */
		private function init():void
		{
			outputText.autoSize = TextFieldAutoSize.LEFT;
			outputText.text = "control: ← → key　　　accelerator: ↑ key";
			outputText.x = 10
			outputText.y = 10
			addChild(outputText);
			//
			arrow = makeArrow();
			addChild(arrow);
			arrow.x = stage.stageWidth / 2;
			arrow.y = stage.stageHeight / 2;
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
		}
		/**
		 * onKeyDown Event.
		 */
		private function onKeyDown(event:KeyboardEvent):void
		{
			switch(event.keyCode)
			{
				case Keyboard.LEFT :
				vr = -5;
				break;
				
				case Keyboard.RIGHT :
				vr = 5;
				break;
				
				case Keyboard.UP :
				thrust = 0.2;
				break;
				
				default :
				break;
			}
		}
		/**
		 * onKeyUp Event.
		 */
		private function onKeyUp(event:KeyboardEvent):void
		{
			vr = 0;
			thrust = 0;
		}
		/**
		 * onEnterFrame.
		 */
		private function onEnterFrame(event:Event):void
		{
			arrow.rotation += vr;
			var angle:Number = arrow.rotation * Math.PI / 180;
			var ax:Number = Math.cos(angle) * thrust;
			var ay:Number = Math.sin(angle) * thrust;
			vx += ax;
			vy += ay;
			arrow.x += vx;
			arrow.y += vy;
			if (arrow.x > stage.stageWidth + arrow.width/2) {
				arrow.x = -arrow.width/2;
			}else if (arrow.x < -arrow.width/2) {
				arrow.x = stage.stageWidth + arrow.width/2;
			}
			if (arrow.y > stage.stageHeight + arrow.height/2) {
				arrow.y =  -arrow.height/2;
			}else if (arrow.y < -arrow.height/2) {
				arrow.y = stage.stageHeight + arrow.height/2;
			}
		}
		/**
		 * 矢印生成.
		 */
		public function makeArrow():Sprite {
			var newArrow:Sprite = new Sprite();
			newArrow.graphics.lineStyle(1, 0, 1);
			newArrow.graphics.beginFill(0x990033);
			newArrow.graphics.moveTo(-50, -25);
			newArrow.graphics.lineTo(0, -25);
			newArrow.graphics.lineTo(0, -50);
			newArrow.graphics.lineTo(50, 0);
			newArrow.graphics.lineTo(0, 50);
			newArrow.graphics.lineTo(0, 25);
			newArrow.graphics.lineTo(-50, 25);
			newArrow.graphics.lineTo(-50, -25);
			newArrow.graphics.endFill();
			return newArrow;
		}
		
	}
}
