/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bCvj
 */

package {
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.utils.Proxy;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Graphics;
    import flash.text.TextField;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        
        public var numActor:int = 256;
        public var vecActor:Vector.<Actor> = new Vector.<Actor>(numActor,false);
        
        public var deb:TextField;
        
        public var pic:Bitmap;
        public var back:BitmapData;
        
        public function FlashTest() 
        {
            pic = new Bitmap(new BitmapData(64,64,false,0));
            back = new BitmapData(64,64,false,0);
            addChild(pic);
            pic.alpha = 0.5;
            pic.filters = [ new BlurFilter() ];
            pic.width = 470;
            pic.height = 470;
            
            var k:int;
            var h:int;
            for (h = 0; h < 64; h++)
            {
                for (k = 0; k < 64; k++)
                {
                    back.setPixel(k,h,(k^h)   );       
                }//nextk
            }//nexth
            
            
            deb = new TextField();
            deb.multiline = true;
            deb.width = 128;
            deb.height = 128;
            addChild(deb);
           
           var i:int;
           var a:Actor;
           for (i = 0; i<numActor;i++)
           {
               a = new Actor();
               a.visible =  false;
               addChild(a);
               vecActor[i] = a;   
           }//nexti
        
        
         
         setPlayer();
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mdown);
            stage.addEventListener(MouseEvent.MOUSE_UP, mup);
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public function setPlayer():void
        {
            var a:Actor;
            a = vecActor[0];
            
            a.hp = 10;
            a.dead = 0;
            /*
            a.visible = true;
            a.graphics.clear();
            a.graphics.lineStyle(2,0);
            a.graphics.drawRect(-16,-16,32,32);
            */
            
            a.x = 200;
            a.y = 200;
            
            a.visible = true;
            
            a.group = -1;
            
        }//setplayer
        
        public var mbtn:int = 0;
        public var reload:int = 0;
        public var frame:int = 0;
        
        public function mdown(e:MouseEvent):void
        {
            mbtn = 1;
        }//mdown
        
        public function mup(e:MouseEvent):void
        {
            mbtn = 0;
        }//mup
        
        public function addActor():Actor
        {
            var i:int;
            var a:Actor;
            for (i = 1; i<numActor; i++)
            {
                 a = vecActor[i];
                 if (a.dead <= 0) { continue; }
                 return a;   
            }//nexti 
            
            return null;
        }//addActor
        
        public var scr:int = 0;
        public var dest:Point = new Point();
        
        public function onEnter(e:Event):void
        {
            frame +=1 ;
            deb.text = "mbtn " + mbtn;
           // deb.text = "Frame: " + frame;
            //deb.text ="";
            
            scr += 1;
            scr = scr % 64;
            
            dest.y = scr;
            pic.bitmapData.copyPixels(back, back.rect, dest);
            dest.y -= 64;
            pic.bitmapData.copyPixels(back, back.rect, dest);
            
            
           // pic.bitmapData.scroll(0,1);
            
            var i:int;
            var a:Actor;
            
            for (i = 0; i < numActor;i++)
            {
                //deb.text = "i " + i;
                a = vecActor[i];
                if (a.dead > 0) { continue; }
                
             //   deb.appendText("i " +i);
                
                if (a.group == -1)
                {
                  a.x = mouseX;
                  a.y = mouseY;     
                    
                }
                
              if (a.group == 1)
              {
                   if (a.y < 20) { a.kill(); continue; }   
               }
                
                a.x += a.vx;
                a.y += a.vy;
               if (a.hp <= 0) { a.kill(); continue; }
            }//nexti
            
           // deb.text = "mbtn " + mbtn;
            
            if (reload > 0) { reload -= 1; }
            
            if (mbtn > 0 && reload <= 0)
            {
              //  graphics.moveTo(Math.random()*200,Math.random()*200);
              //  graphics.lineTo(Math.random()*200, Math.random()*200);
                
               // deb.text = "addactor";
               a = addActor();   
               a.dead = 0;
               a.hp = 1;
               a.visible = true;
               a.vy = -16;
               a.x = mouseX;
               a.y = mouseY;
               a.group = 1;
               setGfx(a, 1);
               reload = 4; 
            }//endif
            
            
            
        }//onenter
        
        
        public function setGfx(s:Sprite, fx:int):void
        {
            var g:Graphics;
            g = s.graphics;
            
            g.clear();
            g.lineStyle(2,0);
            
            switch (fx)
            {
                case 1:
                    g.drawRect(-4,-16,8,32);
                break;
                
                
                default:
                    g.drawCircle(0,0, 8);
                break;
            };//swend
            
            
        }//setgfx
        
    }//classend
}
import flash.display.Sprite;


internal class Actor extends Sprite
{
    
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var hp:Number = 11;
    public var dead:int = 1;
    public var type:int = 0;
    public var group:int = 0;
    public var team:int = 0;
    
    public function Actor()
    {
        graphics.clear();
        graphics.lineStyle(2,0);
        graphics.drawCircle(0,0,8);
    }//actor
    
    public function kill():void
    {
        dead = 1;
        visible = false;
        
    }//kill
    
    
    
};//classend