/**
 * Copyright leichtgewicht ( http://wonderfl.net/user/leichtgewicht )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bCRa
 */

package {
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.display.Shape;
    
    public class FlashTest extends Sprite {
        
        private var circles: Shape;
        private var dataShape: Shape;
        
        private var setNo: int = 0;
        private var dataSets: Array = [
            [200, 100, 50, 135, 157],
            [150, 50, 75, 220, 110],
            [350, 124, 134, 76, 210],
            [170, 210, 300, 210, 55],
            [210, 120, 280, 172, 135],
            [110, 75, 210, 156, 320],
        ];
        
        
        public function FlashTest() {
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;            
            
            graphics.beginFill(0);
            graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            
            circles = new Shape();
            dataShape = new Shape();
            
            dataShape.x = circles.x = stage.stageWidth/2;
            dataShape.y = circles.y = stage.stageHeight/2;
            circles.alpha = 0.35;
                        
            addChild(circles);
            addChild(dataShape);
            drawSet(dataSets[setNo]);
            
            stage.addEventListener(MouseEvent.CLICK, drawNextSet);
            
            var label: TextField = new TextField();
            label.defaultTextFormat = new TextFormat("Source Sans Pro", 14, 0xFFFFFF);
            label.selectable = false;
            label.multiline = true;
            label.htmlText = "<i>Hello World</i><br><b>210</b>pt";
            label.autoSize = TextFieldAutoSize.LEFT;
            addChild(label);
        }
        
        private function drawNextSet(e: MouseEvent): void {
            drawSet(dataSets[++setNo] || dataSets[setNo = 0]);
        }

        
        private function drawSet(data: Array): void {
            var colors: Array = [0xea1dff, 0x04ff28, 0x08fff6, 0xff0505, 0xffcf32];
            
            circles.graphics.clear();
            dataShape.graphics.clear();
            
            drawCircles(circles.graphics, 0xFFFFFF, 1);
            drawLines(circles.graphics, 5, 0xFFFFFF, 1);
            drawData(dataShape.graphics, data, colors);
        }

    }
}
import flash.geom.Matrix;
import flash.display.GradientType;

import flash.display.Graphics;

function drawLines(g:Graphics, amount: int, color: int, size: int): void {
    var aChange: Number = 2*Math.PI/amount;
    var a: Number = 0;
    g.lineStyle(size, color);
    for( var i: int = 0; i<amount; ++i) {
        g.moveTo(0,0);
        g.lineTo(Math.sin(a)*1000, Math.cos(a)*1000);
        a += aChange;
    }

}


function drawCircles(g: Graphics, color: int, size: int ): void {
    var radius: Number = 3;
    g.lineStyle(size, color);
    for( var i: int = 0; i<100; ++i, radius*=1.2) {
        g.drawCircle(0, 0, radius);
    }

}


function drawData(g: Graphics, data: Array, colors: Array): void {
    var amount: int = data.length;
    var aChange: Number = 2*Math.PI/amount;
    var a: Number = 0;
    var aP: Number = -aChange;
    var aP2: Number = -aChange/2;
    var aN: Number = aChange;
    var aN2: Number = aChange/2;
    var m: Matrix = new Matrix();
    
    for( var i: int = 0; i<amount; ++i, a+=aChange, aP+=aChange, aN+=aChange, aP2+=aChange, aN2+=aChange) {
        
        var d: Number = data[i];
        var dN: Number = data[i+1] || data[0];
        var dP: Number = data[i-1] || data[amount-1];
        
        var x1: Number = Math.sin(a)*d;
        var y1: Number = Math.cos(a)*d;
        var xN: Number = Math.sin(aN)*dN;
        var yN: Number = Math.cos(aN)*dN;
        var xP: Number = Math.sin(aP)*dP;
        var yP: Number = Math.cos(aP)*dP;
        var xN2: Number = Math.sin(aN2)*halfWay(d, dN);
        var yN2: Number = Math.cos(aN2)*halfWay(d, dN);
        var xP2: Number = Math.sin(aP2)*halfWay(d, dP);
        var yP2: Number = Math.cos(aP2)*halfWay(d, dP);
        
        var color: Number = colors[i];
        m.createGradientBox(Math.max(xN2, xP2, x1)-Math.min(xN2, xP2, x1), Math.max(yN2, yP2, y1)-Math.min(yN2, yP2, y1), a, Math.min(xN2, xP2, x1), Math.min(yN2, yP2, y1));
        
        g.beginGradientFill(GradientType.LINEAR, [color, color], [0.5, 1.0], [0, 255], m);
        g.moveTo(0,0);
        
        //g.lineTo(halfWay(xP, x1), halfWay(yP, y1));
        g.lineTo(xN2, yN2);
        g.lineTo(x1, y1);
        g.lineTo(xP2, yP2);
        //g.lineTo(halfWay(xN, x1), halfWay(yN, y1));
        
        g.endFill();
        
        g.beginFill(0xFFFFFF);
        g.drawCircle(x1, y1, 3);
    }
}


function halfWay(a: Number, b: Number): Number {
    return a + (b-a)/2;
}
