/**
 * Copyright Hado_A ( http://wonderfl.net/user/Hado_A )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bCA2
 */

//===========================================================================
// BitmapData.perlinNoiseがどういうものなのか知らなかったので試してみた。
// 
// キーボードのボタンでパラメータ変更。（パラメータの詳細は公式リファレンスで）
// A,Z : baseX
// S,X : baseY
// D,C : octaves
// F,V : stitch
// G,B : fractal
// H,N : channel
// J,M : grayScale
//
// offsetパラメータは今回は使用しませんでした。
//===========================================================================

package
{
  import flash.display.*;
  import flash.events.*;
  import flash.utils.*;
  import flash.text.*;
  import net.hires.debug.Stats;

  [SWF(width=465, height=465, backgroundColor=0x000000, frameRate=30)]
  
  public class Main extends Sprite 
  {
    //=======================================================================
    // const
    //=======================================================================
    
    private const CANVAS_SIZE               :int               = 465;
    private const CANVAS_COLOR              :uint              = 0xFFFFFFFF;
    private const UPDATE_TIMER_DELAY        :Number            = 1000;
    private const TEXT_BG_COLOR             :uint              = 0x00000000;
    private const TEXT_COLOR                :uint              = 0xFFFFFFFF;
    private const TEXT_WIDTH                :Number            = 110;
    private const TEXT_HEIGHT               :Number            = 120;
    private const RANDOM_VALUE              :Number            = 100;
    private const OCTAVES_MIN               :uint              = 0;
    private const OCTAVES_MAX               :uint              = 20;
    private const CHANNEL_MIN               :uint              = 0;
    private const CHANNEL_MAX               :uint              = 7;
    private const BASE_XY_CHANGE            :Number            = 10;
    
    //=======================================================================
    // var
    //=======================================================================
    
    private var _canvas                     :BitmapData;
    private var _updateTimer                :Timer;
    private var _perlinParam                :PerlinNoiseParam;
    private var _text                       :TextField;
    
    //=======================================================================
    // method
    //=======================================================================
    
    //-----------------------------------------------------------------------
    /**
     * コンストラクタ。
     */
    public function Main():void 
    {
      if (stage) init();
      else addEventListener(Event.ADDED_TO_STAGE, init);
    }

    //-----------------------------------------------------------------------
    /**
     * エントリーポイント。初期化。
     * @param	e
     */
    private function init(e:Event = null):void 
    {
      removeEventListener(Event.ADDED_TO_STAGE, init);
      
      // キャンバス
      _canvas = new BitmapData(CANVAS_SIZE, CANVAS_SIZE, true, CANVAS_COLOR);
      var mainCanvas:Bitmap = new Bitmap(_canvas);
      
      // タイマー
      _updateTimer = new Timer(UPDATE_TIMER_DELAY);
      _updateTimer.start();
      
      // パーリンノイズパラメータ
      _perlinParam = new PerlinNoiseParam(CANVAS_SIZE, CANVAS_SIZE);
      
      // TextField
      _text = new TextField();
      _text.background = true;
      _text.backgroundColor = TEXT_BG_COLOR;
      _text.selectable = false;
      _text.textColor = TEXT_COLOR;
      _text.width  = TEXT_WIDTH;
      _text.height = TEXT_HEIGHT;
      _text.x = stage.stageWidth - _text.width;
      updateText();
      
      // イベント追加
      _updateTimer.addEventListener(TimerEvent.TIMER, updateTimer);
      stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
      
      // 子追加
      this.addChild(mainCanvas);
      this.addChild(_text);
      this.addChild(new Stats());
    }
    
    //-----------------------------------------------------------------------
    /**
     * ノイズ更新タイマー。
     * @param	e
     */
    private function updateTimer(e:Event):void
    {
      // 値の限界値を決める
      if (_perlinParam._octaves > OCTAVES_MAX) { _perlinParam._octaves = OCTAVES_MAX; }
      if (_perlinParam._channel > CHANNEL_MAX) { _perlinParam._channel = CHANNEL_MAX; }
      
      // パーリンノイズ生成
      _canvas.perlinNoise(
        _perlinParam._baseX,
        _perlinParam._baseY,
        _perlinParam._octaves,
        Math.random() * 100,
        _perlinParam._stitch,
        _perlinParam._fractal,
        _perlinParam._channel,
        _perlinParam._grayScale
      );
    }
    
    //-----------------------------------------------------------------------
    /**
     * パーリンノイズのパラメータを表示するテキストフィールドの更新。
     */
    private function updateText():void
    {
      _text.text =
        " baseX : "        + _perlinParam._baseX     + 
        "\n baseY : "      + _perlinParam._baseY     + 
        "\n octaves : "    + _perlinParam._octaves   + 
        "\n stitch : "     + _perlinParam._stitch    + 
        "\n fractal : "    + _perlinParam._fractal   + 
        "\n channel : "    + _perlinParam._channel   + 
        "\n grayScale : "  + _perlinParam._grayScale;
    }
    
    //-----------------------------------------------------------------------
    /**
     * キーボードダウンイベント。
     * @param	e
     */
    private function onKeyDown(e:KeyboardEvent):void 
    {
      var code:uint = e.keyCode;
      
      switch(code)
      {
        // baseX
        case 65: _perlinParam._baseX += BASE_XY_CHANGE; break; // A
        case 90: _perlinParam._baseX -= BASE_XY_CHANGE; break; // Z
        
        // baseY
        case 83: _perlinParam._baseY += BASE_XY_CHANGE; break; // S
        case 88: _perlinParam._baseY -= BASE_XY_CHANGE; break; // X
        
        // octaves
        case 68: // D
          if (_perlinParam._octaves < OCTAVES_MAX) { _perlinParam._octaves++; }
          break;
        case 67: // C
          if (_perlinParam._octaves > OCTAVES_MIN) { _perlinParam._octaves--; }
          break;
        
        // stitch
        case 70: _perlinParam._stitch = true; break; // F
        case 86: _perlinParam._stitch = false; break; // V
        
        // fractal
        case 71: _perlinParam._fractal = true; break; // G
        case 66: _perlinParam._fractal = false; break; // B
        
        // channel
        case 72: // H
          if (_perlinParam._channel < CHANNEL_MAX) { _perlinParam._channel++; }
          break;
        case 78: // N
          if (_perlinParam._channel > CHANNEL_MIN) { _perlinParam._channel--; }
          break;
        
        // grayScale
        case 74: _perlinParam._grayScale = true; break; // J
        case 77: _perlinParam._grayScale = false; break; // M
        
      }
      
      // パーリンノイズパラメータテキスト作成
      updateText();
    }
    
  }

}

/**
 * パーリンノイズのパラメータを格納する。
 */
class PerlinNoiseParam
{
  public var _baseX                      :Number;
  public var _baseY                      :Number;
  public var _octaves                    :uint;
  public var _stitch                     :Boolean;
  public var _fractal                    :Boolean;
  public var _channel                    :uint;
  public var _grayScale                  :Boolean;
  public var _offset                     :Array;
  
  public function PerlinNoiseParam(
    baseX:Number       = 100,
    baseY:Number       = 100,
    octaves:uint       = 3,
    stitch:Boolean     = false,
    fractal:Boolean    = false,
    channel:uint       = 7,
    grayScale:Boolean  = false,
    offset:Array       = null
  ) 
  {
    this._baseX       = baseX;
    this._baseY       = baseY;
    this._octaves     = octaves;
    this._stitch      = stitch;
    this._fractal     = fractal;
    this._channel     = channel;
    this._grayScale   = grayScale;
    this._offset      = offset;
  }
  
}
