/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bBij
 */

package
{
    import flash.display.Sprite;
    
    public class Main extends Sprite
    {
        public function Main()
        {
            addChild(new Board());
        }
    }
}

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;

class Board extends Sprite
{
    public static const WIDTH:int = 8;    // 8 * 8マス
    public static const HEIGHT:int = 8;
    public static const SIZE:int = 30;    // 1マスは30 * 30px
    
    private var board:Array;

    public function Board()
    {
        board = [];
        for (var y:int = 0; y < HEIGHT; y++)
        {
            board[y] = [];
            for (var x:int = 0; x < WIDTH; x++)
            {
                board[y][x] = State.NONE;
            }
        }
        board[3][3] = board[4][4] = State.WHITE;
        board[3][4] = board[4][3] = State.BLACK;
        
        addEventListener(Event.ENTER_FRAME, draw);
        addEventListener(MouseEvent.CLICK, onMouseClick);
    }
        
    // クリックされたとき
    private function onMouseClick(event:MouseEvent):void 
    {
    }
    
    // 毎フレーム描画
    private function draw(event:Event = null):void
    {
        graphics.clear();
        for (var y:int = 0; y < HEIGHT; y++)
        {
            for (var x:int = 0; x < WIDTH; x++)
            {
                var tx:int = x * SIZE;
                var ty:int = y * SIZE;
                
                graphics.lineStyle(1.0);
                graphics.beginFill(0xA0C000);
                graphics.drawRect(tx, ty, SIZE, SIZE);
                graphics.endFill();
                
                if (board[y][x] == State.NONE) continue;
                
                graphics.beginFill(Color.LIST[board[y][x]]);
                graphics.drawCircle(tx + SIZE / 2, ty + SIZE / 2, SIZE / 3);
                graphics.endFill();
            }
        }
    }
}

class State
{
    public static const NONE:int = 0;
    public static const BLACK:int = 1;
    public static const WHITE:int = 2;
}

class Color
{
    public static const LIST:Array = [0, 0x0, 0xFFFFFF];
}