/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bB5h
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.media.Sound;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.media.SoundTransform;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    
    /**
     * ...
     * @author nagai
     * sound by AlainMikuni
     * 
     */
    
    [SWF(width="465",height="465",frameRate=60)]
    public class Main extends Sprite 
    {
        private const ROW:int = 16;
        private const COL:int = 16;
        private const RADIUS:int = 5;
        
        private var sound:Sound;
        private var obj_array_l:Array = [];
        private var obj_array_r:Array = [];
        private var position_array_l:Array = [];
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event=null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            PlaySound("http://www.takasumi-nagai.com/soundfiles/sound004.mp3");
        }
        
        private function PlaySound(url:String):void
        {
            sound = new Sound();
            var _context:SoundLoaderContext = new SoundLoaderContext(1000, true);
            sound.addEventListener(Event.COMPLETE, SoundLoadeComplete);
            sound.load(new URLRequest(url), _context);
        }
        
        private function SoundLoadeComplete(e:Event):void 
        {
            Wonderfl.capture_delay(46);
            
            obj_array_l = Draw();
            obj_array_r = Draw();
            position_array_l = PointPosition(obj_array_l);
            
            addEventListener(Event.ENTER_FRAME, loop);
            sound.play(0, 10, new SoundTransform(0.7, 0));
        }
        
        private function loop(e:Event):void 
        {
            var _byte:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(_byte, true);
            for (var n:int = 0; n < 2; n++)
            {
                for (var i:int = 0; i < 256; i++)
                {
                    var data:Number = _byte.readFloat();
                    var p:Number = data * 2;
                    
                    if (n==0)
                    {
                        var _sp:Sprite = obj_array_l[i] as Sprite;
                        var _point:Point = position_array_l[i] as Point;
                        
                        _sp.x += p;
                        _sp.y += p;
                        
                        if (data == 0)
                        {
                            _sp.x += (_point.x - _sp.x) / 10;
                            _sp.y += (_point.y - _sp.y) / 10;
                        }
                    }
                    else if (n==1)
                    {
                        var _sp_r:Sprite = obj_array_r[i] as Sprite;
                        
                        _sp_r.scaleX += p;
                        _sp_r.scaleY += p;
                        
                        if (data <0.2)
                        {
                            _sp_r.scaleX += (1 - _sp_r.scaleX) / 10;
                            _sp_r.scaleY += (1 - _sp_r.scaleY) / 10;
                        }
                    }
                }
            }
        }
        
        private function PointPosition(array:Array):Array
        {
            var _array:Array = [];
            for (var i:int = 0; i < array.length; i++)
            {
                var _obj:Object = array[i] as Object;
                var _point:Point = new Point(_obj.x, _obj.y);
                _array.push(_point);
            }
            return _array;
        }
        
        private function Draw():Array
        {
            var _array:Array = [];
            
            for (var i:int = 0; i < ROW ; i++)
            {
                for(var j:int = 0; j < COL; j++)
                {
                    var _sp:Sprite = new Sprite();
                    _sp.graphics.beginFill(0);
                    _sp.graphics.drawCircle(0, 0, RADIUS);
                    _sp.graphics.endFill();
                    _sp.x = 15 + j * 450 / COL;
                    _sp.y = 15 + i * 450 / ROW;
                    _sp.blendMode = "invert";
                    addChild(_sp);
                    _array.push(_sp);
                }
            }
            return _array;
        }
        
    }
    
}