/**
 * Copyright flocdelay ( http://wonderfl.net/user/flocdelay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bB2j
 */

// forked from nutsu's forked from: FractalSample
// forked from nutsu's FractalSample
package  
{
    import frocessing.display.F5MovieClip2D;
    
    [SWF(width=465,height=465,backgroundColor=0xFFEECC)]
    public class FractalSample2 extends F5MovieClip2D
    {
        private var shape_size:Number;
        private var r1:Number;
        private var r2:Number;
        private var r3:Number;

        
        public function FractalSample2() 
        {
            //線と塗りの色指定
            stroke( 0, 0.25 );
            colorMode( RGB, 10 );
            
            //キャンバスを移動
            translate(465/2, 465/2 + 20);
            
            //シェイプの大きさ
            shape_size = 200;
            
            //シェイプのパラメータ
            r1 = shape_size*1.25;
            r2 = shape_size*0.5;
            r3 = shape_size*1.0;

            
            //フラクタルの描画(再帰回数を指定)
            draw_shapes( 4 );
        }
        
        private function draw_shapes( n:int ):void
        {
            if ( n-- <= 0 ) return;
            
            var rn:int = 3;
            
            //キャンバスのサイズを半分に
            scale( 0.5 );
            for ( var i:int = 0; i < rn; i++ ) {
                
                pushMatrix();
                //Y方向に-r移動
                translate( 0, -shape_size );
                
                //シェイプの描画
                fill( 10 - n, 0, 0 );
                draw_shape();
                
                //再帰的に描画
                draw_shapes( n );
                popMatrix();
                
                //360/rn 度回転
                rotate( 2*Math.PI/rn );
            }
        }
        
        private function draw_shape():void
        {
            line( 0, 0,  Math.sqrt(3/2) * r1,  Math.sqrt(1/2) * r1 );
            line( 0, 0, -Math.sqrt(3/2) * r2,  Math.sqrt(1/2) * r2 );
            line( 0, 0, 0, -r3 );
            
            rectMode(CENTER);
            rect( 0, 0, 120, 120 );
            rect(  Math.sqrt(3/2) * r1,  Math.sqrt(1/2) * r1, 60, 60 );
            rect( -Math.sqrt(3/2) * r2,  Math.sqrt(1/2) * r2, 60, 60 );
            rect( 0, -r3, 60, 60 );

        }
    }
}