/**
 * Copyright dabing1022 ( http://wonderfl.net/user/dabing1022 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bAfh
 */

// forked from IPFix's Mouse Effect
package {
    import flash.display.Stage;
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.events.Event;
    import flash.filters.GlowFilter;
    import flash.geom.Point;
    import frocessing.color.ColorHSV;
    
    [SWF(backgroundColor=0x000000)]
    public class MouseGrowEffect extends Sprite
    {
        private var dep:Number = 0;
        private var linearr:Array = new Array();
        private var dotarr:Array = new Array();
        private var draw_mc:Sprite = new Sprite();
        private var color:ColorHSV
        
        public function MouseGrowEffect(  )
        {
            this.addEventListener( Event.ADDED_TO_STAGE, onAdd2Stage );
            
        }
        
        private function onAdd2Stage( e:Event ):void
        {
            graphics.beginFill(0);
            graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            color = new ColorHSV();
            addChild( draw_mc );        
            addEventListener( Event.ENTER_FRAME, onEventEnterFrame );
            
        }
        private function onEventEnterFrame( e:Event ):void
        {
            color.h++;
            
            var glow:GlowFilter = new GlowFilter( color.value, 1, 16, 16, 2, 3, false, false );
            draw_mc.filters = [ glow ];   
            
            var _obj:Object = new Object();
            
            if ( stage.mouseX != 0 && stage.mouseX != 0 )
            {
                _obj.x = stage.mouseX;
                _obj.y = stage.mouseY;
                dotarr.push( _obj );
            }
            if ( dotarr.length > 10 )
            {
                dotarr.splice( 0,1 );
            }
            
            var _g:Graphics = draw_mc.graphics;
            _g.clear();
            _g.lineStyle( 0, 0xff0000, 100, true, "none", "round", "round", 1 );                
            var _prevPoint:Point = null;
            var _dotLength:int = dotarr.length;     
            
            if ( _dotLength <= 0 ) return;
            
            for ( var i:int = 1; i < _dotLength; ++i )
            {        
                var _prevObj:Object = dotarr[i - 1];                                    
                var _currentObj:Object = dotarr[i];
                _g.lineStyle( i / 1.2  , 0xffffff, 1, true, "none", "round", "round", 1 );                
                var _point:Point = new Point( _prevObj.x + ( _currentObj.x - _prevObj.x ) / 2, _prevObj.y + ( _currentObj.y - _prevObj.y ) / 2 );                
                
                if ( _prevPoint )
                {
                    _g.moveTo( _prevPoint.x,_prevPoint.y );
                    _g.curveTo( _prevObj.x,_prevObj.y,_point.x,_point.y );
                } else {
                    _g.moveTo( _prevObj.x,_prevObj.y );
                    _g.lineTo( _point.x,_point.y );
                }
                _prevPoint = _point;
            }
            if ( _currentObj )
            {
                _g.lineTo( _currentObj.x, _currentObj.y );
            }
        }
    }
}