/**
 * Copyright hi.kurosawa ( http://wonderfl.net/user/hi.kurosawa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bAJs
 */

package {
    //----------------------------------------------
    //mkColorBall
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.StageScaleMode; 
    import flash.display.StageAlign;
    import flash.text.TextFieldAutoSize;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    //import cls.*;

    public class  mkColorBall extends Sprite {
        private var ucol:uint;
        private var ir:int;
        private var spImg:Sprite;
        
        public function mkColorBall() {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            ucol = 0x0000ff;
            ir = 100;
            this.addChild(new clsColorBtn("ColBtn", 10, 15, ucol,fncChngCol ));
            this.addChild(new clsText("SIZE", 40, 15, 100, 20 ,false ,false));
            this.addChild(new clsHSlider("HSl", 80, 20, 300, 10, 150, 1, ir, fncChng));
            spImg = new Sprite();
            this.addChild(spImg);
            spImg.x = 200;
            spImg.y = 200;
            fncMkColorBall();
        }
        private function fncChng(hs:clsHSlider):void {
            ir = hs.value;
            fncMkColorBall();
        }
        private function fncChngCol(cCol:clsColorBtn):void {
            ucol = cCol.color;
            fncMkColorBall();
            
        }
        private function fncMkColorBall():void {
            var ur0:int = ucol / (256 * 256);
            var ug0:int = (ucol % (256 * 256)) / 256;
            var ub0:int = ucol % 256;
            var lvx:Number = -1 / Math.sqrt(5);
            var lvy:Number = -1 / Math.sqrt(5);
            var lvz:Number = 2 / Math.sqrt(5);
            
            //BitmapDataを作成
            //第3引数が透明度を適用するか否かで、第4引数が透明度を含めた背景色（ARGB）
            var bmpD:BitmapData = new BitmapData(ir*2, ir*2, true, 0x00000000);
            
            for (var i:int = 0; i < ir*2;i++) {
                for (var j:int = 0; j < ir*2; j++) {
                    var d:Number = ir * ir -
                            ((i - ir) * (i - ir) + (j - ir) * (j - ir) );
                    if (d >= 0.0) {
                        var z:Number = Math.sqrt(d) / ir;
                        var x:Number = (i - ir) / ir;
                        var y:Number = (j - ir) / ir;
                        //var dd:Number = (lvx * x + lvy * y + lvz * z);
                        var dd:Number = (lvx * x + lvy * y + lvz * z-0.8)/0.3;
                        if (dd < 0) { dd = 0;}
                        var ur:int = ur0 + dd * 256;
                        var ug:int = ug0 + dd * 256;
                        var ub:int = ub0 + dd * 256;
                        if (ur < 0) { ur = 0;}
                        if (ur > 255) { ur = 255;}
                        if (ug < 0) { ug = 0;}
                        if (ug > 255) { ug = 255;}
                        if (ub < 0) { ub = 0;}
                        if (ub > 255) { ub = 255;}
                        bmpD.setPixel32(i, j, 0xff000000 | (ur*256*256+ug*256+ub));
                    }
                }
            }
            while (spImg.numChildren) spImg.removeChildAt(0);
            var bmp:Bitmap = new Bitmap(bmpD);
            spImg.addChild(bmp);
            bmp.x = -ir;
            bmp.y = -ir;

        }
    }
}
//package cls {
    //----------------------------------------------
    //clsColorBtn
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.ui.MouseCursor;
    import flash.ui.Mouse;
    
    //public class  clsColorBtn extends Sprite {
   class  clsColorBtn extends Sprite {
        private var spBack:Sprite
        private var spMain:Sprite;
        private var fncChkFnc:Function;
        private var uinCol:uint;
        
        public function clsColorBtn(nam:String,
                nX:Number, nY:Number, col:uint , fChk:Function=null) {
                    
            this.name = nam;
            fncChkFnc = fChk;
            this.x = nX;
            this.y = nY;
            uinCol = col;
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            spBack=new Sprite();
            addChild(spBack);
            spMain=new Sprite();
            addChild(spMain);
            
            spBack.graphics.beginFill(0xffffff);
            spBack.graphics.lineStyle(1,0x000000);
            spBack.graphics.drawRect(0, 0,  20, 20);
            spBack.graphics.endFill();
            spBack.alpha = 0.2;
            
            this.addEventListener(MouseEvent.CLICK, fncChk);
            //マウスがのった時の色の変更
            this.addEventListener(MouseEvent.ROLL_OVER, onOver);
            this.addEventListener(MouseEvent.ROLL_OUT, onOut);
            dispCol();
        }

        //クリック
        public function fncChk(e:Event):void {
            clsColorDialog.show(root,uinCol,fncCDok);
        }
        //マウスオーバー処理（ボタンらしく見せる）
        public function onOver(e:MouseEvent):void {
            spBack.alpha = 0.5;
        }
        public function onOut(e:MouseEvent):void {
            spBack.alpha = 0.2;
        }
        public function get color():uint {
            return uinCol;
        }

        public function set color(value:uint):void {
            uinCol = value;
            dispCol();
        }
        public function fncCDok(col:uint):void {
            this.color = col;
            if (fncChkFnc != null) { fncChkFnc(this);}
        }
        public function dispCol():void {
            spMain.graphics.beginFill(uinCol);
            spMain.graphics.lineStyle(1,uinCol);
            spMain.graphics.drawRect( 2, 2,  16, 16);
            spMain.graphics.endFill();
            spMain.graphics.beginFill(0xffffff);
            spMain.graphics.lineStyle(1, 0x000000);
            spMain.graphics.moveTo(10, 10);
            spMain.graphics.lineTo(15, 19);
            spMain.graphics.lineTo(19, 10);
            spMain.graphics.endFill();
        }
    }
//}
//package cls {
    //----------------------------------------------
    //ColorDialogクラス
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
//    public class clsColorDialog {
    class clsColorDialog {
        private static var spPar:Object;    //親(root)
        private static var spBack:Sprite;    //モーダルのための領域
        private static var spMain:Sprite;    //ColorDialogのエリア
        private static var hsR:clsHSlider;
        private static var hsG:clsHSlider;
        private static var hsB:clsHSlider;
        private static var txCol:clsText;

        //移動用
        public static var blMouseFlg:Boolean = false;
        public static var intMouseX:int;
        public static var intMouseY:int;
        //サイズ
        public static var intW:int;
        public static var intH:int;
        //ボタンの押されたときの関数
        public static var fncBtn:Function;
        

        
        //----------------------------------------------------------------------------
        // ColorDialogを表示
        //  clsColorDialog.show(root,uiInitCol,fncOK);
        // par:親(rootを指定)
        // text:メッセージ（改行も対応）
        // title:タイトル
        // flags:表示するボタン（YES/NO/OK/CANCEL)
        // cloFnc:ボタンが押されたとき実行する関数(cloFnc(ui:uint):void)が押されたボタンの値
        public static function show(par:Object, ucol:uint, fncOK:Function = null):void {
                    
            fncBtn = fncOK;
            intW = 300;
            intH = 200;
            // rootのサイズ
            spPar = par;
            var iWid:int = spPar.stage.stageWidth;
            var iHei:int = spPar.stage.stageHeight;
            // モーダルにするために四角を書く
            spBack=new Sprite();
            spBack.graphics.beginFill(0xffffff,0.5);
            spBack.graphics.lineStyle(1,0xffffff,0.5);
            spBack.graphics.drawRect(0, 0,  iWid, iHei);
            // Alertの各部品を配置するエリア
            spMain = new Sprite();
            spPar.addChild(spBack);
            spBack.addChild(spMain);
            //タイトルを配置
            var tfTit:TextField = new TextField();
            tfTit.text = "ColorDialog";
            tfTit.selectable = false;
            tfTit.width = intW;
            tfTit.height = 20;
            tfTit.border = true;
            tfTit.background = true;
            tfTit.backgroundColor = 0xbbbbbb;
            spMain.addChild(tfTit);
            var ur0:int = ucol / (256 * 256);
            var ug0:int = (ucol % (256 * 256)) / 256;
            var ub0:int = ucol % 256;
            spMain.addChild(new clsText("R", 10, 35, 20, 20 ,false,false));
            hsR = new clsHSlider("R", 30, 40, 256, 0, 255, 1, ur0,fncDispCol);
            spMain.addChild(hsR);
            spMain.addChild(new clsText("G", 10, 60, 20, 20 ,false,false));
            hsG = new clsHSlider("G", 30, 65, 256, 0, 255, 1, ug0,fncDispCol);
            spMain.addChild(hsG);
            spMain.addChild(new clsText("B", 10, 85, 20, 20 ,false,false));
            hsB = new clsHSlider("B", 30, 90, 256, 0, 255, 1, ub0,fncDispCol);
            spMain.addChild(hsB);
  
            txCol = new clsText("", intW / 2 + 10, 120, 80, 20,true);
            spMain.addChild(txCol);
            spMain.addChild(new clsButton("OK", "OK" ,    intW/2-60, intH-25, 55, 20 , fncBtnOn));
            spMain.addChild(new clsButton("CANCEL", "CANCEL" ,    intW/2+5, intH-25, 55, 20 , fncBtnOn));
            
            
            //外形
            spMain.graphics.beginFill(0xffffff);
            spMain.graphics.lineStyle(1,0x000000);
            spMain.graphics.drawRect(0, 0, intW, intH);
            spMain.x = int((iWid - intW) / 2);
            spMain.y = int((iHei - intH) / 2);
            //MOUSE_DOWN以外はstageを付ける
            tfTit.addEventListener(MouseEvent.MOUSE_DOWN,onDown);
            tfTit.stage.addEventListener(MouseEvent.MOUSE_MOVE,onMove);
            tfTit.stage.addEventListener(MouseEvent.MOUSE_UP, onUp);
            fncDispCol();
        }
        //ドラッグによる移動
        private static function onDown(e:MouseEvent):void {
            blMouseFlg = true;
            intMouseX=spPar.mouseX;
            intMouseY=spPar.mouseY;
        }
        private static function onMove(e:MouseEvent):void {
            if(e.buttonDown==false) {blMouseFlg = false;}
            if (blMouseFlg == true) {
                var x1:int = spPar.mouseX;
                var y1:int = spPar.mouseY;
                var x2:int=spMain.x + x1 - intMouseX ;
                var y2:int=spMain.y + y1 - intMouseY ;
                fncChkXY(x2,y2);
                intMouseX = x1;
                intMouseY = y1;
            }
        }
        private static function onUp(e:MouseEvent):void {
            blMouseFlg = false;
        }
        //領域外に出ないようにする
        private static function fncChkXY(x1:int,y1:int):void {
            if (x1 > spPar.stage.stageWidth - intW-1) { x1 = spPar.stage.stageWidth - intW-1; }
            if (y1 > spPar.stage.stageHeight - intH-1) { y1 = spPar.stage.stageHeight - intH-1; }
            if (x1 < 0) { x1 = 0; }
            if (y1 < 0) { y1 = 0; }
            spMain.x=x1;
            spMain.y=y1;
        }
        //ボタンが押されたときの処理===============================
        private static function fncBtnOn(btn:clsButton):void {
            spPar.removeChild(spBack);    //Alertの削除
            spBack = null;
            spMain = null;
            if (fncBtn != null) {    //呼び出し側の関数を実行
                var uc:uint=hsR.value*256*256+hsG.value*256+hsB.value;
                fncBtn(uc);
            }
            
        }
        
        private static function fncDispCol(hs:clsHSlider = null):void {
            var uc:uint=hsR.value*256*256+hsG.value*256+hsB.value;
            var s:String = "000000" + uc.toString(16);
            s = s.substr(s.length - 6);
            txCol.text = "0x" + s;
            spMain.graphics.beginFill(uc);
            spMain.graphics.lineStyle(1, 0x000000);
            spMain.graphics.drawRect(intW / 2 -50, 120, 40, 40);
            spMain.graphics.endFill();
        }
    }
//}
//package cls {
    //----------------------------------------------
    //ツールチップつきマーク
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.geom.Point;

    //public class clsHSlider extends Sprite {
    class clsHSlider extends Sprite {
        public var intW:int;
        public var numMin:Number;
        public var numMax:Number;
        public var numStep:Number;
        public var numVal:Number;
        public var fncChng:Function;
        public var tfTip:TextField;
        public var spMk:Sprite;

        private var blMouseFlg:Boolean = false;
        private var intMouseX:int;
        private var intMouseY:int;
        
        public function clsHSlider(nam:String,  x0:int, y0:int, w:int
                    ,min:Number,max:Number,step:Number,val:Number,fchg:Function = null) {
            this.name = nam;
            this.x = x0;
            this.y = y0;
            intW = w;
            numMin=min;
            numMax=max;
            numStep = step;
            if(numStep <= 0.0) { numStep = 1.0;}    //????
            numVal=val;
            fncChng=fchg;
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // 円を描く (中を塗りつぶす)
            this.graphics.lineStyle(2, 0x000000);
            this.graphics.moveTo(0, 0);
            this.graphics.lineTo(0, 10);
            this.graphics.moveTo(0, 5);
            this.graphics.lineTo(intW, 5);
            this.graphics.moveTo(intW, 0);
            this.graphics.lineTo(intW, 10);
            spMk = new Sprite();
            spMk.graphics.lineStyle(2, 0x000000);
            spMk.graphics.beginFill(0xffffff);
            spMk.graphics.moveTo(0, 10);
            spMk.graphics.lineTo(-3, 0);
            spMk.graphics.lineTo(3, 0);
            spMk.graphics.endFill();
            this.addChild(spMk);
            spMk.y = 0;
            this.value = numVal;
            spMk.addEventListener(MouseEvent.MOUSE_DOWN,onDown);
            spMk.stage.addEventListener(MouseEvent.MOUSE_MOVE,onMove);
            spMk.stage.addEventListener(MouseEvent.MOUSE_UP,onUp);

            tfTip = fncText();
            spMk.addChild(tfTip);
            tfTip.y = -20
            tfTip.x = 0;
            tfTip.visible = false;
        }
        // 固定文字文字列表示関数
        // sText:表示文字列
        //  nx,ny:文字位置
        //  戻り値:作成TextField
        private function fncText():TextField {
            var tf:TextField = new TextField();
            tf.autoSize = TextFieldAutoSize.CENTER;
            tf.text = numVal.toString();
            tf.selectable = false;
            tf.border = true;
            tf.borderColor = 0xbbbbbb;
            tf.background = true;
            tf.backgroundColor = 0xdddddd;
            return tf;
        }
        public function get value():Number {
            return numVal;
        }

        public function set value(val:Number):void {
            var v:int = ((val - numMin) / numStep)+0.5;
            numVal = (v * numStep) + numMin;
            spMk.x = (numVal - numMin) *intW/ (numMax - numMin);
        }
        private function onDown(e:MouseEvent):void {
            blMouseFlg = true;
            tfTip.visible = true;
            intMouseX=parent.mouseX;
            intMouseY=parent.mouseY;
        }
        private function onMove(e:MouseEvent):void {
            if (e.buttonDown == false) {
                blMouseFlg = false;
                tfTip.visible = false;
                return;
            }
            if (blMouseFlg == true) {
                var x1:int = parent.mouseX;
                var y1:int = parent.mouseY;
                var x2:int=spMk.x + x1 - intMouseX ;
                var y2:int=spMk.y + y1 - intMouseY ;
                if (x2 < 0) { x2 = 0; }
                if (x2 > intW) { x2 = intW; }
                if (spMk.x != x2) {
                    spMk.x = x2;
                    var numv:Number = (x2 / intW) * (numMax - numMin) + numMin;
                    var v:int = ((numv - numMin) / numStep) + 0.5;
                    numVal = (v * numStep) + numMin;
                    tfTip.text = numVal.toString();
                    if (fncChng != null) { fncChng(this); }
                }
                intMouseX = x1;
                intMouseY = y1;
            }
        }
        private function onUp(e:MouseEvent):void {
            blMouseFlg = false;
            tfTip.visible = false;
        }
    }
//}
//package cls {
    //----------------------------------------------
    //ボタンクラス:TextFieldをボタンのように使う
    //   長押し(LongPress)の対応
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.ui.MouseCursor;
    import flash.ui.Mouse;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    import flash.utils.getTimer;
    
//    public class  clsButton extends TextField {
    class  clsButton extends TextField {
        private var tfFormat:TextFormat;
        private var fncChkFnc:Function;
        private var fncLongPress:Function;
        private var intTim:int;
        
        //ボタンクラス:TextFieldをボタンのように使う
        // nam:ボタンの名称（ボタンを区別するために使用）
        // sText:表示する文字
        // nX,nY:表示位置
        // nWidth,nHeight:ボタンのサイズ
        // fChk:クリックしたときの関数「fChk(b:clsButton):void」
        // fLongPress:ボタンの長押ししたときの関数「fLongPress(b:clsButton):void」
        // bItalic：ボタンの文字をItalicにするか？
        public function clsButton(nam:String,sText:String ,
                nX:Number, nY:Number, nWidth:Number, nHeight:Number , fChk:Function=null,
                fLongPress:Function = null, bItalic:Boolean = false) {
                    
            name = nam;
            this.text = sText;
            this.x = nX;
            this.y = nY;
            this.width = nWidth;
            this.height = nHeight;
            this.border = true;
            this.borderColor = 0x000000;
            this.background = true;
            this.backgroundColor = 0xcccccc;
            this.textColor = 0x000000;
            this.selectable = false;    //ボタンの表示文字は選択不可
            tfFormat = new TextFormat();
            tfFormat.align = TextFormatAlign.CENTER;
            tfFormat.italic = bItalic;
            this.setTextFormat(tfFormat);
            //マウスがのった時の色の変更
            this.addEventListener(MouseEvent.ROLL_OVER, onOver);
            this.addEventListener(MouseEvent.ROLL_OUT, onOut);
            //クリック時の処理
            fncChkFnc = fChk;
            if(fncChk!=null) {this.addEventListener(MouseEvent.CLICK, fncChk);}
            //長押し時の処理
            fncLongPress = fLongPress;
            if (fncLongPress != null) {
                this.addEventListener(MouseEvent.MOUSE_DOWN, onDown);
                this.addEventListener(MouseEvent.MOUSE_UP, onUp);
            }
            this.enable(true);    //ボタンを有効に
        }
        //表示文字の変更
        // sText:表示する文字
        public function setText(sText:String):void {
            this.text = sText;
            this.setTextFormat(tfFormat);
        }
        //ボタンの有効(bflg=true)･無効(bflg=false)
        public function enable(bflg:Boolean):void {
            this.mouseEnabled = bflg;
            if (bflg == true) { this.alpha = 1.0; }
            else {this.alpha = 0.5;}
        }
        //マウスオーバー処理（ボタンらしく見せる）
        public function onOver(e:MouseEvent):void {
            e.target.backgroundColor = 0xaaaaaa;
            //Mouse.cursor=flash.ui.MouseCursor.HAND;
        }
        public function onOut(e:MouseEvent):void {
            e.target.backgroundColor = 0xcccccc;
            //Mouse.cursor=flash.ui.MouseCursor.ARROW;
        }
        //長押し(LongPress)の対応
        public function onDown(e:MouseEvent):void {
            intTim = getTimer();
            this.addEventListener(Event.ENTER_FRAME, onLongPress);
        }
        public function onUp(e:MouseEvent):void {
            this.removeEventListener(Event.ENTER_FRAME, onLongPress);
        }
        public function onLongPress(e:Event):void {
            //ボタンを押し続けて0.5秒以上たったら長押し
            if (intTim < getTimer() - 500) { fncLongPress(this); }
        }
        //クリック
        public function fncChk(e:Event):void {
            fncChkFnc(this);
        }
    }
//}
//package cls {
    //----------------------------------------------
    //テキストの表示クラス
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.text.TextField;
    
    //public class  clsText extends TextField {
    class  clsText extends TextField {
        //テキストの表示クラス
        // sText:表示する文字
        // nX,nY:表示位置
        // nWidth,nHeight:表示するサイズ
        // bBorder：外枠の有無
        public function clsText(sText:String ,
                nX:Number, nY:Number, nWidth:Number, nHeight:Number ,
                bBorder:Boolean=false,bSel:Boolean=true) {
            this.text = sText;
            this.x = nX;
            this.y = nY;
            this.width = nWidth;
            this.height = nHeight;
            this.border = bBorder;
            this.background = bBorder;
            this.selectable = bSel;
        }
    }
//}