/**
 * Copyright ayataka ( http://wonderfl.net/user/ayataka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bAHt
 */

package {

    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;
    
    [SWF(frameRate="12")]
    public class Indicator extends Sprite {
        
        private var base:Sprite = new Sprite();
        private var bars:Array = [];
        private var count:int = 0;
        
        private var tf:TextField = new TextField();
        
        public function Indicator() {
            // tf
            addChild( tf );
            
            // base
            addChild( base );
            base.x = stage.stageWidth / 2;
            base.y = stage.stageHeight / 2;
            
            // create bar
            for(var i:int = 0; i < 12; ++i) {
                // create bar
                var bar:Shape = new Shape();
                with( bar.graphics ) {
                    beginFill( 0xFF0000 );
                    drawRoundRect(15, -3, 30, 6, 10);
                    endFill();
                }
                bar.rotationZ = i * 30;
                
                // store
                bars.push( bar );
                
                // add
                base.addChild( bar );
            }
            
            // set listener
            addEventListener(Event.ENTER_FRAME, enterFrame);
        }
        
        private function enterFrame(event:Event):void
        {
            //
            bars.forEach( function(item:*, i:int, a:Array):void {
                    if( i == count ) {
                        item.transform.colorTransform = new ColorTransform( Math.random(), 0 );
                    }
                    else {
                        item.transform.colorTransform = new ColorTransform( 0, 0 );
                    }
                } );
            //
            ++count;
            if( count >= 12 ) {
                count = 0;
            }
        }
    }
}











