/**
 * Copyright hiro_rec ( http://wonderfl.net/user/hiro_rec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bAAV
 */

package
{
    import caurina.transitions.Tweener;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter;
    import flash.filters.GlowFilter;
    import flash.geom.Point;
    
    
    [SWF (backgroundColor='#000000', frameRate=30)]
    
    public class Glow02 extends Sprite
    {
        private var container:Sprite;
        private var line:Sprite;
        private var bmd:BitmapData;
        private var bmp:Bitmap;
        
        private var ptArray:Array = [];
        private var spArray:Array = [];
        
        
        public function Glow02()
        {
            initDisplay();
            
            addEventListener(Event.ENTER_FRAME, drawLine);
            addEventListener(Event.ENTER_FRAME, render);
        }
        
        private function initDisplay():void
        {
            graphics.beginFill(0x0);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            
            container = new Sprite();
            
            line = new Sprite();
            line.graphics.lineStyle(2, 0xFFFFFF);
            container.addChild(line);
            
            //addChild(container);
            
            bmd = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000);
            bmp = new Bitmap();
            bmp.bitmapData = bmd;
            bmp.blendMode = BlendMode.ADD;
            addChild(bmp);
        }
        
        private var pt:Point = new Point();
        private var i:int = -1;
        
        private function drawLine(event:Event):void
        {
            var l:int = spArray.length;
            var sp:Sprite = new Sprite();
            var g:Graphics = sp.graphics;
            
            spArray.push(sp);
            container.addChild(sp);
            g.lineStyle(2, 0xFFFFFF);
            //g.drawCircle(mouseX, mouseY, 2);
            var pt0:Point = ptArray[i - 1];
            
            if (pt0)
                g.moveTo(pt0.x, pt0.y);
            
            var pt1:Point = ptArray[i];
            
            if (pt1)
                g.lineTo(pt1.x, pt1.y);
            
            pt.x = mouseX;
            pt.y = mouseY;
            ptArray.push(pt.clone());
            
            i++;
            
            if (l > 10)
            {
                ptArray.shift();
                
                var deleteSP:Sprite = spArray.shift();
                Tweener.addTween(deleteSP, {alpha:0, time:0.3, transition:"linear",
                    onComplete:function ():void
                    {
                        deleteSP.graphics.clear();
                        container.removeChild(deleteSP);
                    }
                })
                
                i--;
            }
        }
        
        private function render(event:Event):void
        {
            bmd.draw(container);
            
            var point:Point = new Point();
            
            bmd.threshold(bmd, bmd.rect, point, "<", 0x00333333, 0x00000000, 0x00FF0000, true);
            
            var matrix:Array = [
                                1, 0, 0, 0, 0,
                                0, 1, 0, 0, 5,
                                0, 0, 1, 0, 2,
                                0, 0, 0, 1, -5
                                ];
            
            var matrixFilter:ColorMatrixFilter = new ColorMatrixFilter(matrix);
            
            //bmd.applyFilter(bmd, bmd.rect, point, new GlowFilter(0x0000FF, 1, 6, 6, 20));
            bmd.applyFilter(bmd, bmd.rect, point, new GlowFilter(0x00ccff, 1, 10, 10, 2));
            bmd.applyFilter(bmd, bmd.rect, point, new BlurFilter(5, 5));
            //bmd.applyFilter(bmd, bmd.rect, point, matrixFilter);
            bmd.applyFilter(bmd, bmd.rect, point, new GlowFilter(0x2375fd, 5, 5, 1, 1));
            //bmd.applyFilter(bmd, bmd.rect, point, new BlurFilter(10, 10));
        }
    }
}
