/**
 * Copyright Mushus ( http://wonderfl.net/user/Mushus )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/b8MH
 */

//ふわふわ
package {
    import flash.display.GradientType;
    import flash.display.*;
    import flash.events.Event;
    import flash.geom.Matrix;
    [SWF(backgroundColor = "0x002244", frameRate = "30")]
    public class FlashTest extends Sprite {
        private var counter:uint = 0;
        public function FlashTest() {
            // write as3 code here..
            //グラデ
            this.graphics.beginGradientFill(
                GradientType.LINEAR,
                [0x000000, 0x004488],
                [1, 1],
                [0, 0xff],
                new Matrix(0,1,1,0,0,0),
                SpreadMethod.PAD,
                InterpolationMethod.RGB,
                0
            );
            this.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            this.graphics.endFill();
            //ステージに追加
            addEventListener(Event.ENTER_FRAME, loop);
            
        }
        private function loop(e:Event):void {
            //増やす
            if(counter == 0) {
                addChild(
                    new Anim(
                        this,
                        stage.stageWidth * Math.random(),
                        stage.stageHeight + 50,
                        0xdddddd + (0x22 * Math.random() << 16) + (0x22 * Math.random() << 8) + (0x22 * Math.random() << 0)
                    )
                );
                addChild(
                    new Bubble(
                        this,
                        stage.stageWidth * Math.random(),
                        stage.stageHeight + 50,
                        Math.random() * 0.5 + 0.5
                    )
                );
                counter = Math.random() * 240 | 0;
            }
            counter--;
        }
    }
}
import flash.filters.GlowFilter;
import flash.events.Event;
import flash.display.Sprite;
class Anim extends Sprite {
    
    public var color:uint = 0xffffff;
    //色
    private var counter:uint = 0;
    //カウンタ
    private var parentSprite:Sprite;
    //親
    private var direction:Number = 0;
    //方向
    
    /* 体位 */
    private var head:Sprite;
    private var face:Sprite;
    private var leftEar:Sprite;
    private var rightEar:Sprite;
    private var body:Sprite;
    private var leftArm:Sprite;
    private var rightArm:Sprite;
    
    public function Anim(parent:Sprite, x:Number, y:Number, color:uint) {
        super();
        this.scaleX = 0.5;
        this.scaleY = 0.5;
        this.parentSprite = parent;
        this.x = x;
        this.y = y;
        this.color = color;
        this.draw();
        this.addEventListener(Event.ENTER_FRAME, move);
        this.filters = [new GlowFilter(0x88ccff, 0.75, 8, 8)];
    }
    //再描画
    public function move(e:Event):void {
        //アニメーション
        leftEar.rotation = 10 * Math.sin(Number(counter) / 180 * Math.PI * 15);
        rightEar.rotation = -10 * Math.sin(Number(counter) / 180 * Math.PI * 15);
        leftArm.rotation = 20 * Math.sin(Number(counter) / 180 * Math.PI * 15 + 15);
        rightArm.rotation = -20 * Math.sin(Number(counter) / 180 * Math.PI * 15 + 15);
        var speed:Number =  0.5 * (Math.sin(Number(counter) / 180 * Math.PI * 15 + 7) + 0.5)
        
        //方向変更
        if(counter % 120 == 0) {
            direction = (Math.random() - 0.5) * 60;
        }
        //this.rotation = (direction - this.rotation) * 0.5;
        this.rotation += (direction - this.rotation) * 0.01;
        //移動
        this.x += speed * Math.sin(this.rotation / 180 * Math.PI);
        this.y -= speed * Math.cos(this.rotation / 180 * Math.PI);
        counter++;
        
        //上行き過ぎ判定
        if(this.y + this.height < 0) {
            //消す
            removeEventListener(Event.ENTER_FRAME, move);
            parentSprite.removeChild(this);
            removeChild(head);
            removeChild(face);
            removeChild(leftEar);
            removeChild(rightEar);
            removeChild(body);
            removeChild(rightArm);
            removeChild(leftArm);
            //delete head, face, leftEar, rightEar, body, leftArm, rightArm;
            
        }
    }
    //描画
    public function draw():void {
        //顔
        head = new Sprite();
        head.graphics.beginFill(color, 1);
        head.graphics.drawCircle(0, 0, 20);
        head.graphics.endFill();
        addChild(head);
        
        //左耳
        leftEar = new Sprite();
        leftEar.graphics.beginFill(color, 1);
        leftEar.graphics.moveTo(0, 0);
        leftEar.graphics.lineTo(-20,-20);
        leftEar.graphics.curveTo(-30, 10, 0, 0);
        leftEar.graphics.endFill();
        leftEar.x = -10;
        leftEar.y = -10;
        addChild(leftEar);
        
        //右耳
        rightEar = new Sprite();
        rightEar.graphics.beginFill(color, 1);
        rightEar.graphics.moveTo(0, 0);
        rightEar.graphics.lineTo(20,-20);
        rightEar.graphics.curveTo(30, 10, 0, 0);
        rightEar.graphics.endFill();
        rightEar.x = 10;
        rightEar.y = -10;
        addChild(rightEar);
        
        //左手
        leftArm = new Sprite();
        leftArm.graphics.beginFill(color, 1);
        leftArm.graphics.moveTo(0, 0);
        leftArm.graphics.lineTo(-30, 20);
        leftArm.graphics.curveTo(0, 30, 0, 0);
        leftArm.graphics.endFill();
        leftArm.x = -5;
        leftArm.y = 15;
        addChild(leftArm);
        
        //右手
        rightArm = new Sprite();
        rightArm.graphics.beginFill(color, 1);
        rightArm.graphics.moveTo(0, 0);
        rightArm.graphics.lineTo(30, 20);
        rightArm.graphics.curveTo(0, 30, 0, 0);
        rightArm.graphics.endFill();
        rightArm.x = 5;
        rightArm.y = 15;
        addChild(rightArm);
        
        //体
        body = new Sprite();
        body.graphics.beginFill(color, 1);
        body.graphics.moveTo(0, 0);
        body.graphics.curveTo(20, 20, 0, 50);
        body.graphics.curveTo(-20, 20, 0, 0);
        body.graphics.endFill();
        body.x = 0;
        body.y = 10;
        addChild(body);
        
        //目
        face = new Sprite();
        face.graphics.beginFill(0x000000, 1);
        face.graphics.drawEllipse(-10, 0, 5, 10);
        face.graphics.drawEllipse(5, 0, 5, 10);
        face.graphics.endFill();
        face.x = 0;
        face.y = 0;
        addChild(face);
    }

}

//あわ
class Bubble extends Sprite {
    private var parentSprite:Sprite;
    private var counter:Number;
    public function Bubble(parent:Sprite, x:Number, y:Number, size:Number) {
        super();
        this.x = x;
        this.y = y;
        this.parentSprite = parent;
        this.addEventListener(Event.ENTER_FRAME, move);
        this.scaleX = size;
        this.scaleY = size;
        draw();
        this.counter = Math.random() * Math.PI;
        this.filters = [new GlowFilter(0x88ccff, 0.75, 8, 8)];
    }
    //描画
    private function draw():void {
        this.graphics.beginFill(0xffffff,0.5);
        this.graphics.drawCircle(0,0,10);
        this.graphics.drawCircle(0,0,8);
        this.graphics.endFill();
    }

    //移動
    private function move(e:Event):void {
        this.y -= 5;
        this.x += Math.sin(counter)*2;
        //画面外にはみ出したら消す
        if(y < 0) {
            this.removeEventListener(Event.ENTER_FRAME, move);
            this.parentSprite.removeChild(this);
        }
        counter += Math.PI * 0.15;
    }

}
