/**
 * Copyright Albert ( http://wonderfl.net/user/Albert )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/b8Ak
 */

// forked from Albert's Create better-looking tile based games with AS3 Color Matrix Filter
package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;

    public class Main extends Sprite {
        private var randomness:Number=1;
        private var randomRange:Number=0.2;
        private var FloorWallRatio:Number = 0.7;
        private var tileCanvas:Sprite=new Sprite();
        public function Main() {
            addChild(tileCanvas);
            generateTiles();
            stage.addEventListener(MouseEvent.CLICK,generateTiles);
            stage.addEventListener(MouseEvent.MOUSE_MOVE,moveMouse);
        }

        private function generateTiles(e:MouseEvent = null):void {
            removeChild(tileCanvas);
            tileCanvas=new Sprite();
            addChild(tileCanvas);
            for (var i:Number=0; i<20; ++i) {
                for (var j:Number=0; j<20; ++j) {
                    var tile:Tile;                    
                    if (Math.random()>FloorWallRatio)
                        tile=new Wall();
                    else
                        tile=new Floor();
                    tileCanvas.addChild(tile);
                    tile.x=32*i;
                    tile.y=32*j;
                    if (randomness>Math.random()) {
                        var colorMatrix:Array = new Array();
                        var colorOffset:Number=Math.random()*randomRange;
                        tile.transform.colorTransform=new ColorTransform(
                            1-randomRange/2+colorOffset,
                            1-randomRange/2+colorOffset,
                            1-randomRange/2+colorOffset);
                    }
                }
            }
        }
        
        private function moveMouse(e:MouseEvent):void {
            tileCanvas.x = -stage.mouseX / 5.0;
            tileCanvas.y = -stage.mouseY / 5.0; 
        }
    }
}

import flash.display.Sprite;

class Tile extends Sprite {
    function Tile(){
    }
}

class Wall extends Tile {
    function Wall(){
        var color:uint=0x606060;
        this.graphics.lineStyle(1, color);
        this.graphics.beginFill(color);
        this.graphics.drawRect(0,0,32,32);        
        this.graphics.endFill();

        var offsx:int=0;
        var offsy:int=-8;
        color=0x808080;
        
        this.graphics.lineStyle(1, color);
        this.graphics.beginFill(color);
        this.graphics.drawRect(offsx,offsy,32,32);
        this.graphics.endFill();

        color=0x909090;
        var size:int=14;
        var r:int=7;
        this.graphics.lineStyle(1, color);
        //this.graphics.beginFill(color);
        this.graphics.drawRoundRect(1+offsx,  1+offsy,  size,size, r,r);
        this.graphics.drawRoundRect(17+offsx, 1+offsy,  size,size, r,r);
        this.graphics.drawRoundRect(1+offsx,  17+offsy, size,size, r,r);
        this.graphics.drawRoundRect(17+offsx, 17+offsy, size,size, r,r);     
    }
}

class Floor extends Tile {
    function Floor(){
        this.graphics.lineStyle(0, 0x444444);
        this.graphics.beginFill(0x444444);
        this.graphics.drawRect(0,0,32,32);
        this.graphics.endFill();
    }
}
