/**
 * Copyright TUNCAYS ( http://wonderfl.net/user/TUNCAYS )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/b83p
 */

package {
	import flash.display.BitmapData;
	import flash.display.BitmapDataChannel;
	import flash.events.Event;
	import flash.filters.ColorMatrixFilter;
	import flash.filters.GlowFilter;
	import flash.geom.Point;
	
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.BitmapMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Sphere;
	import org.papervision3d.view.BasicView;
	
	[SWF (width="800",height="600",backgroundColor="0x000000")]
	
	public class PaperWorld extends BasicView
	{
		
		private var root3D:DisplayObject3D;
		
		private var light:PointLight3D;
		private var bitmapDataTexture:BitmapData;
		private var cmf:ColorMatrixFilter;
		private var material:BitmapMaterial;
		private var sphere:Sphere;
		
		private var sphereArray:Array
		
		public function PaperWorld()
		{
			setScreen();
			
		}
		private function setScreen():void
		{
			sphereArray=[];
			
			root3D=new DisplayObject3D();
			root3D.z=1000;
			scene.addChild(root3D);
			
			light=new PointLight3D();
			scene.addChild(light);
			
			for(var i:int=0;i<10;i++){
			
				bitmapDataTexture=new BitmapData(80,80,true,0);
				bitmapDataTexture.perlinNoise(20,20,8,10,true,true,BitmapDataChannel.RED,true);
				
				var r:uint = 0xff * Math.random();
	            var g:uint = 0xff * Math.random();
	            var b:uint = 0xff * Math.random();
				
				
				var	 color:uint=r<<16|g<<8|b;
				
				cmf = new ColorMatrixFilter([
	                    r/0xff, 0, 0, 0, 0,
	                    0, g/0xff, 0, 0, 0,
	                    0, 0, b/0xff, 0, 0,
	                    0, 0, 0, 1, 0, 0,
	            ]);
				
				
				bitmapDataTexture.applyFilter(bitmapDataTexture,bitmapDataTexture.rect,new Point(0,0),cmf);
				
				
				material=new BitmapMaterial(bitmapDataTexture);
				
				sphere=new Sphere(material,50+Math.random()*100,10,10);
				
				sphere.x=Math.random()*2000-1000;
				sphere.y=Math.random()*2000-1000;
				sphere.z=500+Math.random()*2000-1000;
				
				sphere.useOwnContainer=true;
				sphere.filters=[new GlowFilter(color,.4,32,32,2,1)];
				
				sphereArray.push(sphere);
				
				root3D.addChild(sphere);
			}
			
			startRendering();

			
		}
		override protected function onRenderTick(event:Event=null):void
		{
			root3D.rotationY-=.5
			for(var i:int=0;i<sphereArray.length;i++){
				sphereArray[i].rotationY--
			}
			super.onRenderTick(event);
		}
	}
}

