/**
 * Copyright a24 ( http://wonderfl.net/user/a24 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/b80Y
 */

package  
{
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import caurina.transitions.Tweener;
	
	[ SWF( width = "465" , height = "465" , backgroundColor = "0xFFFFFF" , frameRate = "60" ) ]
	
	public class Main extends Sprite
	{
		private var _sq:Shape;
		private var _cr:Shape;
		
		private var _buttons:SimpleRadioButton;
		private var _timeSlider:SimpleSlider;
		private var _periodSlider:SimpleSlider;
		private var _amplitudeSlider:SimpleSlider;
		private var _overshootSlider:SimpleSlider;
		
		private var _time:Number = 2;
		private var _period:Number = 600;
		private var _amplitude:Number = 0;
		private var _overshoot:Number = 1.7;
		private var _transition:String = "easeOutElastic";
		 
		public function Main() 
		{
			graphics.lineStyle( 1.0 , 0x999999 , 1.0 );
			graphics.moveTo( 60 , 160 );
			graphics.lineTo( 60 , 200 );
			graphics.moveTo( 385 , 160 );
			graphics.lineTo( 385 , 200 );
			graphics.drawCircle( 232 , 80 , 40 );
			
			_sq = new Shape();
			_sq.graphics.beginFill( 0x000000 , 0.8 );
			_sq.graphics.drawRect( 0 , 0 , 20 , 20 );
			_sq.blendMode = "invert";
			_sq.y = 170;
			addChild( _sq );
			
			_cr = new Shape();
			_cr.graphics.beginFill( 0x000000 , 0.8 );
			_cr.graphics.drawCircle( 0 , 0 , 40 );
			_cr.blendMode = "invert";
			_cr.x = 232;
			_cr.y = 80;
			addChild( _cr );
			
			_buttons = new SimpleRadioButton();
			_buttons.x = 140;
			_buttons.y = 220;
			_buttons.addButton( "easeOutElastic" , 0 , 0 );
			_buttons.addButton( "easeOutBack" , 110 , 0 );
 			addChild( _buttons );
			
			_timeSlider = new SimpleSlider();
			_timeSlider.init( stage , "time" , 5 , 200 , _time , 1 );
			_timeSlider.x = 180;
			_timeSlider.y = 265;
			addChild( _timeSlider );
			
			_periodSlider = new SimpleSlider();
			_periodSlider.init( stage , "transitionParams : period\n(only Elastic easing)" , 1000 , 200 , _period );
			_periodSlider.x = 180;
			_periodSlider.y = 305;
			addChild( _periodSlider );
			
			_amplitudeSlider = new SimpleSlider();
			_amplitudeSlider.init( stage , "transitionParams : amplitude\n(only Elastic easing)" , 10 , 200 , _amplitude , 1 );
			_amplitudeSlider.x = 180;
			_amplitudeSlider.y = 340;
			addChild( _amplitudeSlider );
			
			_overshootSlider = new SimpleSlider();
			_overshootSlider.init( stage , "transitionParams : overshoot\n(only Back easing)" , 10 , 200 , _overshoot , 1 );
			_overshootSlider.x = 180;
			_overshootSlider.y = 375;
			addChild( _overshootSlider );
			
			var startButton:SimpleButton = new SimpleButton( "Start Tween" );
			startButton.x = 185;
			startButton.y = 410;
			addChild( startButton );
			
			_buttons.addEventListener( SimpleRadioButton.SELECT_CHANGE , setParams );
			_timeSlider.addEventListener( SimpleSlider.HANDLE_MOVE , setParams );
			_periodSlider.addEventListener( SimpleSlider.HANDLE_MOVE , setParams );
			_amplitudeSlider.addEventListener( SimpleSlider.HANDLE_MOVE , setParams );
			_overshootSlider.addEventListener( SimpleSlider.HANDLE_MOVE , setParams );
			startButton.addEventListener( MouseEvent.CLICK , startTween );
			
			doTween();
		}
		
		private function setParams( e:Event ):void 
		{
			switch ( e.target )
			{
				case _buttons            : _transition = e.target.selectedName; break;
				case _timeSlider         : _time        = e.target.getValue( 1 ); break;
				case _periodSlider       : _period      = e.target.getValue(); break;
				case _amplitudeSlider  : _amplitude  = e.target.getValue( 1 ); break;
				case _overshootSlider : _overshoot = e.target.getValue( 1 ); break;
			}
		}
		
		private function doTween():void
		{
			_sq.x = 60;
			_cr.scaleX = _cr.scaleY = 0;
			if ( !_time ) _time = 0.0000001;
			
			Tweener.addTween( _sq , { x : 385 , time : _time , transition : _transition , onComplete : doTween ,
				transitionParams : { period : _period , amplitude : _amplitude , overshoot : _overshoot } } );
				
			Tweener.addTween( _cr , { scaleX : 1 , scaleY : 1 , time : _time , transition : _transition , onComplete : doTween ,
				transitionParams : { period : _period , amplitude : _amplitude , overshoot : _overshoot } } );
		}
		
		private function startTween( e:MouseEvent ):void
		{
			Tweener.removeAllTweens();
			doTween();
		}
	}
}




import flash.display.Shape;
import flash.display.Sprite;
import flash.display.Stage;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Rectangle;
import flash.text.TextField;
import flash.text.TextFormat;

class SimpleSlider extends Sprite
{
	static public var HANDLE_MOVE:String = "handle_move";
	
	private var _stage:Stage;
	private var _tf_value:TextField;
	
	public var handle:Sprite;
	public var bar:Shape;
	public var value:Number;
	public var valueMax:Number;
	public var valueDecimals:Number;
	public var ratio:Number;
	
	public function SimpleSlider()
	{
		
	}
	
	public function init( stage:Stage , valueName:String , valueMax:Number = 1 , barLength:Number = 200 , startValue:Number = 0 , valueDecimals:int = 0 ):void
	{
		// var
		_stage = stage;
		this.valueMax = valueMax;
		this.valueDecimals = valueDecimals;
		ratio = startValue / valueMax;
		
		// handle
		handle = new Sprite();
		handle.buttonMode = true;
		handle.graphics.beginFill( 0x333333 , 1.0 );
		handle.graphics.drawRect( -3 , -7 , 6 , 14 );
		handle.x = barLength * ratio;
		
		// bar 
		bar = new Shape();
		bar.graphics.lineStyle( 1.0 , 0xBBBBBB , 1.0 );
		bar.graphics.beginFill( 0xCCCCCC , 1.0 );
		bar.graphics.drawRect( 0 , -2 , barLength , 4 );
		
		// value name
		var format:TextFormat = new TextFormat();
		format.align = "right";
		format.leading = -2;
		var tf_name:TextField = new TextField();
		tf_name.selectable = false;
		tf_name.autoSize = "right";
		tf_name.textColor = 0x666666;
		tf_name.defaultTextFormat = format;
		tf_name.text = valueName;
		tf_name.x = -tf_name.width - 6;
		tf_name.y = -10;
		
		// now value
		_tf_value = new TextField();
		_tf_value.selectable = false;
		_tf_value.autoSize = "left";
		_tf_value.textColor = 0x666666;
		_tf_value.text = String( startValue );
		_tf_value.x = bar.width + 6;
		_tf_value.y = -10;
		
		// add
		addChild( bar );
		addChild( handle );
		addChild( tf_name );
		addChild( _tf_value );
		
		// event
		handle.addEventListener( MouseEvent.MOUSE_DOWN , handleDownHandler );
	}
	
	
	/*
	 * ------------------------------------------------------------
	 * MouseEvent Handler
	 * ------------------------------------------------------------
	 */
	
	private function handleDownHandler( e:MouseEvent ):void 
	{
		// event
		_stage.addEventListener( MouseEvent.MOUSE_UP , handleUpHandler );
		_stage.addEventListener( MouseEvent.MOUSE_MOVE , handleMoveHandler );
		handle.removeEventListener( MouseEvent.MOUSE_DOWN , handleDownHandler );
		
		// start drag
		handle.startDrag( false , new Rectangle( 0 , 0 , bar.width , 0 ) );
	}
	
	
	private function handleUpHandler( e:MouseEvent ):void 
	{
		// event
		handle.addEventListener( MouseEvent.MOUSE_DOWN , handleDownHandler );
		_stage.removeEventListener( MouseEvent.MOUSE_UP , handleUpHandler );
		_stage.removeEventListener( MouseEvent.MOUSE_MOVE , handleMoveHandler );
		
		// stop drag
		handle.stopDrag();
	}
	
	
	private function handleMoveHandler( e:MouseEvent ):void 
	{
		ratio = handle.x / bar.width;
		value = ratio * valueMax;
		_tf_value.text = String( getRoundNumver( value , valueDecimals ) );
		
		dispatchEvent( new Event( SimpleSlider.HANDLE_MOVE ) );
	}
	
	
	/*
	 * ------------------------------------------------------------
	 * Get Functoin
	 * ------------------------------------------------------------
	 */
	
	// get value
	public function getValue( decimals:int = 0 ):Number
	{
		return getRoundNumver( value , decimals );
	}
	
	
	// get ratio
	public function getRatio( decimals:int = 1 ):Number
	{
		return getRoundNumver( ratio , decimals );
	}
	
	
	// get rounded numver
	private function getRoundNumver( num:Number , decimals:int ):Number
	{
		var digit:int = Math.pow( 10 , decimals );
		return Math.round( num * digit ) / digit;
	}
}




import flash.display.Shape;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;

class SimpleRadioButton extends Sprite
{
	static public var SELECT_CHANGE:String = "select_change";
	
	private var _selectObj:Shape;
	
	public var numButtons:int = 0;
	public var selectedName:String;
	public var selectedId:int;
	
	public function SimpleRadioButton() 
	{
		_selectObj = new Shape();
		_selectObj.graphics.beginFill( 0x333333 , 1.0 );
		_selectObj.graphics.drawCircle( 5 , 5 , 3 );
	}
	
	public function addButton( buttonName:String , buttonX:Number , buttonY:Number ):void
	{
		numButtons ++;
		
		if ( !numChildren )
		{
			addChild( _selectObj );
			selectedName = buttonName;
			selectedId = 1;
		}
		
		var btn:RadioButton = new RadioButton( numButtons , buttonName );
		btn.x = buttonX;
		btn.y = buttonY;
		btn.addEventListener( MouseEvent.CLICK , buttonClickHandler );
		
		addChild( btn );
	}
	
	private function buttonClickHandler( e:MouseEvent ):void 
	{
		if ( selectedId == e.target.id ) return;
		
		selectedName = e.target.name;
		selectedId = e.target.id;
		_selectObj.x = e.target.x;
		_selectObj.y = e.target.y;
		
		dispatchEvent( new Event( SimpleRadioButton.SELECT_CHANGE ) );
	}
}






import flash.display.Sprite;
import flash.text.TextField;

class RadioButton extends Sprite
{
	public var id:int;
	
	public function RadioButton( id:int , buttonName:String )
	{
		this.id = id;
		name = buttonName;
		
		buttonMode = true;
		graphics.lineStyle( 1.0 , 0x999999 , 1.0 );
		graphics.drawCircle( 5 , 5 , 5 );
		
		var tf_name:TextField = new TextField();
		tf_name.mouseEnabled = false;
		tf_name.selectable = false;
		tf_name.autoSize = "left";
		tf_name.textColor = 0x666666;
		tf_name.text = buttonName;
		tf_name.x = 13;
		tf_name.y = -5;
		
		addChild( tf_name );
		graphics.lineStyle( 1.0 , 0xFF0000 , 0 );
		graphics.beginFill( 0xFF0000 , 0 );
		graphics.drawRect( -5 , -4 , width + 8 , height );
	}
}




import flash.display.Shape;
import flash.display.Sprite;
import flash.text.TextField;
import flash.events.MouseEvent;
import flash.geom.Matrix;

class SimpleButton extends Sprite
{
	private var _overObj:Shape;
	
	public function SimpleButton( buttonName:String ) 
	{
		buttonMode = true;
		
		var tf_name:TextField = new TextField();
		tf_name.mouseEnabled = false;
		tf_name.selectable = false;
		tf_name.autoSize = "left";
		tf_name.textColor = 0xFFFFFF;
		tf_name.text = buttonName;
		tf_name.x = 21;
		tf_name.y = 2;
		addChild( tf_name );
		
		var matrix:Matrix = new Matrix();
		matrix.createGradientBox( 1 , 24 , Math.PI / 2 );
		graphics.beginGradientFill( "linear" , [ 0x333333 , 0x000000 ] , [ 1.0 , 1.0 ] , [ 0 , 255 ] , matrix );
		graphics.drawRoundRect( 0 , 0 , tf_name.width + 40 , 24 , 6 );
		
		_overObj = new Shape();
		_overObj.graphics.beginFill( 0xFFFFFF , 0.15 );
		_overObj.graphics.drawRoundRect( 0 , 0 , tf_name.width + 40 , 24 , 6 );
		
		addEventListener( MouseEvent.ROLL_OVER , overHandler );
	}
	
	private function overHandler( e:MouseEvent ):void 
	{
		addChild( _overObj );
		addEventListener( MouseEvent.ROLL_OUT , outHandler );
	}
	
	private function outHandler( e:MouseEvent ):void 
	{
		removeChild( _overObj );
		removeEventListener( MouseEvent.ROLL_OUT , outHandler );
	}
}

