/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/b7v8
 */

package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            var s:Sprite = new Sprite();
            s.graphics.beginFill(0x000000);
            s.graphics.drawRect(100,100,100,100);
            s.graphics.endFill();
            
            s.graphics.lineStyle(0,0x000000);
            s.graphics.beginFill(0x00ffff);
            s.graphics.drawCircle(400,400,100);
            s.graphics.endFill();
            
            s.graphics.lineStyle(0,0x000000);
            s.graphics.beginFill(0x0000ff);
            s.graphics.drawCircle(400,800,100);
            s.graphics.endFill();
            
            addChild(s);
            var sc:scrollUI1 = new scrollUI1(); 
            sc.showArea = true;
            sc.setArea(232,232,150);
  
            sc.setTarget(s);
            addChild(sc);
               
        }
    }
}

//---------------------------------------------------------------------------------------
    import flash.geom.*;
    import flash.display.*;
    import flash.events.*;
    class scrollUI1 extends Sprite{
        //ボタン
        private var up:Sprite = new Sprite();
        private var down:Sprite = new Sprite();
        private var left:Sprite = new Sprite();
        private var right:Sprite = new Sprite();
        private var vx:Number;
        private var vy:Number;
        private var target:DisplayObject;//スクロール対象
        private var r:Number;//エリアサイズ
        public var movSpeed:Number = 5; 
        private var speed:Number=0;
        public var showArea:Boolean = false;
        private var move:Point = new Point();
        public function scrollUI1(){
            init();
            addEventListener(MouseEvent.MOUSE_OVER,overMouse);
            addEventListener(MouseEvent.MOUSE_OUT,outMouse); 
            
        }
        
        private function init():void{
            with(up){
                graphics.beginFill(0x00ff00,0.5);
                graphics.drawRect(-20,-10,40,20);
                graphics.endFill();
                y = -200;
                

            }
            up.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
                vy = -1;
                vx = 0;
                addEventListener(Event.ENTER_FRAME,onMove);
                addEventListener(Event.ENTER_FRAME,speedUp);
                addEventListener(MouseEvent.MOUSE_OUT,leaveBtn);
                removeEventListener(Event.ENTER_FRAME,slowDown);
                });
            up.addEventListener(MouseEvent.MOUSE_UP,function():void{
                //vy = 0;
                if(speed<movSpeed/2)target.y -= -50;
                addEventListener(Event.ENTER_FRAME,slowDown);
                removeEventListener(Event.ENTER_FRAME,speedUp);
                removeEventListener(MouseEvent.MOUSE_OUT,leaveBtn);
            });

            with(down){
                y = 200;
                graphics.beginFill(0x00ff00,0.5);
                graphics.drawRect(-20,-10,40,20);
                graphics.endFill();
            }
            down.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
                    vy = 1;
                    vx = 0;
                addEventListener(Event.ENTER_FRAME,onMove);
                addEventListener(Event.ENTER_FRAME,speedUp);
                addEventListener(MouseEvent.MOUSE_OUT,leaveBtn);
                removeEventListener(Event.ENTER_FRAME,slowDown);
                });
            down.addEventListener(MouseEvent.MOUSE_UP,function():void{
                //vy = 0;
                if(speed<movSpeed/2)target.y -= 50;
                addEventListener(Event.ENTER_FRAME,slowDown);
                removeEventListener(Event.ENTER_FRAME,speedUp);
                removeEventListener(MouseEvent.MOUSE_OUT,leaveBtn);
            });
            with(left){
                x = -200;
                graphics.beginFill(0x00ff00,0.5);
                graphics.drawRect(-10,-20,20,40);
                graphics.endFill();
            }
            left.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
                vx = -1;
                vy = 0;
                addEventListener(Event.ENTER_FRAME,onMove);
                addEventListener(Event.ENTER_FRAME,speedUp);
                addEventListener(MouseEvent.MOUSE_OUT,leaveBtn);
                removeEventListener(Event.ENTER_FRAME,slowDown);
                });
            left.addEventListener(MouseEvent.MOUSE_UP,function():void{
                //vx = 0;
                if(speed<movSpeed/2)target.x -= -50;
                addEventListener(Event.ENTER_FRAME,slowDown);
                removeEventListener(MouseEvent.MOUSE_OUT,leaveBtn);
                removeEventListener(Event.ENTER_FRAME,speedUp);
            });
            with(right){
                x = 200;
                graphics.beginFill(0x00ff00,0.5);
                graphics.drawRect(-10,-20,20,40);
                graphics.endFill();
            }
            right.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
                vx = 1;
                vy = 0;
                addEventListener(Event.ENTER_FRAME,onMove);
                addEventListener(Event.ENTER_FRAME,speedUp);
                addEventListener(MouseEvent.MOUSE_OUT,leaveBtn);
                removeEventListener(Event.ENTER_FRAME,slowDown);
                });
            right.addEventListener(MouseEvent.MOUSE_UP,function():void{
                //vx = 0;
                if(speed<movSpeed/2)target.x -= 50;
                addEventListener(Event.ENTER_FRAME,slowDown);
                removeEventListener(Event.ENTER_FRAME,speedUp);
                removeEventListener(MouseEvent.MOUSE_OUT,leaveBtn);
            });
            

        }

        


        public function setTarget(t:DisplayObject=null):void{
            if(t==null){
                //removeEventListener(Event.ENTER_FRAME,onEnter);
                removeEventListener(MouseEvent.MOUSE_OVER,overMouse);
                removeEventListener(MouseEvent.MOUSE_OUT,outMouse);
            }
            
            target = t;
 
        }
        
        //スクロール領域の設定
        public function setArea(x:Number,y:Number,r:Number,show:Boolean=false):void{
            this.x = x;
            this.y = y;
            this.r = r;
            showArea=show;
            drawArea();
        }

        
        private function drawArea(color:uint=0xff0000):void{
            graphics.clear();
            if(showArea==false)graphics.beginFill(color,0);
            else graphics.beginFill(color,0.5);
            graphics.drawRect(-r,-r,r*2,r*2);
            graphics.endFill();
        }



        //エリア内にロールオーバー
        private function overMouse(e:MouseEvent):void{

            stage.removeEventListener(Event.MOUSE_LEAVE,leave);
            if(Math.abs(mouseX) < r && Math.abs(mouseY) < r){//スクロールボタン非表示
                removeChild(up);
                removeChild(down);
                removeChild(left);
                removeChild(right);
            }
        }
        //エリアの外にロールアウト →　スクロール領域
        private function outMouse(e:MouseEvent):void{
            stage.addEventListener(Event.MOUSE_LEAVE,leave);
            addChild(up);
            addChild(down);
            addChild(left);
            addChild(right);
        }
        //ステージからロールアウト
        private function leave(e:Event):void{
            stage.addEventListener(MouseEvent.MOUSE_MOVE,stageIn);
            removeChild(up);
            removeChild(down);
            removeChild(left);
            removeChild(right);
        }
        //ステージにロールオーバー →　スクロール領域
        private function stageIn(e:MouseEvent):void{
            stage.removeEventListener(MouseEvent.MOUSE_MOVE,stageIn);
            addChild(up);
            addChild(down);
            addChild(left);
            addChild(right);
        }
        
        private function leaveBtn(e:MouseEvent):void{
            addEventListener(Event.ENTER_FRAME,slowDown);
            removeEventListener(Event.ENTER_FRAME,speedUp);
            removeEventListener(Event.MOUSE_LEAVE,leaveBtn);
            
        }

        private function speedUp(e:Event):void{
            if(speed == 0)speed = 0.1;
            if(speed < movSpeed)speed *= 1.5;
            else removeEventListener(Event.ENTER_FRAME,speedUp);
        }
        private function slowDown(e:Event):void{
            if(0.001 < speed)speed /= 1.8;
            else{
                speed = 0;
                removeEventListener(Event.ENTER_FRAME,onMove);
                removeEventListener(Event.ENTER_FRAME,slowDown);
            }

        }
        private function onMove(e:Event):void{
            target.x -= vx*speed;
            target.y -= vy*speed;
        }

    }
    
    
//---------------------------------------------------------------------------------------