/**
 * Copyright nicotroia ( http://wonderfl.net/user/nicotroia )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/b7mW
 */

package {
    import flash.display.Shape;
    import flash.geom.Point;
    import flash.display.Sprite;
    
    public class GetObjectsTest extends Sprite {
        public function GetObjectsTest() {
            var container:Sprite;
            var startX:Number;
            var startY:Number;
            var squareWidth:Number = 75;
            var numColumns:Number = 4;
            var paddRight:Number = 14;
            var paddBottom:Number = 14;
            var dots:Shape;
            
            container = new Sprite();
            container.x = 100;
            container.y = 100;
            addChild(container);
            
            dots = new Shape();
            addChild(dots);
            
            for( var i:uint = 0; i < 12; i++ ) { 
                startX = ((i % numColumns) * (squareWidth + paddRight));
                startY = (int(i / numColumns) * (squareWidth + paddBottom));
                
                var shape:Shape = new Shape();
                shape.graphics.beginFill(Math.random()*0xffffff, 1.0);
                shape.graphics.drawRect(startX, startY, squareWidth, squareWidth);
                shape.graphics.endFill();
                
                container.addChild(shape);
            }
            
            dots.graphics.lineStyle(5, 0xff0000, 0.8);
            
            for( i = 0; i < 12; i++ ) { 
                startX = ((i % numColumns) * (squareWidth + paddRight)) + 25;
                startY = (int(i / numColumns) * (squareWidth + paddBottom)) + 25;
                
                var testPoint:Point = container.localToGlobal(new Point(startX, startY));
                
                dots.graphics.moveTo(testPoint.x, testPoint.y);
                dots.graphics.lineTo(testPoint.x+1, testPoint.y+1);
                
                var results:Array = container.getObjectsUnderPoint( testPoint );
                trace("testing: (" + startX + "," + startY + ") == " + results.length);
            }
        }
    }
}