/**
 * Copyright kawamura ( http://wonderfl.net/user/kawamura )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/b7fi
 */

package  {
    import com.bit101.components.*;
    import flash.display.MovieClip;
    import flash.display.Graphics;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.utils.*;
   [SWF(width = "465", height = "465", backgroundColor = "0xFFFFFF", frameRate = "30")]
    public class Main extends MovieClip {
        public static var himo_length:uint = 10;
        private var himo_init:uint=10;
        private var tate:Number=7;
        private var yoko:Number=6;
        private var masu_w:Number = 30;
        private var masu_h:Number = 30;
        private var masu_margin:Number = 20
        private var masu__selected:MovieClip;
        private var masu_list:Vector.<MovieClip>;
        private var himo:Himo;
        private var himo_list:Vector.<Himo>;
        private var id:uint;
        private var clear_id:uint;
        private var clear_btn:PushButton;
        private var clear_cnt:uint;
        public function Main() {
            var i:uint;
            var g:Graphics;
            var start_x:Number = (stage.stageWidth-(masu_w*yoko+masu_margin*(yoko-1)))*0.5;
            var start_y:Number = (stage.stageHeight-(masu_h*tate+masu_margin*(tate-1)))*0.5;
            masu_list=new Vector.<MovieClip>();
            for(i=0;i<tate*yoko;i++){
                var masu:MovieClip=new MovieClip();
                g=masu.graphics;
                g.beginFill(0xFF0000);
                g.drawRect(-0.5 * masu_w, -0.5 * masu_h, masu_w , masu_h);
                addChild(masu);
                masu.x=start_x+(masu_w + masu_margin)*(i%yoko);
                masu.y=start_y+(masu_h + masu_margin)*Math.floor(i/yoko);
                masu.addEventListener(MouseEvent.MOUSE_DOWN,mouse_down);
                masu.lx=masu.x;
                masu.ly=masu.y;
                masu.vx=0;
                masu.vy=0;
                masu.addEventListener(Event.ENTER_FRAME,masu_move,false,10,false);
                masu_list.push(masu);
                
            }
            clear_btn=new PushButton();
            addChild(clear_btn);
            clear_btn.label="clear";
            clear_btn.addEventListener(MouseEvent.CLICK,clear_click);
            var shock_btn:PushButton = new PushButton();
            addChild(shock_btn);
            clear_btn.x=5;
            clear_btn.y=5;
            shock_btn.label="shock";
            shock_btn.addEventListener(MouseEvent.CLICK,masu_shock);
            shock_btn.x=110;
            shock_btn.y=5;
            /**/
            himo_list=new Vector.<Himo>();
            for(i=0;i<himo_init;i++){
                himo=new Himo();
                himo_list.push(himo);
                addChild(himo);
                var masu_start:MovieClip=masu_list[Math.floor(masu_list.length*Math.random())];
                var masu_end:MovieClip=masu_list[Math.floor(masu_list.length*Math.random())];
                himo.mouse_down(masu_start);
                himo.mouse_up(masu_end);
            }
            masu_shock();
        }
        //
        public function remove_himo(_himo:Himo):void{
            var i:uint;
            var n:uint = himo_list.length;
            for(i=0;i<n;i++){
                if(himo_list[i] ==_himo){
                    himo_list.splice(i,1);
                    _himo.event_clear();
                    removeChild(_himo);
                    break;
                }
            }
        }
        //
        private function clear_interval(_himo:Himo):void{
            _himo.remove();
        }
        private function clear_click(event:MouseEvent):void{

            var i:uint;
            var n:uint=himo_list.length;
            for(i=0;i<n;i++){
                var himo:Himo=himo_list[i];
                clear_id=setTimeout(clear_interval,10*i,himo);
            }
        }
        
        private function hart_move():void{
            var n:Number=masu_list.length;
            var i:uint;
            for(i=0;i<n;i++){
                var masu:MovieClip=masu_list[i];
                var v:Number=5+2*Math.random();
                var theta:Number = 2*Math.PI*Math.random();
                masu.vx = v * Math.cos(theta);
                masu.vy = v * Math.sin(theta);
            }
        }
        private function masu_shock(event:MouseEvent = null):void{
            var n:Number=masu_list.length;
            var i:uint;
            for(i=0;i<n;i++){
                var masu:MovieClip=masu_list[i];
                var v:Number=20+10*Math.random();
                var theta:Number = 2*Math.PI*Math.random();
                masu.vx = v * Math.cos(theta);
                masu.vy = v * Math.sin(theta);
            }
            clearInterval( id );
            id = setInterval(hart_move,1500);
        }
        private function masu_move(event:Event):void{
            var masu:MovieClip = MovieClip( event.currentTarget );
            var ax:Number = 0.1 * (masu.lx-masu.x)-0.2*masu.vx;
            var ay:Number = 0.1 * (masu.ly-masu.y)-0.2*masu.vy;
            masu.vx += ax;
            masu.vy += ay;
            masu.x+=masu.vx;
            masu.y+=masu.vy;
            if(mouseX > masu.x-masu_w*0.5 && mouseX<masu.x+masu_w*0.5 && mouseY > masu.y-masu_h*0.5 && mouseY<masu.y+masu_h*0.5){
                masu.alpha = 0.25;
            }else{
                masu.alpha = 1.0;
            }
        }
        private function mouse_down(event:Event):void{
            masu__selected=MovieClip(event.currentTarget);
            himo=new Himo();
            himo_list.push(himo);
            addChild(himo);
            himo.mouse_down(masu__selected);
            //
            stage.addEventListener(MouseEvent.MOUSE_UP,mouse_up);
        }
        private function mouse_up(event:Event):void{
            var n:Number=masu_list.length;
            var i:uint;
            
            for(i=0 ; i < n ; i++){
                var masu:MovieClip= masu_list[i];
                if(mouseX > masu.x-masu_w*0.5 && mouseX<masu.x+masu_w*0.5 && mouseY > masu.y-masu_h*0.5 && mouseY<masu.y+masu_h*0.5){
                    himo.mouse_up(masu);
                    stage.removeEventListener(MouseEvent.MOUSE_UP,mouse_up);
                    break;
                }
                if(i==n-1){
                    stage.removeEventListener(MouseEvent.MOUSE_UP,mouse_up);
                    himo.mouse_up();
                }
            }
        }
    }
    
}
import flash.display.MovieClip;
import flash.events.Event;
import flash.display.Graphics;
import flash.events.MouseEvent;

class Himo extends MovieClip{
    private var k:Number=0.7;
    private var u:Number=0.8;
    private var gravity:Number= 0.98*2;
    private var himo_list:Vector.<MovieClip>;
    private var mouse_point:MovieClip;
    private var alpha_flag:Boolean = true;
    function Himo(){
    }
    public function event_clear():void{
        mouse_point.removeEventListener(Event.ENTER_FRAME,mouse_move);
        removeEventListener(Event.ENTER_FRAME,enter_frame);
        removeEventListener(Event.ENTER_FRAME,alpha_move);
        removeEventListener(Event.ENTER_FRAME,release_move);
        removeEventListener(Event.ENTER_FRAME,remove_move);
    }
    public function mouse_down(_mc:MovieClip):void{
        himo_list = new Vector.<MovieClip>();
        var point:MovieClip=new MovieClip();
        point.x=_mc.x;
        point.y=_mc.y;
        point.vx=0;
        point.vy=0;
        point.masu=_mc;
        point.addEventListener(Event.ENTER_FRAME,masu_move,false,11,false);
        himo_list.push(point);
        var n:uint=Main.himo_length;
        var half_n:Number = Math.floor(n/2);
        var i:uint;
        for(i=0;i<n;i++){
            point = new MovieClip();
            point.x=_mc.x+(stage.mouseX - _mc.x)/(Main.himo_length+1);
            point.y=_mc.y+(stage.mouseY - _mc.y)/(Main.himo_length+1);
            point.vx=0;
            point.vy=0;
            addChild(point);
            himo_list.push(point);
            if( half_n == i ){
                var close_btn:MovieClip=new MovieClip();
                point.addChild(close_btn);
                var close_graphic:Graphics = close_btn.graphics;
                /**/
                close_graphic.beginFill(0x333333);
                close_graphic.drawCircle(0,0,5);
                close_graphic.lineStyle(1,0xFFFFFF);
                close_graphic.moveTo(4*Math.cos((45/360)*2*Math.PI),4*Math.sin((45/360)*2*Math.PI));
                close_graphic.lineTo(4*Math.cos((225/360)*2*Math.PI),4*Math.sin((225/360)*2*Math.PI));
                close_graphic.endFill();
                close_graphic.moveTo(4*Math.cos((-45/360)*2*Math.PI),4*Math.sin((-45/360)*2*Math.PI));
                close_graphic.lineTo(4*Math.cos((-225/360)*2*Math.PI),4*Math.sin((-225/360)*2*Math.PI));
                close_graphic.endFill();
                close_btn.ly=1;
                close_btn.vy=0;
                close_btn.addEventListener(MouseEvent.CLICK,close_click);
                close_btn.addEventListener(MouseEvent.MOUSE_OVER, close_mouseover);
                close_btn.addEventListener(MouseEvent.MOUSE_OUT , close_mouseout);
                close_btn.addEventListener(Event.ENTER_FRAME,cloase_enter);
                close_btn.buttonMode=true;
            }
        }
        mouse_point=new MovieClip();
        mouse_point.x = stage.mouseX;
        mouse_point.y = stage.mouseY;
        himo_list.push(mouse_point);
        draw_line();
        
        mouse_point.addEventListener(Event.ENTER_FRAME,mouse_move,false,10,false);
        addEventListener(Event.ENTER_FRAME,enter_frame,false,0,false);
        
    }
    
    public function mouse_up(last_masu:MovieClip = null ):void{
        if(last_masu){
            //himo_list[himo_list.length-1] = last_masu;
            mouse_point.removeEventListener(Event.ENTER_FRAME,mouse_move);
            mouse_point.masu=last_masu;
            mouse_point.addEventListener(Event.ENTER_FRAME,masu_move,false,12,false);
            removeEventListener(Event.ENTER_FRAME,enter_frame);
            addEventListener(Event.ENTER_FRAME,enter_frame,false,0,false);
        }else{
            removeEventListener(Event.ENTER_FRAME,enter_frame);
            mouse_point.removeEventListener(Event.ENTER_FRAME,mouse_move);
            mouse_point.vx=0;
            mouse_point.vy=0;
            //
            k=1;
            u=0.9995;
            gravity=0;
            addEventListener(Event.ENTER_FRAME,release_move);
        }
    }
    public function remove():void{

        removeEventListener(Event.ENTER_FRAME,enter_frame);
        
        mouse_point.removeEventListener(Event.ENTER_FRAME,mouse_move);
        mouse_point.removeEventListener(Event.ENTER_FRAME,masu_move);
        mouse_point.vx=0;
        mouse_point.vy=0;
        
        var point:MovieClip=himo_list[0];
        point.removeEventListener(Event.ENTER_FRAME,mouse_move);
        point.removeEventListener(Event.ENTER_FRAME,masu_move);
        point.vx=0;
        point.vy=0;
        //
        k=0.5;
        u=0.2;
        gravity=0.98*2;
        addEventListener(Event.ENTER_FRAME,remove_move);
    }
    //
    private function masu_move(event:Event):void{
        var point:MovieClip=MovieClip(event.currentTarget);
        var masu:MovieClip=MovieClip(point.masu);
        point.x=masu.x;
        point.y=masu.y;
    }
    private function close_click(event:MouseEvent):void{
        remove();
    }
    private function close_mouseover(event:Event):void{
        var _mc:MovieClip=MovieClip(event.currentTarget);
        _mc.ly=3;
        
    }
    private function close_mouseout(event:Event):void{
        var _mc:MovieClip=MovieClip(event.currentTarget);
        _mc.ly=1;
    }
    private function cloase_enter(event:Event):void{
        var _mc:MovieClip=MovieClip(event.currentTarget);
        var ay:Number=0.2*(_mc.ly-_mc.scaleX)-0.3*_mc.vy;
        _mc.vy+=ay;
        _mc.scaleX+=_mc.vy;
        _mc.scaleY =_mc.scaleX;
    }
    private function remove_move(event:Event):void{
        var ax:Number;
        var ay:Number;
        var point_dx:Number;
        var point_dy:Number;
        var i:uint;
        var point:MovieClip;
        var line_lenght:Number=0;
        var front_point:MovieClip;
        var next_point:MovieClip;
        for(i=0;i<himo_list.length;i++){
            point=himo_list[i];
            if(i == 0){
                next_point = himo_list[1];
                point.dx = (next_point.x-point.x);
                point.dy = (next_point.y-point.y);
            }else if(i==himo_list.length-1){
                front_point = himo_list[i-1];
                point.dx = (front_point.x-point.x);
                point.dy = (front_point.y-point.y);
            }else{
                front_point = himo_list[i-1];
                next_point = himo_list[i+1];
                point.dx = (front_point.x-point.x) + (next_point.x-point.x);
                point.dy = (front_point.y-point.y) + (next_point.y-point.y);
            }
        }
            //
        for(i=0;i<himo_list.length;i++){
            point=himo_list[i];
            ax=k*point.dx;
            ay=k*point.dy+gravity;
            
            point.vx += ax-u*point.vx;
            point.vy += ay-u*point.vy;
            point.x += point.vx;
            point.y += point.vy;
            if( i !=0){
                front_point = himo_list[i-1];
                line_lenght +=Math.sqrt(Math.pow(front_point.x - point.x , 2) + Math.pow( front_point.y - point.y,2));
            }
            /**/
            //
            draw_line();
        }

        if(line_lenght<50 && alpha_flag){
            alpha_flag = false;
            addEventListener(Event.ENTER_FRAME,alpha_move);
        }
    }
    private function release_move(event:Event):void{
        var ax:Number;
        var ay:Number;
        var point_dx:Number;
        var point_dy:Number;
        var i:uint;
        var point:MovieClip;
        var line_lenght:Number=0;
        for(i=1;i<himo_list.length;i++){
            var front_point:MovieClip;
            var next_point:MovieClip;
            if(i==himo_list.length-1){
                front_point = himo_list[i-1];
                point=himo_list[i];
                point_dx = (front_point.x-point.x);
                point_dy = (front_point.y-point.y);
            }else{
                front_point = himo_list[i-1];
                point=himo_list[i];
                next_point = himo_list[i+1];
                point_dx = (front_point.x-point.x) + (next_point.x-point.x);
                point_dy = (front_point.y-point.y) + (next_point.y-point.y);

            }
            //
            ax=k*point_dx;
            ay=k*point_dy+gravity;
            point.vx+=ax-u*point.vx;
            point.vy+=ay-u*point.vy;
            point.x +=point.vx;
            point.y +=point.vy;
            line_lenght +=Math.sqrt(Math.pow(front_point.x - point.x , 2) + Math.pow( front_point.y - point.y,2));
            //
            draw_line();
        }
        if(line_lenght<50 && alpha_flag){
            alpha_flag = false;
            addEventListener(Event.ENTER_FRAME,alpha_move);
        }
    }
    private function alpha_move(event:Event):void{
        var da:Number=0-this.alpha;
        this.alpha+=da*0.2;
        if(this.alpha<0.5){
            removeEventListener(Event.ENTER_FRAME,remove_move);
            removeEventListener(Event.ENTER_FRAME,alpha_move);
            removeEventListener(Event.ENTER_FRAME,release_move);
            event_clear();
            MovieClip(this.parent).remove_himo(this)
        }
    }
    private function mouse_move(event:Event = null):void{
        mouse_point.x=stage.mouseX;
        mouse_point.y=stage.mouseY;
    }
    private function enter_frame(event:Event = null):void{
        var i:uint;
        var point:MovieClip;
        for(i=1;i<himo_list.length-1;i++){
            var front_point:MovieClip=himo_list[i-1];
            point=himo_list[i];
            var next_point:MovieClip=himo_list[i+1];
            var point_dx:Number = (front_point.x-point.x) + (next_point.x-point.x);
            var point_dy:Number = (front_point.y-point.y) + (next_point.y-point.y);
            var ax:Number=k*point_dx;
            var ay:Number=k*point_dy+gravity;
            point.vx+=ax-u*point.vx;
            point.vy+=ay-u*point.vy;
            point.x +=point.vx;
            point.y +=point.vy;
        }
        draw_line();
    }
    private function draw_line():void{
        var i:uint
        var g:Graphics=this.graphics;
        g.clear();
        var point:MovieClip=himo_list[0];
        g.lineStyle(1,0x000000);
        g.moveTo(point.x,point.y);
        for(i=1;i<himo_list.length;i++){
            point=himo_list[i];
            g.lineTo(point.x,point.y);
        }
    }
}