package  {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.media.Sound;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;

	/**
	* Tribute to cyriak.
	* @author makc
	* @license WTFPLv2
	* @see http://www.youtube.com/watch?v=Ag-_SOihwwg
	*/
	public class PedobearFractal extends Sprite {
		private var head:BitmapData;
		private var screen:BitmapData;
		private var loader:Loader;
		public function PedobearFractal () {
			super ();
			head = new BitmapData (256, 256, true, 0xFFFFFF);
			screen = new BitmapData (465, 465);
			addChild (new Bitmap (screen));
			loader = new Loader;
			loader.contentLoaderInfo.addEventListener (
				Event.COMPLETE,
				function (e:Event):void {
					head.draw (e.target.content);
				}
			);
			/*loader.load (new URLRequest (
				"pedobearhead.png"),
				new LoaderContext (true)
			);*/
			loader.loadBytes (new Base64 (Bear.data));
			addEventListener (Event.ENTER_FRAME, loop);
			// and some cyriak music too...
			var music:Sound = new Sound;
			music.load (new URLRequest (
				"http://s3.amazonaws.com/beatsdigital-previews/3/0/1/301954.mp3"));
			music.play (0, int.MAX_VALUE);
		}
		private var aAt:Array = [ new Point (260, 718), new Point (228, 470) ];
		private var aTo:Array = [ new Point (2.193956404725932, -1.1985638465105075), new Point (1, 0) ];
		private var t:Number = 0;
		private function loop (e:Event):void {
			t += 0.07; if (t > 1.0) t -= 1.0;

			var at:Point = Point.interpolate (aAt [0], aAt [1], t);
			var to:Point = Point.interpolate (aTo [0], aTo [1], t);

			screen.fillRect (screen.rect, 0xFFFFFF);
			drawHead (at, to);

			var m:Matrix = new Matrix; m.rotate (Math.PI); m.translate (465, 465);
			screen.draw (screen, m);

			m.identity (); m.rotate (-Math.PI / 2); m.translate (0, 465);
			screen.draw (screen, m);
		}
		private function drawHead (at:Point, to:Point):void {
			var s:Number = to.length;
			if (s > 0.02) {
				var a:Number = Math.atan2 (to.y, to.x);
				var m:Matrix = new Matrix;
				m.translate (-128, -128);
				m.scale (s, s);
				m.rotate (a);
				m.translate (at.x, at.y);
				// draw head
				screen.draw (head, m, null, null, null, true);
				// repeat for left ear
				m.identity (); m.rotate (+1.1); m.scale (-105, -105);
				var left:Point = m.transformPoint (to).add (at);
				m.identity (); m.rotate (-0.6); m.scale (0.37, 0.37);
				drawHead (left, m.transformPoint (to));
				// repeat for right ear
				m.identity (); m.rotate (-1.2); m.scale (+100, +100);
				var right:Point = m.transformPoint (to).add (at);
				m.identity (); m.rotate (+0.5); m.scale (0.40, 0.40);
				drawHead (right, m.transformPoint (to));
			}
		}
	}
}

// base64 code by 2ndyofyyx,
// http://wonderfl.kayac.com/code/b3a19884080f5ed34137e52e7c3032f3510ef861
import flash.utils.ByteArray; 
class Base64 extends ByteArray { 
    private static const BASE64:Array = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,0,0,0,63,52,53,54,55,56,57,58,59,60,61,0,0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,0,0,0,0,0,0,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,0,0,0,0,0]; 
    public function Base64(str:String) { 
        var n:int, j:int; 
        for (var i:int = 0; i < str.length && str.charAt(i) != "="; i++) {
			if (str.charCodeAt(i) < 32) continue;
            j = (j << 6) | BASE64[str.charCodeAt(i)]; 
            n += 6; 
            while(n >= 8) { 
                writeByte((j >> (n -= 8)) & 0xFF); 
            } 
        } 
        position = 0; 
    } 
}

class Bear {
	public static var data:XML = <bear>iVBORw0KGgoAAAANSUhEUgAAAQAAAAEACAYAAABccqhmAAAABGdBTUEAAK/INwWK6QAAABl0RVh0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</bear>;
}