/**
 * Copyright NewKrok ( http://wonderfl.net/user/NewKrok )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/b5nG
 */

package {
    
    import flash.display.Sprite;
    import flash.geom.Point;
    
    public class Bezier extends Sprite {
        
        private var drawContent:Sprite
        
        private var maps:Vector.<Vector.<Point>> = new Vector.<Vector.<Point>>
        private var currentMap:Array
        
        public function Bezier () {
            
            maps[0] = new Vector.<Point>
            maps[0].push ( new Point ( 18, 77.4 ), new Point ( 139.9, 22 ), new Point ( 284.9, 23.25 ), new Point ( 385.95, 70 ), new Point ( 379.95, 228.05 ), new Point ( 323.95, 331.05 ), new Point ( 110.95, 356.05 ), new Point ( 36.95, 229 ), new Point ( 143.9, 92.75 ), new Point ( 322.9, 186 ), new Point ( 273.9, 287.85 ), new Point ( 122.85, 278.4 ), new Point ( 133.4, 203.9 ), new Point ( 216.95, 205.9 ) )
            
            currentMap = createMapInfo ( 0 )
            drawCurrentMap ()
            
            addChild ( new Ball ( currentMap ) )
            
        }
        
        private function drawCurrentMap () :void {
            
            drawContent = new Sprite ()
            drawContent.graphics.lineStyle ( 1, 0xCCCCCC, 1 )
            drawContent.graphics.moveTo ( currentMap[0].x, currentMap[0].y )
            var i:int = 1
            while ( i < currentMap.length ) {
                drawContent.graphics.lineTo ( currentMap[i].x, currentMap[i].y )
                i++
            }
            addChild ( drawContent )
            
        }
        
        private function createMapInfo ( $level:int ) :Array {

            var generatedMap:Array = new Array ()
            
            var i:int
            for ( i = 0; i < maps[$level].length; i++ ) {
                var p0:Point = maps[$level] [ ( (  i == 0 ) ? 0 : i - 1 ) ]
                var p1:Point = maps[$level] [i]
                var p2:Point = maps[$level] [ ( (  i + 1 > maps[$level].length - 1 ) ? maps[$level].length - 1 : i + 1 ) ]
                var p3:Point = maps[$level] [ ( (  i + 2 > maps[$level].length - 1 ) ? maps[$level].length - 1 : i + 2 ) ]
                
                var tmpMap:Array = new Array ()
                for ( var j:int = 1; j < 500; j++ ) {
                    var q:Point = getPoint ( p0, p1, p2, p3, 0.002 * j )
                    tmpMap.push ( new Point ( q.x, q.y ) )
                }
                
                var tmpLength:Number = 0
                var k:int = 0
                while ( k < tmpMap.length - 2 ) {
                    tmpLength += Math.sqrt ( Math.pow ( tmpMap[k + 1].x - tmpMap[k].x, 2 ) + Math.pow ( tmpMap[k + 1].y - tmpMap[k].y, 2 ) )
                    k++
                }
                
                k = 0
                while ( k < tmpMap.length - 1 ) {
                    generatedMap.push ( tmpMap[k] )
                    k++
                }
            }

            return generatedMap
            
        }
        
        private function getPoint ( $p0:Point, $p1:Point, $p2:Point, $p3:Point, $t:Number ) :Point {

            return new Point (  0.5 * ( ( 2 * $p1.x ) + $t * ( ( -$p0.x + $p2.x ) + $t * ( ( 2 * $p0.x - 5 * $p1.x + 4 * $p2.x - $p3.x ) + $t * ( -$p0.x + 3 * $p1.x - 3 * $p2.x + $p3.x ) ) ) ) ,
                                0.5 * ( ( 2 * $p1.y ) + $t * ( ( -$p0.y + $p2.y ) + $t * ( ( 2 * $p0.y - 5 * $p1.y + 4 * $p2.y - $p3.y ) + $t * ( -$p0.y + 3 * $p1.y - 3 * $p2.y + $p3.y ) ) ) )
                             )
            
        }
        
    }
    
}

import flash.display.Sprite
import flash.events.Event
class Ball extends Sprite {
    
    private var currentMap:Array
    private var myMapPoint:int = 0
    private var speed:int = 10
    
    public function Ball ( $currentMap:Array ) :void {
        
        currentMap = $currentMap
        graphics.lineStyle ( 1, 0x000000, 1 )
        graphics.drawCircle ( 0, 0, 10 )
        graphics.lineStyle ( 1, 0x0000FF, 1 )
        graphics.moveTo ( 0, 0 )
        graphics.lineTo ( 0, 10 )
        addEventListener ( Event.ENTER_FRAME, move )
        
    }

    public function move ( event:Event ) :void {
        
        myMapPoint += speed
        if ( myMapPoint >= currentMap.length - 1 ) {
            myMapPoint = 0
        } else {
            x = currentMap[myMapPoint].x
            y = currentMap[myMapPoint].y
        }
        
        if ( myMapPoint + 1 < currentMap.length - 1 )
            rotation = -90 + Math.atan2 ( currentMap[myMapPoint + 1].y - currentMap[myMapPoint].y, currentMap[myMapPoint + 1].x - currentMap[myMapPoint].x ) / ( Math.PI / 180 )
        else
            rotation = -90 + Math.atan2 ( currentMap[myMapPoint].y - currentMap[myMapPoint - 1].y, currentMap[myMapPoint].x - currentMap[myMapPoint - 1].x ) / ( Math.PI / 180 )
        
    }
}