/**
 * Copyright ta6b ( http://wonderfl.net/user/ta6b )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/b5j7
 */

//Flashで作る3Dのお勉強5
//rotateX,rotateY,rotateZの実装。
package 
{
	import flash.display.Sprite;
	import flash.events.*;
	import flash.text.TextField;
	import flash.ui.Keyboard;
	
	[SWF(backgroundColor=0x333333, frameRate=60)]
	public class Test3D extends Sprite
	{
		private var plates:Array;
		private var numPlates:Number = 50;
		private var focalLength:Number = 250;
		private var vpX:Number = stage.stageWidth / 2;
		private var vpY:Number = stage.stageHeight / 2;
		private var tx:Number;
		private var ty:Number;
		private var tz:Number;
		private var easing:Number = .1;
		
		function Test3D() 
		{
			init();
		}
		
		private function init():void
		{
			plates = new Array();
			for (var i:int = 0; i < numPlates; i++) {
				var plate:Plate = new Plate(20,Math.random()*0xffffff);
				plates.push(plate);
				plate.xpos = Math.random() * 250 - 125;
				plate.ypos = Math.random() * 250 - 125;
				plate.zpos = Math.random() * 250 - 125;
				addChild(plate);
			}
			
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		
		private function enterFrameHandler(e:Event):void
		{
			var angleX:Number = (mouseY - vpY) * .001;
			var angleY:Number = (mouseX - vpX) * .001;
			var angleZ:Number = (mouseX - vpX) * .001;
			for (var i:int = 0; i < numPlates; i++) {
				var plate:Plate = plates[i];
				var dx:Number = tx - plate.xpos;
				var dy:Number = ty - plate.ypos;
				var dz:Number = tz - plate.zpos;
				rotateX(plate, angleX);
				rotateY(plate, angleY);
				rotateZ(plate, angleZ);
				doPerspective(plate);
			}
			sortZ();
		}
		
		private function rotateX(plate:Plate, angleX:Number):void {
			var cosX:Number = Math.cos(angleX);
			var sinX:Number = Math.sin(angleX);
			
			var y1:Number = plate.ypos * cosX - plate.zpos * sinX;
			var z1:Number = plate.zpos * cosX + plate.ypos * sinX;
			
			plate.ypos = y1;
			plate.zpos = z1;
			
		}
		
		private function rotateY(plate:Plate, angleY:Number):void {
			var cosY:Number = Math.cos(angleY);
			var sinY:Number = Math.sin(angleY);
			
			var x1:Number = plate.xpos * cosY - plate.zpos * sinY;
			var z1:Number = plate.zpos * cosY + plate.xpos * sinY;
			
			plate.xpos = x1;
			plate.zpos = z1;
			
		}
		
		private function rotateZ(plate:Plate, angleZ:Number):void {
			var cosZ:Number = Math.cos(angleZ);
			var sinZ:Number = Math.sin(angleZ);
			
			var x1:Number = plate.xpos * cosZ - plate.ypos * sinZ;
			var y1:Number = plate.ypos * cosZ + plate.xpos * sinZ;
			
			plate.xpos = x1;
			plate.ypos = y1;
			
		}
		
		private function doPerspective(plate:Plate):void {
			if (plate.zpos > -focalLength) {
				var scale:Number = focalLength / (focalLength + plate.zpos);
				plate.scaleX = plate.scaleY = scale;
				plate.x = vpX + plate.xpos * scale;
				plate.y = vpY + plate.ypos * scale;
				plate.visible = true;
				plate.alpha = scale-.2;
			}else {
				plate.visible = false;
			}
		}
		
		private function sortZ():void {
			plates.sortOn("zpos", Array.DESCENDING | Array.NUMERIC);
			for (var i:int = 0; i < numPlates; i++) {
				var plate:Plate = plates[i];
				setChildIndex(plate, i);
			}
		}
	}
}
import flash.display.Sprite;
	
	internal class Plate extends Sprite 
	{
		private var w:Number;
		public var xpos:Number = 0;
		public var ypos:Number = 0;
		public var zpos:Number = 0;
		public var vx:Number = 0;
		public var vy:Number = 0;
		public var vz:Number = 0;
		function Plate(w:Number = 100, color:uint = 0xffffff)
		{
			this.w = w;
			graphics.lineStyle(1, 0xffffff);
			graphics.beginFill(color);
			graphics.drawRect( -w / 2, -w / 2, w, w);
			graphics.endFill();
		}
	}