/**
 * Copyright WeRelax ( http://wonderfl.net/user/WeRelax )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/b52k
 */

package
{
 import gs.TweenLite;
 import gs.easing.*;
 
 import flash.display.*;
 import flash.events.*;
 import flash.filters.BlurFilter;
 import flash.filters.GlowFilter;
 
 import org.papervision3d.cameras.Camera3D;
 import org.papervision3d.lights.PointLight3D;
 import org.papervision3d.materials.*;
 import org.papervision3d.materials.utils.MaterialsList;
 import org.papervision3d.objects.*;
 import org.papervision3d.objects.primitives.*;
 import org.papervision3d.render.BasicRenderEngine;
 import org.papervision3d.scenes.Scene3D;
 import org.papervision3d.view.Viewport3D;
 import org.papervision3d.view.layer.ViewportLayer;

	
//import Pool;
	
	[SWF(width=640, frameRate = "30", backgroundColor = "#995555")]
	
	public class Main extends Sprite
	{
		private var scene:Scene3D;
		private var cam:Camera3D;
		private var view:Viewport3D;
		private var bre:BasicRenderEngine;
		
		private var objects:Array = new Array();
		private var radio:int = 400;
		
		private var cube_color:int = 0x000000;
		private var flash_color:int = 0xffffff;
		
		
		public function Main ()
		{
			init3d();
			filters = [new BlurFilter(2,2,1)];
			addEventListener(Event.ENTER_FRAME, onFrame);
		}
		
		private function init3d():void
		{
			scene = new Scene3D();
			cam = new Camera3D();
			cam.zoom = 20;
			cam.focus = 30;
			view = new Viewport3D(640, 480, true);
			bre = new BasicRenderEngine();

			var cube:Cube;
			for (var i:int = 0; i < 40; i++) 
			{
				cube = crearCubo();
				objects.push(cube);
				scene.addChild(cube);
				startMoving(cube);				
			}
			
			addChild(view);
		}
		
		private function startMoving(obj:DisplayObject3D, delay:Number = 0):void
		{
			var ratio:Number = Math.floor(obj.z/4000);
			var speed:Number = ratio + 2 * Math.random();
			var rotationX:Number = ratio*50 + Math.random() * 150;
			var rotationY:Number = ratio*50 + Math.random() * 150;
			var rotationZ:Number = ratio*50 + Math.random() * 150;
			TweenLite.to(obj, speed, 
				{z: 0, rotationX: rotationX, rotationY: rotationY, rotationZ:rotationZ,
					onComplete: resetCube, onCompleteParams: [obj], ease: Linear.easeNone, delay: delay});
		}
		
		private function resetCube(cube:Cube):void
		{
			scene.removeChild(cube);
			var theta:Number = Math.random() * 2*Math.PI;
			var r:Number = radio + Math.random()*500;
			var x:Number = r * Math.sin(theta);
			var y:Number = r * Math.cos(theta);			
			cube.rotationX = cube.rotationY = cube.rotationZ = 0;
			cube.x = x;
			cube.y = y;
			cube.z = 20000;
			scene.addChild(cube);
			startMoving(cube);
		}
		
		private function crearCubo():Cube
		{
			var matlist:MaterialsList = new MaterialsList(
								{all: new ColorMaterial(cube_color)});
			var w:int = 100 + 300*Math.random();
			var h:int = 100 + 300*Math.random();
			var d:int = 100 + 300*Math.random();
			var cube:Cube = new Cube(matlist, w, h, d, 1, 1, 1);
			
			var theta:Number = Math.random() * 2*Math.PI;
			var r:Number = radio + Math.random()*500;
			var x:Number = r * Math.sin(theta);
			var y:Number = r * Math.cos(theta);				
			cube.x = x;
			cube.y = y;
			cube.z = Math.random() * 20000;		
			return cube;
		}
		
		private function onFrame(e:Event):void
		{
			if (Math.random() > 0.7)
			{
				var index:int = Math.floor(Math.random() * objects.length);
				var c:Cube = objects[index];
				c.materials.getMaterialByName("all").fillColor = flash_color;
				TweenLite.delayedCall(.04, function():void {c.materials.getMaterialByName("all").fillColor = cube_color;});
			}
			cam.rotationZ += .5;
			bre.renderScene(scene, cam, view);
		}
	}
}