/**
 * Copyright Smyron ( http://wonderfl.net/user/Smyron )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/b3lv
 */

// forked from 9re's Customizing Wonderfl Score API
package  
{
    import com.bit101.components.Component;
    import com.bit101.components.Style;
    i
    import net.wonderfl.score.basic.BasicScoreRecordViewer;
    import flash.display.Sprite;
    /**
     * Wonderfl Score API Sample
     * @author kobayashi-taro
     * @see http://wonderfl.net/static/asdoc/score
     */
    [SWF(backgroundColor = "#666666")]
    public class CustomizingScoreAPI extends Sprite
    {
        
        public function CustomizingScoreAPI() 
        {
            Component.initStage(stage);
            
            // changing the colors of the components
            Style.BACKGROUND = ~Style.BACKGROUND;
            Style.BUTTON_FACE = ~Style.BUTTON_FACE;
            Style.DROPSHADOW = ~Style.DROPSHADOW;
            Style.INPUT_TEXT = ~Style.INPUT_TEXT;
            Style.LABEL_TEXT = ~Style.LABEL_TEXT;
            Style.PANEL = ~Style.PANEL;
            
            var score:int = (1100 + 1999 * Math.random()) * 10;
            
            new MyScoreForm(this, (465 - BasicScoreForm.WIDTH)/2, (465 - BasicScoreForm.HEIGHT) /2, score, _showRanking);
        }
        
        private function _showRanking():void
        {
            new MyRanking(this, (465 - BasicScoreRecordViewer.WIDTH) /2, (465 - BasicScoreRecordViewer.HEIGHT) /2, 20, false).defaultColor = 0;
        }
        
    }

}
import com.adobe.serialization.json.JSON;
import com.bit101.components.Label;
import com.bit101.components.PushButton;
import flash.display.DisplayObjectContainer;
import flash.display.Loader;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.net.URLRequest;
import flash.system.LoaderContext;
import net.wonderfl.score.basic.BasicScoreForm;
import net.wonderfl.score.basic.BasicScoreRecordViewer;
import net.wonderfl.score.basic.Window;
import org.libspark.betweenas3.BetweenAS3;

class MyScoreForm extends BasicScoreForm {
    private var _confirm:Window;
    private var _onFadeOutComplete:Function;
    
    public function MyScoreForm($parent:DisplayObjectContainer = null, $xpos:Number = 0, $ypos:Number = 0, $score:int = 0, $onFadeOutComplete:Function = null) {
        _onFadeOutComplete = $onFadeOutComplete;
        // changing the texts used in the labels
        super($parent, $xpos, $ypos, $score, 'LAP TIME');
        
        // add icon to the score form
        var iconURL:String = this.root.loaderInfo.parameters["viewer.iconURL"];
        if (iconURL) {
            var ldr:Loader = new Loader;
            ldr.contentLoaderInfo.addEventListener(Event.COMPLETE, function ():void {
                ldr.scaleX = ldr.scaleY = 0.5;
            });
            ldr.load(new URLRequest(iconURL));
            ldr.y = _lblYourScore.y;
            ldr.x = 10;
            _lblYourName.x += 20;
            _lblYourScore.x += 20;
            _lblScore.x += 20;
            _userNameField.x += 20;
            _window.addChild(ldr);
        }
        
        // scaling & adding units to the score
        // note : this does not affect the actual value
        // registered in the database. the score is treated
        // as integer in the database.
        _lblScore.text = Math.floor($score / 10) / 100 + ' [sec]';
        // changing the texts used in the labels
        _lblYourScore.text = 'LAP TIME :';
        _lblYourName.text = 'PLAYER :';
        // changing the labels used in the button
        _btnSend.label = 'REGISTER';
    }
    
    override protected function onSendClick($event:MouseEvent):void 
    {
        super.onSendClick($event);
        // changing the text when button is pressed
        _btnSend.label = 'REGISTERING...';
    }
    
    override protected function onError($errorMessage:String):void 
    {
        super.onError($errorMessage);
        _btnSend.label = 'REGISTER';
    }
    
    override protected function onComplete():void 
    {
        super.onComplete();
        _btnSend.label = 'FINISH';
        
        _onCloseClick(saveComplete);
    }
    
    override protected function _onCloseClick($didSendComplete:Boolean):void 
    {
        if ($didSendComplete) {
            _closeWindow(null);
        } else {
            if (_confirm) {
                _confirm.x = _confirm.y = 0;
                addChild(_confirm);
            } else {
                _confirm = new Window(this, 0, 0, 'CONFIRM', _closeWindow);
                _confirm.setSize(280, 160);
                new PushButton(_confirm, 30, 100, 'CANCEL', _onConfirmCancel);
                new PushButton(_confirm, 150, 100, 'OK', _closeWindow);
                new Label(_confirm, 40, 60, 'CLOSING THIS DIALOG...');
            }
        }
    }
    
    private function _onConfirmCancel(e:MouseEvent):void
    {
        removeChild(_confirm);
    }
    
    private function _closeWindow(e:MouseEvent):void
    {
        BetweenAS3.serial(
            BetweenAS3.to(this, {alpha:0}, 0.6),
            BetweenAS3.removeFromParent(this),
            BetweenAS3.func(
                _onFadeOutComplete
            )
        ).play();
    }
}

class MyRanking extends BasicScoreRecordViewer {
    private var _defaultColor:uint;
    public function MyRanking($parent:DisplayObjectContainer = null, $xpos:Number = 0, $ypos:Number = 0, $limit:int = 20, $descend:Boolean = true) {
        alpha = 0;
        super($parent, $xpos, $ypos, 'LAP TIME RANKING', $limit, $descend, _onCloseClick);
    }
    
    private function _onCloseClick():void
    {
        BetweenAS3.serial(
            BetweenAS3.to(this, { alpha:0 }, 0.6),
            BetweenAS3.removeFromParent(this)
        ).play();
    }
    
    override protected function onComplete($data:Array):void 
    {
        alpha = 0;
        // scaling & adding units to the score
        // note : this does not affect the actual value
        // registered in the database. The score is treated
        // as integer in the database.
        $data
        .forEach(
            function ($item:Object, $index:int, $array:Array):void {
                $item.score = ($item.score / 1000) + ' [sec]';
            }
        );
        
        super.onComplete($data);
        _list.defaultColor = _defaultColor;
        BetweenAS3.to(this, { alpha:1 }, 0.9).play();
    }
    
    public function get defaultColor():uint { return _defaultColor; }
    //
    public function set defaultColor(value:uint):void 
    {
        _defaultColor = value;
        if (_list) _list.defaultColor = value;
    }
}