/**
 * Copyright whirlpower ( http://wonderfl.net/user/whirlpower )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/b3iB
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.utils.Timer;
	
        // 簡単な２Dパーティクルを作ってみる。
        // パーティクルは難しいイメージがありますが、シンプルに書くと意外とわかりやすい。
        [SWF(width = "300", height = "300", frameRate = "30", backgroundColor = "#ffffff")]
	public class ParticleField extends Sprite
	{
		private var emitter	:Emitter;    // パーティクルの発生源
		private var timer	:Timer;      // パーティクルの発生するタイミングを設定する
		
                // ここから始まります。
		public function ParticleField():void
		{
			// エミッターの作成
			emitter	= new Emitter();            // 発生源を作成します。
			emitter.x = stage.stageWidth / 2;   // ステージの中心に配置します。
			emitter.y = stage.stageHeight / 2;  // ステージの中心に配置します。
			addChild( emitter );                // 発生源を画面に表示できるようにします。
			
			// particleの発生タイミングを設定
			timer = new Timer( 100 );	// ミリ秒単位でイベントを発生させる。
			timer.start();                  // タイマーのカウントを開始します。
			timer.addEventListener( TimerEvent.TIMER, generateParticle );    //　タイマーのカウントが指定のカウントになったら、functionを実行します。
			
			addEventListener( Event.ENTER_FRAME, onEnterFrame ); // エンターフレームでフレームを再生します。
		}
		
		// パーティクルを発生させます。
		private function generateParticle( evt:TimerEvent )
		{
                        // 発生源からパーティクルを１つ生成します。
                        // 引数に、パーティクルが進む方向（ベクトル）を、XとYで指定します。
                        // 今回は、ランダムな方向を指定します。
			emitter.generate(Math.random()*4-2, Math.random()*4-2);
		}
		
		// エンターフレーム　繰り返しの動作をします。
		private function onEnterFrame(e:Event):void
		{
			emitter.nextFrame();  // パーティクルを１フレーム進めます。
		}
	}
}

import flash.display.Sprite;
import flash.events.Event;

// エミッターのオブジェクトです。
// パーティクルを発生させる発生源です。
internal class Emitter extends Sprite
{
	public var particles:Array = [];	// この発生源に所属するパーティクル
	public var life		:int   = 60;	// パーティクルの寿命（フレーム）です。
	public var color	:uint  = 0xDD2200; // パーティクルの色を設定しています。
	
	// Particleの発生源を作成する。
	public function Emitter():void
	{
	}
	
	// パーティクル位置の計算
	public function generate( vx:Number, vy:Number ):void
	{
		// パーティクルの生成
		var vecror2D:Vector2D = new Vector2D( vx, vy ); // ベクトルデータを作成します。
		var particle:Particle = new Particle( color, life, vecror2D );  // パーティクルを作成します。　色と、寿命と、ベクトルを設定します。
		addChild( particle );  // パーティクルを画面に表示できるようにします。
		particles.push( particle );  // パーティクルをメンバーとして保持します。
	}
	
	// パーティクルを次のフレームへ進めます。
	public function nextFrame():void
	{
		var length:int = particles.length;  // パーティクルのメンバーの数を調べます。
		for ( var i:int = 0; i < length; ++i ){ // パーティクルのメンバーの数だけ、繰り返します。
			var life:Boolean = particles[i].nextFrame();  // particleのフレームを一つ進める
			if ( !life ) {                                // lifeがなくなったparticleはメンバーから削除する
				removeChild( particles[i] );          // パーティクルを画面に表示しなくします。 　
				particles.splice( i, 1 );             // 配列のiから数えて１つのメンバーを抜き取る
				--i;			        	// 消した分１つ前にもどる。
				--length;				// 消した分ループの回数を１回減らす。
			}
		}
	}
}

import flash.display.Shape;

// パーティクルのオブジェクトです。
// パーティクルの見た目、寿命、ベクトル（進む方向）の情報をもっています。
// パーティクル一粒ずつそれぞれに固有の情報をもっています。
internal class Particle extends Shape
{
	public var vec			:Vector2D;  // パーティクルのベクトルデータです。
	public var life			:int = 0;   // パーティクルの寿命です。
	
        // パーティクルオブジェクトを作成します。
        // 引数で、色、寿命、ベクトルを設定します。
	public function Particle( color:uint, life:int, _vec:Vector2D = null ):void
	{
		vec = _vec? _vec:new Vector2D();  // 引数で、ベクトルが指定されていれば、それを使います。なければ、新しくベクターデータを作成します。
		this.life = life; // 引数の寿命をこのオブジェクトの寿命に設定します。
		
		graphics.beginFill( color, 1 );  // パーティクルの見た目を作ります。 
		graphics.drawCircle( 0, 0, 5 );  // 
		graphics.endFill();              // 
	}
	
        // パーティクルを次の状態へ進めます。
	public function nextFrame():Boolean
	{
		life --; // 寿命を減らします。
		if ( life <= 0 ) return false; // 寿命がなくなったら、処理を中止して寿命がなくなったことを知らせます。
		x += vec.vx; // ベクトルを現在の座標に繁栄させます。
		y += vec.vy; // ベクトルを現在の座標に繁栄させます。
		
		return true;  // パーティクルが生きていることを知らせます。
	}
}

// ベクトルをあらわすオブジェクトです。
internal class Vector2D
{
	public var vx:Number;   // x方向のベクトルです。
	public var vy:Number;   // y方向のベクトルです。
	
        // ベクトルデータを作成します。
	public function Vector2D( vx:Number = 0.0, vy:Number = 0.0 )
	{
		this.vx = vx;
		this.vy = vy;
	}
}




