/**
 * Copyright matthewpeterson.net ( http://wonderfl.net/user/matthewpeterson.net )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/b3Zr
 */

// forked from hacker_aft9cz2z's forked from: DotEditor
// forked from hacker_aft9cz2z's DotEditor
//参考 http://ma1.s203.xrea.com/wordpress/archives/23

package 
{
    import flash.utils.ByteArray;
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
     import com.adobe.images.JPGEncoder;
    import com.adobe.images.PNGEncoder;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    
    import flash.text.TextField;
    public class DotEditor extends Sprite 
    {
        public function DotEditor() 
        {
            // write as3 code here..
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
            
            //this.createTextField("my_txt", this.getNextHighestDepth(), 0, 0, 60, 20);
            my_txt = new TextField();
            my_txt.x=360;
            my_txt.y=20;
            my_txt.width=60;
            my_txt.height=20;
            this.addChild(my_txt);
            my_txt.maxChars=8;
            my_txt.border=true;
            my_txt.type="input";
            my_txt.text = "0x000000";
            
            for(var i:int=0; i<pix_x; i++)
            {
                for(var n:int=0; n<pix_y; n++)
                {
                    this.graphics.lineStyle(1,0xEEEEEE);
                    this.graphics.moveTo(0+pix_sizes*i, 0+pix_sizes*n);
                    this.graphics.lineTo(pix_sizes*(i+1), 0+pix_sizes*n);
                    this.graphics.lineTo(pix_sizes*(i+1), pix_sizes*(n+1));
                    this.graphics.lineTo(0+pix_sizes*i, pix_sizes*(n+1));
                    this.graphics.lineTo(0+pix_sizes*i, 0+pix_sizes*n);
                }
            }
        }
        
        /**
        * プロパティ
        */
        private var pix_sizes:int = 20;//12;
        private var pix_x:int = 16;
        private var pix_y:int = 16;
            
        private var point_x:Number = 0;
        private var point_y:Number = 0;
            
        private var lastx:Number;
        private var lasty:Number;
        private var lastColor:Number;
        private var my_txt:TextField;
        
        private var previousHistory:Array;
        private var newCellHistory:Array;
        private var allPixels:Array = new Array();
        
        
        /**
        * メソッド
        */
        private function mouseDownHandler(e:MouseEvent):void
        {
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
            hoge(true);
        }
        
        
        private function mouseUpHandler(e:MouseEvent):void
        {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
        }
        
        
        private function mouseMoveHandler(e:MouseEvent):void
        {
            hoge();
            e.updateAfterEvent();
        }
        
        
        private function hoge(firstDown:Boolean=false):void
        {
            var x:int = ((mouseX - mouseX % pix_sizes) - point_x)/pix_sizes;
            var y:int = ((mouseY - mouseY % pix_sizes) - point_y)/pix_sizes;
            dotWrite(x,y,firstDown);
        }
        
        
        private function doAutomata():void
        {
            pushCurrentImageIntoHistory();
            showNewCells();
        }
        
        private function colorAllCells( newColor:Number=0 ):void
        {
            for(var x:* in allPixels)
            {
                var column:Array = allPixels[x];
                if(column != null)
                {
                    for(var y:* in column)
                    {
                        if(column[y] != null && column[y] != newColor)
                        {
                            savePixel(x,y,newColor);
                        }
                    }
                }
            }
        }

        
        private function showNewCells():void
        {
            colorAllCells();
            var newCells:Array = getNewCells();
            for each(var newCell:Array in newCells)
            {
                savePixel(newCell[0],newCell[1],0xFF0000);
            }
            
            if(newCellHistory.length > 1)
            {
                
            }

        }

        
        
        // Returns an array of x,y values that form the difference between the passed in index and the previous image in the history
        private function getNewCells( historyIndex:int = -1 ):Array
        {
            if(historyIndex < 0)
                historyIndex += previousHistory.length;
                
            var oldImage:Array = previousHistory[historyIndex - 1] || [];
            var newImage:Array = previousHistory[historyIndex];
            
            var changedCells:Array = new Array();
            
            for(var x:* in newImage)
            {
                var column:Array = newImage[x];
                if(column != null)
                {
                    for(var y:* in column)
                    {
                        if(column[y] != null)
                        {
                            if(oldImage[x] == null || oldImage[x][y] == null)
                            {
                                changedCells.push([x,y]);
                            }
                        }
                    }
                }
            }
            
            

            return changedCells;
        }

        
        private function pushCurrentImageIntoHistory():void
        {
            if(previousHistory == null) previousHistory = new Array();
            var ba:ByteArray = new ByteArray();
            ba.writeObject(allPixels);
            ba.position = 0;
            previousHistory.push(ba.readObject());
            newCellHistory = getNewCells();
        }


        
        private function dotWrite(x:int=10, y:int=10, firstDown:Boolean=false):void
        {
            trace(x,":",y)
            
            
            
            if(x == lastx && y == lasty)
            {
                if(firstDown == false) return;
            }
            else
            {
                lastx = x;
                lasty = y;
            }
            
            if(
                x < 0 ||
                y < 0 ||
                x >= pix_x ||
                y >= pix_y
            )
            {
                if(firstDown)
                {
                    doAutomata();
                }

                return;
            }
            
            
            if(allPixels[x] == null)
                allPixels[x] = new Array();
                
            
            
            if(firstDown)
            {
                var color:Number = Number(my_txt.text);
                if(allPixels[x][y] == color)
                    lastColor = 0xFFFFFF;
                else
                    lastColor = color;
            }
            
            savePixel(x,y,lastColor);
        }
        
        private function savePixel( x:int, y:int, color:Number ):void
        {
            if(allPixels[x] == null)
                allPixels[x] = new Array();
                
            if(color == 0xFFFFFF)
                allPixels[x][y] = null;
            else
                allPixels[x][y] = color;
                
            
            x = point_x + pix_sizes*x;
            y = point_y + pix_sizes*y;
            
            this.graphics.beginFill(color);
            this.graphics.lineStyle(1,0xEEEEEE)
            //this.graphics.beginFill(0x000000);
            this.graphics.moveTo(0+x, 0+y);
            this.graphics.lineTo(pix_sizes+x, 0+y);
            this.graphics.lineTo(pix_sizes+x, pix_sizes+y);
            this.graphics.lineTo(0+x, pix_sizes+y);
            this.graphics.lineTo(0+x, 0+y);
            this.graphics.endFill();
        }
    }
    
}

class AutomataRule
{
    public var moves:Array = [];
}

