/**
 * Copyright 0xABCDEF ( http://wonderfl.net/user/0xABCDEF )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/b3Y6
 */

package {
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.utils.ByteArray;
    import com.bit101.components.*;
    public class BrainFuckParser extends Sprite {
        
        private var helloWonderfl:String = "++++++++[>+>++>+++>++++>+++++>++++++>+++++++>++++++++>+++++++++>++++++++++>+++++++++++>++++++++++++>+++++++++++++>++++++++++++++>+++++++++++++++>++++++++++++++++<<<<<<<<<<<<<<<<-]>>>>>>>>>.>>>>---.+++>----.++++----.++++-.+<<<<<<<<----.++++<<.>>>>>>>-.+>>>-.+--.++<----.++++---.+++>++.--<--.++>----.++++<<<<<<<<<<+.-<<<<.";
        private var codeField:TextField;
        private var resultField:TextField;
        private var parseButton:PushButton;
        
        public function BrainFuckParser()
        {
            codeField = addChild( new TextField ) as TextField;
            codeField.x = 5;
            codeField.width = stage.stageWidth-10;
            codeField.height = stage.stageHeight/2-10;
            codeField.wordWrap = true;
            codeField.border = true;
            codeField.borderColor = 0;
            codeField.type = "input";
            resultField = addChild( new TextField ) as TextField;
            resultField.x = 5;
            resultField.y = codeField.height+30;
            resultField.width = stage.stageWidth-10;
            resultField.height = stage.stageHeight/2-25;
            resultField.selectable = false;
            resultField.wordWrap = true;
            resultField.border = true;
            resultField.borderColor = 0;
            parseButton = new PushButton( this, 185, codeField.height+5, "parse", doParse );
            codeField.text = helloWonderfl;
        }
        
        private function doParse( e:MouseEvent ):void
        {
            resultField.text = parse( codeField.text );
        }

        private function parse( code:String, ...arg ):String
        {
            var i:int;
            var currChar:String;
            var headBracketList:Array = [];
            var tailBracketList:Array = [];
            var array:ByteArray = new ByteArray;
            var pointer:int = 0;
            var argPos:int = 0;
            var result:String = "";
            for( i=0; i<code.length; ++i )
            {
                currChar = code.charAt( i );
                if( currChar == "[" ) headBracketList.push( i );
                if( currChar == "]" ) tailBracketList.unshift( i );
            }
            i=0;
             while( i != code.length )
            {
                switch( code.charAt( i ) )
                {
                    case ">" : ++pointer; break;
                    case "<" : --pointer; break;
                    case "+" : ++array[ pointer ]; break;
                    case "-" : --array[ pointer ]; break;
                    case "." : result += String.fromCharCode( array[ pointer ] ); break;
                    case "," : array[ pointer ] = String( arg[ argPos++ ] ).charCodeAt(); break;
                    case "[" :
                        if( !array[ pointer ] ) i = tailBracketList[ headBracketList.indexOf( i ) ];
                        break;
                    case "]" :
                        i = headBracketList[ tailBracketList.indexOf( i ) ]-1;
                        break;
                    default : break;
                }
                ++i;
            }
            return result;
        }
    }
}