/**
 * Copyright imajuk ( http://wonderfl.net/user/imajuk )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/b2zd
 */

// forked from ll_koba_ll's Threadの割り込みがうまくいかないことがある
// stageを連打してるとClickThreadのinterruptedが実行されないことがたまにある
// 一回目のクリックから3秒後にMainThreadからClickThreadにinterruptしてる

//クリック連打をシミュレートすると再現しました。
//やっぱり1フレーム中に複数回eventが発生すると起こる問題みたいですね。

package
{
	import flash.display.*;

	import org.libspark.thread.Thread;
	import org.libspark.thread.EnterFrameThreadExecutor;

	public class Click extends Sprite
	{
		public function Click()
		{
			Thread.initialize(new EnterFrameThreadExecutor());
			new MainThread(new AutoClicker()).start();
		}
	}
}

import flash.events.TimerEvent;
import flash.utils.Timer;
import flash.events.EventDispatcher;
import flash.events.IEventDispatcher;

class AutoClicker extends EventDispatcher implements IEventDispatcher
{
	private var timer:Timer;

	public function AutoClicker() 
	{
		timer = new Timer(10);
		timer.addEventListener(TimerEvent.TIMER, function():void
		{
			dispatchEvent(new MouseEvent(MouseEvent.CLICK));
		});
		timer.start();
	}
}

import flash.events.MouseEvent;

import org.libspark.thread.Thread;

class MainThread extends Thread
{
	private var _clickThread:ClickThread;
	private var autoClicker:AutoClicker;

	public function MainThread(autoClicker:AutoClicker)
	{
		this.autoClicker = autoClicker;
	}

	protected override function run():void
	{
		event(autoClicker, MouseEvent.CLICK, hoge);   
	}

	private function hoge(e:MouseEvent):void
	{
		sleep(3000);
		next(exit);
		_clickThread = new ClickThread(autoClicker);
		_clickThread.start();
	}

	private function exit():void
	{
		_clickThread.interrupt();
		trace("MainThread exit"); 
	}
}

class ClickThread extends Thread
{
	private var _target:AutoClicker;

	public function ClickThread(target:AutoClicker)
	{
		_target = target;
	}

	protected override function run():void
	{
		event(_target, MouseEvent.CLICK, click);
		interrupted(exit);
	}

	private function click(e:MouseEvent):void
	{
		trace("click");
		run();
	}

	private function exit():void
	{
		trace("exit!!!!!");
	}
}