/**
 * Copyright wh0 ( http://wonderfl.net/user/wh0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/b2ub
 */

package {
    import flash.geom.Point;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private var d:BitmapData;
        private var g:BitmapData;
        private var seed:int;
        
        public function FlashTest() {
            d = new BitmapData(465, 1, false, 0x000000);
            g = new BitmapData(465, 256, false, 0xffffff);
            seed = new Date().getTime();
            addChild(new Bitmap(g));
            stage.addEventListener(MouseEvent.MOUSE_MOVE, pan);
        }
        
        private function pan(e:MouseEvent):void {
            g.lock();
            var offsets:Array = [new Point(-e.stageX, 0), new Point(e.stageY, 0)];
            d.perlinNoise(128, 1, 2, seed, false, true, 7, false, offsets);
            g.fillRect(g.rect, 0xffffff);
            g.fillRect(new Rectangle(0, 127, 465, 1), 0x808080);
            for (var j:int = 0; j < 465; j += 128) {
                g.fillRect(new Rectangle(j, 0, 1, 256), 0xc0c0c0);
            }
            for (var i:int = 0; i < 465; i++) {
                var c:uint = d.getPixel(i, 0);
                g.setPixel(i, 255 - (c & 0xff), 0x0000ff);
                g.setPixel(i, 255 - (c >> 8 & 0xff), 0x00ff00);
                g.setPixel(i, 255 - (c >> 16 & 0xff), 0xff0000);
            }
            g.unlock();
        }
        
    }
}