/**
 * Copyright aaaaaz025 ( http://wonderfl.net/user/aaaaaz025 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/b1rA
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.ColorTransform;

 
    public class Main extends Sprite
    {
        private var bullets:Array;
        private var frame:int = 0;
 
        public function Main()
        {
            graphics.beginFill(0x00000);　//0ｘカラーコード(背景色)
            graphics.drawRect(0, 0, 465, 465);　//背景の幅
            graphics.endFill();
 
            bullets = new Array();
 
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
 
        private function onEnterFrame(event:Event):void
        {
            if (frame++ % 1 == 0)
            {
                var radian:Number = Math.random()*360;
                var bullet:Bullet = new Bullet(0x0, 5, 232, 232, Math.cos(radian), Math.sin(radian), 5);
                addChild(bullet);
                bullets.push(bullet);
            }
            
 
            for (var i:int = 0; i < bullets.length; i++)
            {
                bullets[i].move();
                if (bullets[i].check())
                {
                    removeChild(bullets[i]);
                    bullets.splice(i--, 1);
                }
            }
        }
    }
}
 
import flash.display.Graphics;
import flash.display.Sprite;
import flash.filters.GlowFilter;
import flash.geom.Point;
import flash.filters.DropShadowFilter;
 
class Bullet extends Sprite
{
    public var px:Number;
    public var py:Number;
    public var vx:Number;
    public var vy:Number;
    public var speed:Number;
 
    public function Bullet(color:int, radius:int, x:int, y:int, vx:Number, vy:Number, speed:Number)
    {
        Shape.createPolygon(this.graphics, 4 + Math.random() * 6, 0, 0, 20, true);
 
        this.filters = [new GlowFilter(int.MAX_VALUE * Math.random())];
 
        this.x = this.px = x;
        this.y = this.py = y;
        this.vx = vx;
        this.vy = vy;
        this.speed = speed;
    }
 
    public function move():void
    {    
        this.px += vx * speed;
        this.py += vy * speed;
 
        this.x = px;
        this.y = py;
    }
 
    public function check():Boolean
    {
        if (x < -50 || stage.stageWidth  + 50 < x ||
            y < -50 || stage.stageHeight + 50 < y)
        {
            return true;
        }
 
        return false;
    }
}
 
class Shape
{
    public static function createPolygon(graphics:Graphics, vertex:int, x:int, y:int, size:int, star:Boolean = false):void
    {
        if (vertex < 3) vertex = 3;
 
        var points:Array = new Array();
        for (var degree:Number = 0; degree < 360; degree += 360 / vertex)
        {
            var tx:Number = x + Math.cos(degree * Math.PI / 180) * size;
            var ty:Number = y + Math.sin(degree * Math.PI / 180) * size;
            points.push(new Point(tx, ty));
 
            if (star)
            {
                tx = x + Math.cos((degree + 360 / vertex / 2) * Math.PI / 180) * (size / 2);
                ty = y + Math.sin((degree + 360 / vertex / 2) * Math.PI / 180) * (size / 2);
                points.push(new Point(tx, ty));
            }
        }
 
        graphics.lineStyle(2.0, 0x0);
        graphics.moveTo(points[0].x, points[0].y);
        for (var i:int = 1; i < points.length; i++)
        {
            graphics.lineTo(points[i].x, points[i].y);
        }
        graphics.lineTo(points[0].x, points[0].y);
    }
}
