/**
 * Copyright yprops ( http://wonderfl.net/user/yprops )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/b1Mf
 */

// forked from yprops's TechHUB:Flash1:02:頻出クラス
package {
    import flash.display.*;
    import flash.text.*;
    public class FlashTest extends Sprite {
        
        
        //定数-----------------
        private const KAIGYOU :String = "\n";    //￥ｎ
        
        
        //変数-----------------
        private var myText :TextField;
        
        
        //コンストラクタ----------
        public function FlashTest() {
            //※ ローカル変数について：各メソッド内でのみ使える変数　メソッドが終われば消える。
            // var [変数名] :[クラス名];
            // var [変数名] :[クラス名] = [内容];
            var i :int;
            var sp :Sprite;
            
            //文字出力を準備してみる
            initOutput();
            
            //Sprite をひとつ作ってみる
            sp = createNewSprite(300, 100, 50);
            addChild(sp);
            
            //文字出力してみる。
            outputText(sp.toString());    //文字出力。文字しか指定できない
            output(sp.toString());        //文字出力。どんなオブジェクトでもＯＫ
            
            //Spriteを規則的に並べてみる
            for(i = 0; i < 10; i++){
                sp = createNewSprite(
                    i * 20 + 100,
                    200,
                    i * 5
                );
                addChild(sp);
            }
            //Spriteをランダムに並べてみる
            for(i = 0; i < 10; i++){
                addChild(
                    createNewSprite(
                        Math.random() * 100 + 100,
                        Math.random() * 100 + 300,
                        Math.random() * 10 + 10
                    )
                );
            }
        }
        
        
        
        //メソッド------------------
        /*
        (private or public) function [メソッド名]( [パラメータ] :[パラメータクラス名], ... ) :[戻り値クラス名]{
            [処理内容]
            return [戻り値]
        }
        */
        
        //適当なSpriteを作るメソッド
        private function createNewSprite(pointX :Number, pointY :Number, hankei :Number) :Sprite{
            var sp :Sprite = new Sprite();
            sp.x = pointX;
            sp.y = pointY;
            var gra :Graphics = sp.graphics;
            gra.beginFill(0x000000, 0.5);
            gra.drawCircle(0,0,hankei);
            return sp;
        }
        
        
        //文字出力準備メソッド
        private function initOutput() :void{
            myText = new TextField();
            myText.x = 20;
            myText.y = 20;
            myText.width = 200;
            myText.height = 300;
            myText.text = "TechHUB Flash" + KAIGYOU;
            //myText.autoSize = TextFieldAutoSize.LEFT;
            myText.multiline = true;
            myText.background = true;
            myText.border = true;
            //myText.rotation = 20;    //デバイスフォント(特にフォントデータを指定しないテキスト)は角度を変えると表示されない。
            addChild(myText);
        }
        //文字出力追加メソッド
        private function outputText(text :String) :void{
            myText.appendText(text + KAIGYOU);
        }
        //文字出力追加メソッド。どんなオブジェクトでもＯＫ
        private function output(obj :Object) :void{
            myText.appendText(obj.toString() + KAIGYOU);
            
        }
        
        
        
    }
}