/**
 * Copyright mex_takagi ( http://wonderfl.net/user/mex_takagi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/b1Cb
 */

// forked from mex's 【AS100本ノック】9回目：雪
/* 
 * AS100本ノック
 * 9回目のお題は「雪」
 * あなたなりの「雪」を表現してください。
 * 
 * 新雪でお遊び。
 * 画面をドラッグしてね。
 * 重い！注意！！
 */
package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BitmapDataChannel;
	import flash.display.Loader;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.display.GradientType;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.filters.DisplacementMapFilter;
	import flash.filters.BevelFilter;
	import flash.geom.Point;
	import flash.net.*;
	import flash.system.LoaderContext;
	import flash.text.TextField;
	/**
	 * @author Mao Takagi
	 */
	public class Main extends Sprite
	{
		private static const REQUEST_IMAGE:String = "http://farm4.static.flickr.com/3072/3014784247_1c2d91d230.jpg";
		private var _loader:Loader;
		private var _mask:Bitmap;
		private var _maskCanvas:BitmapData;
		private var _maskSprite:Sprite;
		private var _snowBmd:BitmapData;
		private var _canvasBmd:BitmapData;
		private var _canvas:Bitmap;
		private var _displacementmapfilter:DisplacementMapFilter;
		private var _bevelfilter:BevelFilter;
		private var _message:TextField;
		/**
		 * constructor
		 */
		[SWF(width = 465, height = 465, backgroundColor = 0xFFFFFF, frameRate = 60)]
		public function Main()
		{
			//マスク作成
			_maskCanvas = new BitmapData(465, 465, true, 0x00000000);
			_mask = new Bitmap(_maskCanvas);
			_maskSprite = new Sprite();
			_maskSprite.filters = [new BlurFilter(10, 10, 1)];
			
			//雪の下に隠れてる画像
			_snowBmd = new BitmapData(465, 465);
			
			_canvasBmd = new BitmapData(465, 465);
			_canvas = new Bitmap(_canvasBmd);
			addChild(_canvas);
			
			_displacementmapfilter = new DisplacementMapFilter(_maskCanvas, new Point(0, 0), 4, 1, 6, 6, "ignore");
			_bevelfilter = new BevelFilter(4, 45, 0x000000, 1, 0xFFFFFF, 1, 2, 2);
			
			_message = new TextField();
			_message.selectable = false;
			_message.autoSize = "left";
			_message.text = "Loading Image";
			_message.x = (stage.stageWidth - _message.width) / 2;
			_message.y = (stage.stageHeight - _message.height) / 2;
			addChild(_message);
			
			var request:URLRequest = new URLRequest(REQUEST_IMAGE);
			var context:LoaderContext = new LoaderContext(true);
			_loader = new Loader();
			_loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
			try
			{
				_loader.load(request, context);
			}
			catch (error:Error)
			{
				trace("image load failed.");
			}
		}
		/**
		 * onComplete
		 * @param event Event
		 */
		private function onComplete(event:Event):void
		{
			_message.text = "画面をドラッグしてね。";
			_message.x = (stage.stageWidth - _message.width) / 2;
			_message.y = (stage.stageHeight - _message.height) / 2;
			
			_snowBmd.draw(_loader);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, downHandler);
			stage.addEventListener(MouseEvent.MOUSE_UP, upHandler);
		}
		/**
		 * donwHandler
		 * @param event MouseEvent
		 */
		private function downHandler(event:MouseEvent):void 
		{ 
			if (contains(_message)) removeChild(_message);
			stage.addEventListener(MouseEvent.MOUSE_MOVE, drawBump); 
		}
		/**
		 * upHandler
		 * @param event MouseEvent
		 */
		private function upHandler(event:MouseEvent):void { stage.removeEventListener(MouseEvent.MOUSE_MOVE, drawBump); }
		/**
		 * drawBump
		 * @param event MouseEvent
		 */
		private function drawBump(event:MouseEvent):void
		{
			_maskSprite.addChild(brush(stage.mouseX, stage.mouseY));
			_maskCanvas.fillRect(_maskCanvas.rect, 0x000000);
			_maskCanvas.lock();
			_maskCanvas.draw(_maskSprite);
			_maskCanvas.unlock();
			
			_canvas.mask = _mask;
			_canvasBmd.lock();
			_canvasBmd.draw(_snowBmd);
			_canvasBmd.copyChannel(_maskCanvas, _maskCanvas.rect, new Point(0, 0), BitmapDataChannel.ALPHA, BitmapDataChannel.ALPHA);
			_canvasBmd.unlock();
			
			_displacementmapfilter = new DisplacementMapFilter(_maskCanvas, new Point(0, 0), 4, 1, 6, 6, "ignore");
			_canvas.filters = [];
			_canvas.filters = [_displacementmapfilter, _bevelfilter];
		}
		/**
		 * brush
		 * @param posX int
		 * @param posY int
		 */
		private function brush(posX:int, posY:int):Shape 
		{
			var shape:Shape = new Shape();
			shape.graphics.beginGradientFill(GradientType.RADIAL, [0xFFFFFF, 0x000000], [1, 1], [0, 15]);
			shape.graphics.drawCircle(0, 0, 4);
			shape.graphics.endFill();
			shape.x = posX;
			shape.y = posY;
			return shape;
		}
	}
}