/**
 * Copyright GreekFellows ( http://wonderfl.net/user/GreekFellows )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/b0ls
 */

package {
    import flash.display.Bitmap;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    
    public class Main extends Sprite {
        private var array:Array;
        private var all:Array;
        private var pushedindex:Array;
        private var done:Array;
        
        private var sbd:BitmapData;
        private var sb:Bitmap;
        private var ss:Sprite;
        
        private const UNIT:int = 1;
        
        public function Main() {
            text();
            
            var bitmapData:BitmapData = new BitmapData(465, 465);
            bitmapData.draw(this);
            this.removeChildAt(0);
            
            this.sbd= new BitmapData(465, 465);
            this.sb = new Bitmap(sbd);
            this.ss = new Sprite();
            this.addChild(sb);
            
            this.array = [];
            this.all = [];
            this.pushedindex = [];
            this.done = [];
            
            for (var ver:int = 0; ver < bitmapData.height / this.UNIT; ver += this.UNIT) {
                for (var hor:int = 0; hor < bitmapData.width / this.UNIT; hor += this.UNIT) {
                    if (bitmapData.getPixel(hor, ver) != 0xffffff) {
                        this.all.push({
                            gx:hor,
                            gy:ver,
                            x:465 / 2,
                            y:465 / 2,
                            ax:(hor - 465 / 2) / 820,
                            ay:(ver - 465 / 2) / 820,
                            divide:40,
                            color:bitmapData.getPixel(hor, ver)
                        });
                        this.pushedindex.push(this.pushedindex.length);
                    }
                }
            }
            
            this.addEventListener(Event.ENTER_FRAME, spinfade);
        }
        
        private function spinfade(e:Event):void {
            if (this.array.length < 10000) {
                var ind:int = this.pushedindex[Math.floor(Math.random() * this.pushedindex.length)];
                this.array.push(this.all[ind]);
                this.pushedindex.splice(ind, 1);
            }
            
            ss.graphics.clear();
            
            ss.graphics.beginFill(0xffffff, 1);
            ss.graphics.drawRect(0, 0, 465, 465);
            ss.graphics.endFill();
            
            for (var inde:int; inde < this.array.length; inde++) {
                ss.graphics.beginFill(this.array[inde].color, 1);
                ss.graphics.drawRect(this.array[inde].x, this.array[inde].y, this.UNIT, this.UNIT);
                ss.graphics.endFill();
                
                this.array[inde].x += this.array[inde].ax * this.array[inde].divide;
                this.array[inde].y += this.array[inde].ay * this.array[inde].divide;
                
                if (this.array[inde].divide <= 0) {
                    this.array[inde].x = this.array[inde].gx;
                    this.array[inde].y = this.array[inde].gy;
                    this.array[inde].ax = 0;
                    this.array[inde].ay = 0;
                    
                    this.done.push( {
                        x:this.array[inde].gx,
                        y:this.array[inde].gy,
                        color:this.array[inde].color
                    });
                    
                    this.array.splice(inde, 1);
                } else {
                    this.array[inde].divide--;
                }
            }
            
            for (var doni:int = 0; doni < this.done.length; doni++) {
                ss.graphics.beginFill(this.done[doni].color, 1);
                ss.graphics.drawRect(this.done[doni].x, this.done[doni].y, this.UNIT, this.UNIT);
                ss.graphics.endFill();
            }
            
            this.sbd.draw(ss);
        }

        
        private function text():TextField {
            var tf:TextField = new TextField();
            tf.text = "greekfellows";
            
            var fm:TextFormat = new TextFormat();
            fm.font = "Segoe UI Light";
            fm.size = 72;
            fm.align = "center";
            
            tf.setTextFormat(fm);
            
            tf.width = tf.textWidth;
            tf.height = tf.textHeight + 5;
            tf.x = 465 / 2 - tf.textWidth / 2;
            tf.y = 465 / 2 - tf.textHeight / 2;
            
            this.addChild(tf);
            
            return tf;
        }

    }
}