/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/b0V9
 */

// forked from tepe's ローカルファイルのロード
package {
    import flash.display.Shape;
    import flash.events.SecurityErrorEvent;
    import flash.net.*;
    import flash.text.*;
    import flash.events.*;
    import flash.display.Sprite;
    import flash.system.System;
    public class FlashTest extends Sprite {
        

        private var text1:TextField = new TextField();
        //private var txt2:TextField = new TextField();
        private var txt2:TextEditer = new TextEditer();
        
        private var file:FileReference = new FileReference();
        private var base:Sprite = new Sprite();
        private var playBtn:IconBtn;
        
        public function FlashTest() {
            System.useCodePage = false;//UNICODE以外のテキストファイルをロードする場合 true

            addChild(base);

            file.addEventListener(Event.COMPLETE,onLoaded2);
            file.addEventListener(Event.SELECT,onSelect);
            
            txt2.width =400;
            txt2.height =400;
            txt2.border = true;
            txt2.type = "input";
            
           stage.tabChildren = false;//タブフォーカス無効

            
            base.addChild(txt2);
           // addChild(txt3);
            
            //ボタン設定
            playBtn = new IconBtn(PlayIcon);
            addChild(playBtn);
            playBtn.x = 95;
            playBtn.y = 380;
            playBtn.init({width: 40});
            playBtn.addEventListener(MouseEvent.CLICK, onClick);
            addChild(playBtn);
            var btn2:IconBtn = new IconBtn(PlayIcon);
            addChild(btn2);
            btn2.x = 180;
            btn2.y = 380;
            btn2.init({width:40});
            btn2.addEventListener(MouseEvent.CLICK,onClick2);
            
            
        }
        
        private function onClick2(e:MouseEvent):void{
            txt2.text = func1(txt2.text);
        }



        
        //改行コードの統一 (CR+LF or CR) → LF
        private function unifyLineFeedCode(str:String):String {
            var CR:String = String.fromCharCode(13);
            var LF:String = String.fromCharCode(10);
            str = str.split(CR+LF).join(LF);
            str = str.split(CR).join(LF);
            return str;
        }



        
        //ファイル選択　①
        private function onClick(e:MouseEvent):void{
            file.browse();  
            //file1.load();
            //txt2.text = file1.data
            //file1.save(txt2.text);
        }
        
        //ロード開始　②
        private function onSelect(e:Event):void{
            file.load();
        }
        
        private function onLoaded2(e:Event):void{
            //txt2.text = String(file.data);
            txt2.text = unifyLineFeedCode(file.data.toString());//改行コード統一
            txt2.text = func1(txt2.text);
     
        }
        //スコープ単位で分割
        private function func1( str:String ):String{
            var len:int = str.length;
            var i:int,j:int,k:int;
            var str2:String = new String();
            for(i=0;i<len;i++){
                switch(str.charAt(i)){
                    case "/"://コメントアウト
                    if(str.charAt(i+1) == "/"){
                         j = str.indexOf("\r",i);
                         k = j-i;
                         if(j<0)return str2;
                         str2+="//"+str.substring(i+2,j)+" "+String(i)+" → ";
                         i=j;
                         str2+=String(i)+"("+String(k)+")\n";
                    }
                     
                    else if(str.charAt(i+1) == "*"){
                         
                         j = str.indexOf("*/",i);
                         k = j-i;
                         if(j<0)return str2;
                         str2+="/*"+str.substring(i+2,j)+"*/ "+String(i)+" → ";
                         i=j+1;
                         str2+=String(i)+"("+String(k)+")\n";
                    }


                    break;
                    
                    case "\"":
                    j = str.indexOf("\"",i+1);
                    if(j<0)return str2;
                    str2+="\""+str.substring(i+1,j)+"\"\n"; 
                    i=j+1;
                    break;
                    
                    case "\'":
                    j = str.indexOf("\'",i+1);
                    if(j<0)return str2;
                    str2+="\'"+str.substring(i+1,j)+"\'\n"; 
                    i=j+1;
                    break;
                    
                    default:
                    j = str.charCodeAt(i);
                    var cnt1:int;
                    if(0x61 < j && j < 0x7a){
                        cnt1++;
                        
                    }
                   


                    
                }
                

            }
            return str2;

        }


    }
}


    import flash.text.*;
    import flash.ui.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.System;
    class TextEditer extends TextField {
        private var file:FileReference;
        private var prevText:Object;
        private var nextText:Object;
        
        public function TextEditer():void {
            this.type = "input";//入力可能
            //this.tabEnabled = true;
            this.selectable = false;
            this.addEventListener(KeyboardEvent.KEY_DOWN, onKey); 
            addEventListener(MouseEvent.CLICK, onFocus);
            
            
            //コンテキストメニュー@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@            
            var menu1:ContextMenuItem = new ContextMenuItem("ファイルを開く");
            menu1.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, function():void {
                //txt.appendText("menu");
                load();
            });
            var menu2:ContextMenuItem = new ContextMenuItem("ファイルを保存");
            menu2.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, function():void {
                save();
            });

            contextMenu = new ContextMenu();
            contextMenu.hideBuiltInItems();
            contextMenu.customItems = [menu1,menu2];
            //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
  
        }
        
        //改行コードの統一 (CR+LF or CR) → LF
        private function unifyLineFeedCode(str:String):String {
            var CR:String = String.fromCharCode(13);
            var LF:String = String.fromCharCode(10);
            str = str.split(CR+LF).join(LF);
            str = str.split(CR).join(LF);
            return str;
        }
        
        //セーブ
        public function save():void {
            var fileRef:FileReference = new FileReference();
            fileRef.save(this.text, this.name);
        }
        
        //ファイルロード
        public function load():void {//ファイル選択　①
            file = new FileReference();
            file.addEventListener(Event.COMPLETE, onLoaded);
            file.addEventListener(Event.SELECT, onSelect);
            file.browse();
        }
        private function onSelect(e:Event):void{//ロード開始　②
            file.load();
        }   
        private function onLoaded(e:Event):void {//ロード完了　③
            this.name = file.name;   
            var byte:int = file.data.length;
            var byte2:uint;
            
            //txt.text = String(file.data);
            this.text = unifyLineFeedCode(file.data.toString());//改行コード統一
            file.removeEventListener(Event.COMPLETE, onLoaded);
            file.removeEventListener(Event.SELECT, onSelect);      
        }

        
        //編集モード終了
        private function outFocus(e:FocusEvent):void {
            this.selectable = false;
            removeEventListener(FocusEvent.FOCUS_OUT, outFocus);
            removeEventListener(MouseEvent.MOUSE_DOWN, dragCansel);
            addEventListener(MouseEvent.MOUSE_DOWN, onFocus);
            //this.appendText(" Out ");
        }
        
        //編集モード開始
        private function onFocus(e:MouseEvent):void {
            this.selectable = true;
            addEventListener(FocusEvent.FOCUS_OUT, outFocus);
            removeEventListener(MouseEvent.MOUSE_DOWN, onFocus);
            addEventListener(MouseEvent.MOUSE_DOWN, dragCansel);
            //this.appendText(" In ");
            //e.stopPropagation();
        }
        
        private function dragCansel(e:MouseEvent):void {
            e.stopPropagation();
        }
        
        //キー入力
        private function onKey(e:KeyboardEvent):void {
            var sw:Boolean;
            var str1:String;
            var str2:String;
            
            
            //　エンターキーの状態
            if (e.keyCode == 13) sw = true;
            else if (e.keyCode == 108) sw = true;
            else sw = false;
            
            //キャレット位置に改行文字を挿入
            if(sw == true){
                str1 = this.text.substring(0, this.caretIndex);
                str2 = this.text.substring(this.caretIndex, this.length);
                this.text = str1;
                this.appendText("\n");//キャレット位置で改行
                
                //インデント構造（タブ＆スペースの構成）を調べる
                var indent:int=0;
                var prevReturn:int = this.text.lastIndexOf('\r', this.caretIndex-1);//前回の改行位置
                //一つ前の改行直後に続くタブコードの数=インデント深度
                for (var j:int = prevReturn+1; j < this.caretIndex; j++) {
                    if (this.text.charAt(j) == '\t' || this.text.charAt(j) == ' ' ) indent++;
                    else break;
                }
                //上の行のインデントに従う
                var indentStr:String = this.text.slice(prevReturn + 1, prevReturn + 1 + indent);
                this.appendText(indentStr);//インデント
                this.text += str2;//結合
                
                //キャレット位置をインクリメント
                this.setSelection(this.caretIndex +indent + 1, this.caretIndex +indent + 1);
                return;
            }
            //tab
            if (e.keyCode == 9) {
                str1 = this.text.substring(0, this.caretIndex);
                str2 = this.text.substring(this.caretIndex, this.length);
                this.text = str1 + '\t' + str2;
                //キャレット位置をインクリメント
                this.setSelection(this.caretIndex + 1, this.caretIndex + 1);                
                return;
            }
            

        }

    }
///--------------------------------------------------------------------------------------------------------



//////////////////////////////////////////////////
// IconBtnクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;
import flash.geom.ColorTransform;

class IconBtn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var icon:Shape;
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    private static var upColorTrans:ColorTransform;
    private static var overColorTrans:ColorTransform;
    private static var offColorTrans:ColorTransform;
    private var cColor:uint = 0x0099FF;
    private var colorGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;

    public function IconBtn(Icon:Class) {
        icon = new Icon();
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        if (option.color != undefined) cColor = option.color;
        draw();
    }
    private function draw():void {
        switch (type) {
        case 1 :
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        colorGlow = new GlowFilter(cColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        upColorTrans = new ColorTransform();
        upColorTrans.color = upColor;
        overColorTrans = new ColorTransform();
        overColorTrans.color = overColor;
        offColorTrans = new ColorTransform();
        offColorTrans.color = offColor;
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(icon);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, cColor);
        light.filters = [colorGlow];
        createBase(base, _width, _height, corner, bColor);
        icon.y = -1;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        icon.y = -1;
        icon.transform.colorTransform = upColorTrans;
        base.y = -1;
        light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        icon.y = -1;
        icon.transform.colorTransform = overColorTrans;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        icon.y = 0;
        icon.transform.colorTransform = overColorTrans;
        base.y = 0;
        light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        icon.y = 0;
        icon.transform.colorTransform = offColorTrans;
        base.y = 0;
        light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        if (_clicked) {
            _down();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
        } else {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}


//////////////////////////////////////////////////
// Iconクラス
//////////////////////////////////////////////////

import flash.display.Shape;
//import sketchbook.graphics.GraphicsHelper;

class PlayIcon extends Shape {
    private static var bColor:uint = 0x000000;

    public function PlayIcon() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(bColor);
        graphics.moveTo(-4, -6);
        graphics.lineTo(-4, 6);
        graphics.lineTo(8, 0);
        graphics.endFill();
    }

}

class PauseIcon extends Shape {
    private static var bColor:uint = 0x000000;

    public function PauseIcon() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(bColor);
        graphics.drawRect(-5, -5, 4, 10);
        graphics.endFill();
        graphics.beginFill(bColor);
        graphics.drawRect(3, -5, 4, 10);
        graphics.endFill();
    }

}

class StopIcon extends Shape {
    private static var bColor:uint = 0x000000;

    public function StopIcon() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(bColor);
        graphics.drawRect(-5, -5, 10, 10);
        graphics.endFill();
    }

}


//////////////////////////////////////////////////
// CompoEventクラス
//////////////////////////////////////////////////

import flash.events.Event;

class CompoEvent extends Event {
    public static const SELECT:String = "select";
    public static const CHANGE:String = "change";
    public var value:*;

    public function CompoEvent(type:String, value:*) {
        super(type);
        this.value = value;
    }

    public override function clone():Event {
        return new CompoEvent(type, value);
    }

}
