/**
 * Copyright kanatara ( http://wonderfl.net/user/kanatara )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/azUK
 */

// forked from ongaeshi's [wonderfl本] 練習問題2、チョロQ
// forked from 9re's 車が動くアニメーション
package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    [SWF(frameRate="60", width="800", height="800")]
    
    public class AnimationExample extends Sprite
    {
        private var _car:Car;
        private var _mator:GasMator;
        private var _ground:Ground;
        
        public function AnimationExample() 
        {
            // 地形
            _ground = new Ground();
            addChild(_ground);

            // 車のクラスのインスタンスを作る
            // 色は赤にする
            _car = new Car(0xd00000);
            addChild(_car);

            // 画面中央に配置
            _car.x = 200;
            _car.y = 350;

            // メーターの作成
            _mator = new GasMator(_car);
            _mator.y = 700;
            addChild(_mator);
        }
    }
}

import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.events.Event;

class Car extends Sprite {
    // ガソリンの量最初は入っていない = 0
    private var _gas:int = 0;

    // ドラッグ関連
    private var _isDrag:Boolean = false;
    private var _maxX:Number = 0;

    // 移動or停止
    private var _stop:Boolean = false;
    
    // コンストラクタ
    // 製造時に車の色は決まる
    public function Car(_fillColor:uint) {
        // 描画
        _draw(_fillColor);

        // ドラッグ設定
        setupDrag();

        // 1フレーム毎に実行する処理にmoveCarを追加する
        addEventListener(Event.ENTER_FRAME, update);
    }

    private function setupDrag():void {
        // マウスオーバーレイ時に手のアイコンに変える
        buttonMode = true;

        // ドラッグ設定
        addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
        addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
    }

    // ドラッグ開始
    private function onMouseDown(e:MouseEvent):void {
        // 移動停止
        _stop = true;

        // 計測位置設定
        _maxX = x;

        // ドラッグ開始
        _isDrag = true;
        e.currentTarget.startDrag();
    }

    // マウス移動
    private function onMouseMove(e:MouseEvent):void {
        if (_isDrag) {
            // 計測位置更新
            if (x > _maxX)
                _maxX = x;

            // ガソリン注入
            putGas(_maxX - x);
        }
    }

    // ドラッグ終了
    private function onMouseUp(e:MouseEvent):void {
        // ガソリン注入
        putGas(_maxX - x);

        // ドラッグ解除
        _isDrag = false;
        e.currentTarget.stopDrag();

        // 移動可能に
        _stop = false;
    }

    // 更新
    private function update(e:Event):void {
        if (!_stop)
            move();
    }
    
    // 車を動かす
    private function move():void {
        // 移動
        if (_gas > 10) {        // ガスの残量が10より大きい場合
            x += 5;             // x座標を5だけ増やす
        } else {                // ガスの量が10以下の場合
            x += _gas / 2;      // 残りのガスの量によって動きが変わる
        }
        
        _gas--;                 // 車が動くとガスは減る
        if (_gas < 0) {         // もしガスの量が0より小さいなら
            _gas = 0;           // ガスの量を0にセットする
        }                       // ガスの量はマイナスにはならない

        // 端までいってしまったら死亡
        var maxX:int = stage.stageWidth - 55;
        if (x > maxX) {
          x = 200;
          y = 350;
          putGas(0);
        }
    }

    public function putGas(gas:int):void {
        _gas = Math.max(gas, 0);
    }
    
    public function get gas():int {
        return _gas;
    }
    
    // 描画メソッド。privateなので外からは見えない
    // 車の形や色は製造される時に決まってしまうので外部からは
    // 呼べない
    private function _draw(_fillColor:uint):void
    {
        // 車輪を書く
        graphics.beginFill(0x333333);
        graphics.drawCircle(10, 20, 5);
        graphics.drawCircle(45, 20, 5);
        graphics.endFill();
        // 車体を書く
        graphics.beginFill(_fillColor);
        graphics.moveTo(0, 10);
        graphics.lineTo(15, 0);
        graphics.lineTo(30, 0);
        graphics.lineTo(40, 10);
        graphics.lineTo(50, 10);
        graphics.lineTo(55, 15);
        graphics.lineTo(55, 20);
        graphics.lineTo(0, 20);
        graphics.endFill();
    }
}

class GasMator extends Sprite {
    private var _car:Car;
    private var _tf:TextField;

    public function GasMator(car:Car) {
        // 車への参照
        _car = car;
        
        // テキスト
        _tf = new TextField();
        _tf.autoSize = TextFieldAutoSize.LEFT;
        addChild(_tf);

        // 背景
        _tf.background = true;
        _tf.backgroundColor = 0x000000;
        _tf.alpha = 0.5;

        // 文字
        var f:TextFormat = new TextFormat();
        f.color = 0xffffff;
        f.size = 30;
        _tf.defaultTextFormat = f;

        // 表示するテキスト
        _tf.text = "Power";

        // プロセス
        addEventListener(Event.ENTER_FRAME, update);
    }

    private function update(e:Event):void {
        graphics.clear();
        graphics.beginFill(0xFF7637, 1);
        graphics.drawRect(_tf.width, 0, _car.gas, _tf.height);
        graphics.endFill();
    }
}

class Ground extends Sprite {
    public function Ground() {
        graphics.beginFill(0xFFDD54);
        graphics.drawRect(450, 0, 150, 700);
        graphics.endFill();
        addText(500, 350, "50", 0x000000);
        
        graphics.beginFill(0xA4FF55);
        graphics.drawRect(600, 0, 125, 700);
        graphics.endFill();
        addText(625, 350, "100", 0x000000);

        graphics.beginFill(0xFF7A52);
        graphics.drawRect(725, 0, 100, 700);
        graphics.endFill();
        addText(725, 350, "200", 0x000000);
    }

    public function addText(x:int, y:int, text:String, color:Object):void {
        var tf:TextField = new TextField();
        tf.autoSize = TextFieldAutoSize.LEFT;

        var f:TextFormat = new TextFormat();
        f.color = color;
        f.size = 50;
        tf.defaultTextFormat = f;
        
        tf.x = x;
        tf.y = y;
        tf.text = text;
        
        addChild(tf);
    }
}