/**
 * Copyright jmbyh521 ( http://wonderfl.net/user/jmbyh521 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/azF8
 */

// forked from uwi's HAPPY NEW YEAR
package {
    import flash.display.*;
    import flash.text.*;
    import flash.geom.*;
    import flash.events.*;
    import net.wonderfl.utils.*;
    import org.libspark.betweenas3.*;
    import org.libspark.betweenas3.tweens.*;
    import org.libspark.betweenas3.easing.*;

    public class Test extends Sprite {
        private var _tf : TextField;
        private var _bmd : BitmapData;
        private var _W : Number;
        private var _H : Number;
        private var _tx : TextField;

        public function Test() {
            _tf = new TextField();
            _tf.autoSize = "left";
            
            _W = stage.stageWidth;
            _H = stage.stageHeight;
            
            _tx = new TextField();
            _tx.height = 465;
            addChild(_tx);
            
            var fl : FontLoader = new FontLoader();
            fl.load("Cinecaption");
            fl.addEventListener(Event.COMPLETE, function(e:Event) : void {
                removeChild(_tx);
                _tf.defaultTextFormat = new TextFormat("Cinecaption", 100);
                _tf.background = true;
                _tf.backgroundColor = 0;
                _tf.textColor = 0xffffff;
                _tf.appendText("HAPPY\nNEW\nYEAR\n2011!");
                _tf.embedFonts = true;
                
                _hist = new Vector.<uint>();
                
                _bmd = new BitmapData(_W, _H, false, 0);
                var mat : Matrix = new Matrix();
                mat.createBox(1, 1, -0.1, _W/2 - _tf.width/2, _H/2 - _tf.height/2);
                _bmd.draw(_tf, mat);
                
                for(var i : uint = 0;i < 100;i++){
                    var w : uint = Math.random() * _W / 2;
                    var h : uint = Math.random() * 100 + 20;
                    var y : uint = Math.random() * (_H - h);
                    rotateW(_bmd, y, w, h);
                    _hist.push(y, _W - w, h);
                }
                
                var nh : uint = _hist.pop();
                var nw : uint = _hist.pop();
                var ny : uint = _hist.pop();
                makeTween(_bmd, ny, nw, nh);
                
                var bmp : Bitmap = new Bitmap(_bmd);
                addChild(bmp);
            });
            
            fl.addEventListener(ProgressEvent.PROGRESS, function(e:ProgressEvent) : void
            {
                _tx.text = "" + e.bytesLoaded + "/" + e.bytesTotal;
            });

        }
        
        private var _hist : Vector.<uint>;
        
        public function makeTween(bmd : BitmapData, y : uint, w : uint, h : uint) : void
        {
            var temp : BitmapData = new BitmapData(bmd.width, h, false, 0);
            temp.lock();
            var o : Object = {t:0.0};
            var it : ITween = BetweenAS3.to(o, {t:w}, 0.1, Cubic.easeInOut);
            it.onPlay = function() : void
            {
                temp.copyPixels(bmd, new Rectangle(0, y, bmd.width, h), new Point(0, 0));
            };
            it.onUpdate = function() : void
            {
                var t : uint = o.t;
                if(t > 0){
                    bmd.lock();
                    bmd.copyPixels(temp, new Rectangle(0, 0, bmd.width-t, h), new Point(t, y));
                    bmd.copyPixels(temp, new Rectangle(bmd.width-t, 0, t, h), new Point(0, y));
                    bmd.unlock();
                }
            };
            it.onComplete = function() : void
            {
                temp.dispose();
                if(_hist.length > 0){
                    var nh : uint = _hist.pop();
                    var nw : uint = _hist.pop();
                    var ny : uint = _hist.pop();
                }
                makeTween(bmd, ny, nw, nh);
            };
            it.play();
        }
        
        public function rotateW(bmd : BitmapData, y : uint, w : uint, h : uint) : void
        {
            var temp : BitmapData = new BitmapData(bmd.width, h, false, 0);
            temp.copyPixels(bmd, new Rectangle(0, y, bmd.width, h), new Point(0, 0));
            bmd.copyPixels(temp, new Rectangle(0, 0, bmd.width-w, h), new Point(w, y));
            bmd.copyPixels(temp, new Rectangle(bmd.width-w, 0, w, h), new Point(0, y));
            temp.dispose();
        }

        private function tr(...o : Array) : void
        {
            _tx.appendText(o + "\n");
        }
    }
}