/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aywG
 */

// forked from gameegg's Lightning Star
// forked from gameegg's Lightning 1
package {
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.ColorMatrixFilter;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    
    public class LightningStar extends Sprite {
        
        private var _bitd:BitmapData;
        private var _bit:Bitmap;
        private var _flash:Shape;
        private var _ground:Shape;
        private var _board:Sprite;
        private var _cmf:ColorMatrixFilter = new ColorMatrixFilter([0.95,0,0,0,0,
                                                                    0,0.97,0,0,0,
                                                                    0,0,1,0,0,
                                                                    0,0,0,1,0]);
        private var _cmf2:ColorMatrixFilter = new ColorMatrixFilter([0.9,0,0,0,0,
                                                                    0,0.9,0,0,0,
                                                                    0,0,1,0,0,
                                                                    0,0,0,1,0]);
        private var _bf:BlurFilter = new BlurFilter(16,16,2);
        private var _ctf:ColorTransform = new ColorTransform(1,1,1,0.95);
        private var _startPoint:Point = new Point(250,200);
        private var _r:Number = 0;
        private var star_r:Number = 0;
        private var t:Number = 0;
        
        private var O:Point = new Point(218,218);
        private var mO:Point = new Point(218,218);
        private var star_bool:Boolean = true;
        private var array:Array = [new Point(218,218),new Point(218,218),new Point(218,218),new Point(218,218),new Point(218,218)];
                
        public function LightningStar() {
            graphics.beginFill(0x000000);
            graphics.drawRect(0,0,465,465);
            //x = 465/2;
            //y = 45
            _bitd = new BitmapData(465,465,false,0x000000);
            _bit = new Bitmap(_bitd);
            _ground = new Shape();
            _flash = new Shape();
            _board = new Sprite();
            _flash.graphics.beginFill(0xffffff);
            _flash.graphics.drawRect(0,0,465,465);
            _flash.alpha = 0;
            
            _bit.x = -465/2;
            _bit.y = -465/2;
            
            _board.addChild(_bit);
            _board.x = 465/2;
            _board.y = 465/2;
            
            addChild(_board);
            
            
            addChild(_flash);
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
            stage.addEventListener(Event.ENTER_FRAME, enterFrame);
            
        }
        
        
        private function mouseDown(e:MouseEvent):void {
            mO.x=mouseX;
            mO.y=mouseY;
            t = 10000;
            _flash.alpha = 1;
            
            if(Math.random()*2>1 && array.length>3){
                array.pop();
            }
            else{
                array.push(new Point(0,0));
            }
            if(array.length%2 == 1) star_bool = true;
            else star_bool = false;

        }
        
        private function pit(PointA:Point, PointB:Point):Number{
            return Math.sqrt((PointA.x - PointB.x)*(PointA.x - PointB.x) + (PointA.y - PointB.y)*(PointA.y - PointB.y));
        }

        
        private function drawLines(sx:Number,sy:Number,ex:Number,ey:Number,mainRoot:Boolean):void{
            var _currentPoint:Point = new Point(sx,sy);
            var _endPoint:Point = new Point(ex,ey);
            var distance:Number = pit(_currentPoint,_endPoint);
            var random:Number;
            _ground.graphics.moveTo(sx,sy);
            
            while(distance > 2){
                _ground.graphics.lineStyle(distance/90+0.05,0xffffff);
                _r = Math.atan2(_endPoint.y - _currentPoint.y, _endPoint.x - _currentPoint.x) + Math.random()*2 - 1;
                random = Math.random()
                _currentPoint.x += Math.cos(_r)*random;
                _currentPoint.y += Math.sin(_r)*random;
                
                _ground.graphics.lineTo(_currentPoint.x,_currentPoint.y);
                distance = pit(_currentPoint,_endPoint);
                if(Math.random()>0.99){

                    var _rofchild:Number = _r + Math.random() - 0.5;
                    drawLines(_currentPoint.x,_currentPoint.y,
                    _currentPoint.x + Math.cos(_rofchild)*Math.random()*20,_currentPoint.y + Math.sin(_rofchild)*Math.random()*20,false);

                }
                _ground.graphics.moveTo(_currentPoint.x,_currentPoint.y)

            }
            if(mainRoot){
                //_startPoint.x = _endPoint.x;
                //_startPoint.y = _endPoint.y;
                _bitd.draw(_ground);
                _bitd.applyFilter(_bitd,_bitd.rect,new Point(0,0),_bf);
                _bitd.applyFilter(_bitd,_bitd.rect,new Point(0,0),_cmf2);
                //_flash.alpha = 1;
                _bitd.draw(_ground);
                _ground.graphics.clear();
            }
        }
        
        private function enterFrame(e:Event):void{
            if(_flash.alpha < 1.6)_bitd.applyFilter(_bitd,_bitd.rect,new Point(0,0),_cmf);
            if(_flash.alpha < 1.6)_bitd.colorTransform(_bitd.rect,_ctf);
            _flash.alpha -= _flash.alpha/4;
            _board.x += (mO.x-_board.x)/10;
            _board.y += (mO.y-_board.y)/10;
            t++
            if(t>2){
                if(star_bool){
                    for(var i:int = 0; i < array.length; ++i){
                        array[i].x = O.x+Math.cos(2*Math.PI/array.length*i)*150;
                        array[i].y = O.y-Math.sin(2*Math.PI/array.length*i)*150;
                        
                        
                    }
                    for(var ii:int = 0; ii < array.length; ++ii){
                        var j:int = ii+2;
                        if(j > array.length - 1) j -= array.length;
                        
                        if(ii+1 != array.length) drawLines(array[ii].x,array[ii].y,array[j].x,array[j].y,false);
                        else drawLines(array[ii].x,array[ii].y,array[j].x,array[j].y,true);
                    }
                }
                else{
                    for(var k:int = 0; k < array.length; ++k){
                        array[k].x = O.x+Math.cos(2*Math.PI/array.length*k)*150;
                        array[k].y = O.y-Math.sin(2*Math.PI/array.length*k)*150;
                        if(k+1 != array.length) drawLines(O.x,O.y,array[k].x,array[k].y,false);
                        else drawLines(O.x,O.y,array[k].x,array[k].y,true);
                    }
                }
            t=0
            }
            
            _board.rotation += Math.PI/3;
            
            

        }

    }
}