/**
 * Copyright ussy9 ( http://wonderfl.net/user/ussy9 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ayuJ
 */

// forked from kotobuki's Arduino Test
// A simple example illustrates how to use Funnel with
// an Arduino board (via StandardFirmara)
// 
// Outputs:
// * a LED with a resistor to D13
// 
// Ref: Getting started with Funnel and Arduino
// http://funnel.cc/Main/GettingStarted

package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    import funnel.*;
    import funnel.gui.ArduinoGUI;
    import funnel.ui.*;

    public class ArduinoTest extends Sprite {
        private var aio:Arduino;
        private var scopes:Array;

        public function ArduinoTest() {
            var config:Configuration = Arduino.FIRMATA;
            config.setDigitalPinMode(13, OUT);

            aio = new Arduino(config);

            var gui:ArduinoGUI = new ArduinoGUI();
            addChild(gui);
            aio.gui = gui;

            var onBoardLED:LED = new LED(aio.digitalPin(13));
            onBoardLED.value=1.0;
        }
    }
}
