/**
 * Copyright akkey.guitar ( http://wonderfl.net/user/akkey.guitar )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aytZ
 */

// forked from hacker_szoe51ih's サウンド波形 extract
/*
*/

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.JointStyle;
    import flash.display.Sprite;
    import flash.events.*;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundTransform;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    import flash.text.TextField;
    import flash.external.*;
    
    
     [SWF(width=1050,height=180,backgroundColor=0x0,frameRate=45)]
    public class Main extends Sprite
    {
        
        public var pass:String = "http://www.oncekey.jp/test_page/flash_test/data/masquenadaakkey2.mp3";
        public var dummySound:Sound;
        public var sound1:Sound;
        public var soundCh:SoundChannel;
        public var mySoundTransform:SoundTransform;
        public var soundSp:Sprite;
        public var byteArray:ByteArray;
        
        public var onoff:Boolean = true;
        
        public var leftCol:uint=0xffffff;
        
        public var W:Number = stage.stageWidth;
        public var H:Number = stage.stageHeight;
        
        
        public function Main() {
            
                init();
            
            }
            
            public function init():void {
                dummySound = new Sound();
                //波形データを表示する用
                soundSp = new Sprite();
                soundSp.x = 0;
                soundSp.y = H / 2;
                addChild(soundSp);
                
                //soundを読み込む
                sound1 = new Sound();
                sound1.addEventListener(Event.COMPLETE, loadComplete);
                sound1.load(new URLRequest(pass));
            }
            
            public function loadComplete(e:Event):void {
                dummySound.addEventListener(SampleDataEvent.SAMPLE_DATA, writeSoundData);
                soundCh=dummySound.play();//サウンドデータを読み込んでいないsoundインスタンスでplay()を呼び出すと、SampleDataEvent.SAMPLE_DATAが送出される
                
                //テキストエリア作成
                //var result:TextField = new TextField();
                
                //返り値ありのJavascript関数を呼び出す
                //var volumeNum:Number = ExternalInterface.call("getVolume");
                
                //var volumeNum:Number = 1;
                
                //var str:String = String(volumeNum);
                
                //result.textColor = 0xFFFFFF;
                //result.x = 200;
                
                //esult.text = str;
                //result.width = 400;
                //addChild(result);       
                
                //音量変更用にSoundTransformを生成
                mySoundTransform = new SoundTransform();
                //音量を指定
                mySoundTransform.volume = 1;
                //SoundChannelに音量を指定したSoundTransformを設定
                soundCh.soundTransform = mySoundTransform;
                stage.addEventListener(MouseEvent.CLICK, onClick);
            }
            
            public function writeSoundData(e:SampleDataEvent):void {
                byteArray = new ByteArray();
                sound1.extract(byteArray, 3600);//sound1のサウンドデータを抽出してbyteArrayに書き込む
                createImage(byteArray);
                e.data.writeBytes(byteArray);//dummySoundのSampleDataEvent.SAMPLE_DATAにbyteArrayを1バイトを8bitの符号付き整数として書き込む    
            }
            
            public function createImage(byteArray:ByteArray):void {
                //波形の画像を作成
                byteArray.position = 0;
                
                //描画初期化
                soundSp.graphics.clear();
                soundSp.graphics.lineStyle(1,0xffffff);
                soundSp.graphics.moveTo(0, 0);
                
                //パラメーターセット
                var moveX:int = 0;
                var count:int = 1;
                var leftArray:Array = new Array();
                
                //byteArrayの長さだけ繰り返す
                while (byteArray.bytesAvailable > 0) {
                    
                    leftArray.push(byteArray.readFloat() * H / 2);//byteArrayから浮動小数値をreadFloatで取得してleftArrayに入れる
                    
                    //countを8で割った余りが0のときのみcreateLineを実行（1にすると重たくて動かなくなる）
                    if (count%6==0) {
                        createLine(moveX, leftArray);
                        moveX++;
                        leftArray = new Array();//新しいleftArrayインスタンスを作る
                        count=1;
                    }
                    count++;
                }
                
            }
            
            public function createLine(moveX:int, arr:Array):void {
                var moveY:Number=0;
                for (var i:int = 0; i < arr.length ;i++ ) {
                    moveY += arr[i];
                }
                moveY /= arr.length;//そのままだと波形の振り幅が大きすぎるので適当な値で割っている
                soundSp.transform.colorTransform = rgb();
                soundSp.graphics.lineTo(moveX, moveY);
        
            }
            
            //on off
            public function onClick(e:MouseEvent):void {
                if (onoff) {
                    soundCh.stop();
                    onoff = false;
                }else {
                    soundCh = dummySound.play();
                    onoff = true;
                }
            }
            
            public function rgb():ColorTransform {
                var cltf:ColorTransform = soundSp.transform.colorTransform;
                cltf.redMultiplier =(Math.random()*2)+0.01;
                cltf.greenMultiplier=(Math.random()*2)+0.01;
                cltf.blueMultiplier=(Math.random()*2)+0.01;
                soundSp.transform.colorTransform = cltf;
                return soundSp.transform.colorTransform;
            }
        
            
            
    }
    
    
}










