/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ayt4
 */

// forked from tepe's flash on 2011-3-19
package {
    import flash.events.*;
    import flash.display.*;
    import flash.text.*;
    import flash.net.*;
    import net.hires.debug.Stats;
    //[SWF(backgroundColor=0, width=465, height=465)]
    public class FlashTest extends Sprite {//==================================
        private var node1:node = new node();
        private var text1:TextField = new TextField();
        private var box:Tsumiki = new Tsumiki();
        private var sd:SimpleDrawing = new SimpleDrawing();
        //private var svg:airpen = new airpen();
        //private var twit:twit1 = new twit1();
        public function FlashTest() {//----------------------------------------
                        
            sd.y = 1000;
            sd.x = 10000;
            sd.alpha =0.5;
            
            //http://king-of-bb.jp/svg/
            box.x = 10000;
            node1.map.addChild(box);
            node1.map.addChild(sd);
            var d1:Draw3D = new Draw3D(Math.random()*0xffffff);
            node1.map.addChild(d1);
            //node1.map.addChild(svg);
            for(var i:int=0;i<100;i++){
                d1 = new Draw3D(Math.random()*0xffffff);
                d1.x=(Math.random()*1000)*200-(500*200);
                d1.y=(Math.random()*1000)*200-(500*200);
                
                node1.map.addChild(d1);
            }
　
　
　          /*
　          var aaa:Main1 = new Main1();
　          aaa.y = 5000;
　          node1.map.addChild(aaa);
            */
            var tf:TextField = new TextField();

            // TextFormat オブジェクトを作成する
            var format:TextFormat = new TextFormat();

            //format.align = TextFormatAlign.RIGHT;    // 整列
            //format.font = "impact";        // フォント名
            format.size = 30;        // 文字のポイントサイズ
            //format.color = 0x000000;    // 文字の色
            //format.bold = true;        // 太字にするか？
            //format.italic = true;        // 斜体にするか？
            //format.underline = true;    // アンダーラインを表示するか？
            //format.bullet = true;        // 箇条書きにするか？
            //format.kerning = true;    // カーニングが有効か？（埋め込みフォント時のみ動作）
            //format.blockIndent = 0;    // 全体のインデント(単位:ピクセル) 
            //format.indent = 0;        // 折り返し行以外のインデント
            //format.leading = -2;        // 行間の垂直の行送り
            //format.leftMargin = 5;    // 段落の左マージン(単位：ピクセル)
            //format.rightMargin = 5;    // 段落の右マージン(単位：ピクセル)
            //format.letterSpacing = 4;    // 文字間スペースの量(単位:ピクセル)
            //format.tabStops = [120];    // タブストップ
            //format.url = null;        // ハイパーリンク先を文字列で指定
            //format.target = null;        // ハイパーリンク先のターゲットウィンドウ
            tf.defaultTextFormat = format;//デフォルト書式設定
            
            tf.text = "test";
            tf.y = - 500;
            tf.border = true;
            tf.z=0;
            tf.type = "input";
            node1.map.addChild(tf);

            addChild(node1);
            text1.selectable = false;
            text1.height = 20;
            text1.width = 20;
            text1.textColor = 0xff00ff;
            //text1.border = true;
            addChild(text1);

            //チャット
            //var roomID:String = "test";
            //var minichat:MiniChat = new MiniChat(roomID);
            //minichat.x = (465 - minichat.width) / 2;
            //minichat.y = (465 - minichat.height) / 2;
            //addChild(minichat);
            
            
            var sList:Array = new Array();
            
            for(var i:int=0;i<10;i++){
                var s:Sprite = new Sprite();
                s.graphics.lineStyle(0x000000,1);
                s.graphics.beginFill(Math.random()*0xffffff);
                s.graphics.drawCircle(0,0,50);
                s.graphics.endFill();
                s.scaleX = s.scaleY = 0.1;
                s.x = Math.random()*500-500/2;
                
                if(sList.length==0){
                    node1.map.addChild(s);
                }
                else{
                    sList[sList.length-1].addChild(s);
                }
                sList.push(s);
            }

            //stage.showDefaultContextMenu=false;
            //stage.addEventListener(MouseEvent.CLICK,screenMode2);
            //stage.addEventListener(KeyboardEvent.KEY_DOWN,screenMode);
            addEventListener(Event.ENTER_FRAME,function():void{
                
                text1.text = String(node1.scaleSize);
            });
            
            var menu:ActionMenu = new ActionMenu();
                menu.x = -135 ;
                menu.y = 20;
                stage.addChild(menu);
                menu.init({id: 1, label: "Exit" , width: 60});
                menu.addEventListener(MouseEvent.CLICK, screenMode3);
                menu.alpha = 0.7;
                

            
            //FPS計測    
           // addChild( new Stats() );
           // Wonderfl.capture(stage);
            
            
                
        }
        


        
        private function screenMode3(e:MouseEvent):void{//-----------------------------
            if(stage.displayState != StageDisplayState.NORMAL)stage.displayState = StageDisplayState.NORMAL;
            e.stopPropagation();//イベントの伝播を止める  
        }
        
        private function screenMode2(e:MouseEvent):void{//-----------------------------
            if(stage.displayState == StageDisplayState.NORMAL)stage.displayState = StageDisplayState.FULL_SCREEN;
        }

        private function screenMode(e:KeyboardEvent):void{//-----------------------------      
            
            if(e.keyCode == 13){
                if(node1.IsBrowseMode == true)node1.browseOff();
                else node1.browseOn();
                
            }
            else if(e.keyCode == 66){
                node1.returnHome();
            }

            else if(e.keyCode == 71){
                node1.map.removeChild(box);
            }
            else if(e.keyCode == 72){
                node1.map.addChild(box);
            }
            /*else if(e.keyCode == 73){
                if(stage.displayState == StageDisplayState.FULL_SCREEN){
                    stage.displayState = StageDisplayState.NORMAL;//元に戻す               
                }
                else{
                    stage.displayState = StageDisplayState.FULL_SCREEN;//フルスクリーンモード        
                }
            }*/


            //e.stopPropagation();//イベントの伝播を止める            
        }
    }
}


//--------------------------------------------------------------------------------


    import Box2D.Collision.b2AABB;
    import Box2D.Collision.Shapes.b2PolygonDef;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.*;
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;

    class Tsumiki extends Sprite {//=================================================
        private var DRAW_SCALE:Number = 100;
        private var world:b2World;
        private var boxBegin:Point = new Point();
        private var rect:Sprite = new Sprite();
        
        private var s2:Sprite = new Sprite();
        
        public function Tsumiki():void {//-------------------------------------------
            var s:Sprite = new Sprite();
                s.graphics.beginFill(0x000000,1)
                s.graphics.drawRect(-5000,-5000,10000,10000);
                s.graphics.endFill();
            
            addChild(s);
            addChild(s2);
            ////////////////////////////////////////
            // 物理エンジンのセットアップ
            
            // 外枠を定義する
            var worldAABB:b2AABB = new b2AABB();
            worldAABB.lowerBound.Set(-100, -100);
            worldAABB.upperBound.Set(100, 100);
            
            // 重力を下方向に10m/s^2とする
            var gravity:b2Vec2 = new b2Vec2(0, 10);
            
            // 外枠と重力を指定して、物理エンジン全体をセットアップする
            world = new b2World(worldAABB, gravity, true);
            
            ////////////////////////////////////////
            // 床の設置
            // 床は画面の下のほうに設置します
            
            // 床の位置を左から2.5m、上から3mとする
            var floorBodyDef:b2BodyDef = new b2BodyDef();
            floorBodyDef.position.Set(2.5, 3);
            
            // 床の形を、幅4m、厚さ20cmとする
            // 指定するのはその半分の値
            var floorShapeDef:b2PolygonDef = new b2PolygonDef();
            floorShapeDef.SetAsBox(2, 0.1);
            
            // 床を動かない物体として作る
            var floor:b2Body = world.CreateBody(floorBodyDef);
            floor.CreateShape(floorShapeDef);
            
            ////////////////////////////////////////
            // 描画設定
            
            var debugDraw:b2DebugDraw = new b2DebugDraw();
            debugDraw.m_sprite = s2;//this;
            debugDraw.m_drawScale = DRAW_SCALE; // 1mを100ピクセルにする
            debugDraw.m_fillAlpha = 0.3; // 不透明度
            debugDraw.m_lineThickness = 1; // 線の太さ
            debugDraw.m_drawFlags = b2DebugDraw.e_shapeBit;
            world.SetDebugDraw(debugDraw);
            
            // イベントハンドラを登録する
            this.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);//矩形生成開始
            this.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);//矩形生成
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            //stage.addEventListener(MouseEvent.MOUSE_WHEEL,onWheel);//ズーム
            addChild(rect);
        }

        
        private function mouseDownHandler(event:MouseEvent):void {//-----------------------------
            // マウスが押された場所を記憶しておく
            boxBegin.x = mouseX;
            boxBegin.y = mouseY;
            stage.addEventListener(MouseEvent.MOUSE_MOVE,onMove);
            addChild(rect);
            
           
        }
        //矩形描画
        private function onMove(e:MouseEvent):void{//-----------------------------
            rect.graphics.clear();
            rect.graphics.lineStyle(1,0xffffff,0.5);
            rect.graphics.beginFill(0xffffff,0.2);
            rect.graphics.drawRect(boxBegin.x,boxBegin.y,mouseX-boxBegin.x,mouseY-boxBegin.y);
            rect.graphics.endFill();
        }

        //オブジェクト生成
        private function mouseUpHandler(event:MouseEvent):void {//-----------------------------
            rect.graphics.clear();
            removeChild(rect);
            
            stage.removeEventListener(MouseEvent.MOUSE_MOVE,onMove);
            // 箱の場所と大きさを計算する
            var x:Number = (mouseX + boxBegin.x ) / 2 / DRAW_SCALE ;
            var y:Number = (mouseY + boxBegin.y) / 2 / DRAW_SCALE ; 
            var halfWidth:Number = Math.abs(mouseX - boxBegin.x ) / 2 / DRAW_SCALE ;
            var halfHeight:Number = Math.abs(mouseY - boxBegin.y) / 2 / DRAW_SCALE ;
            
            // 小さすぎる箱ができるのを防ぐ
            if (halfWidth < 0.05 || halfHeight < 0.05) {
                return;
            }
            
            // 箱の場所を設定する
            var bodyDef:b2BodyDef = new b2BodyDef();
            bodyDef.position.Set(x, y);
            
            // 箱の大きさなどを設定する
            var shapeDef:b2PolygonDef= new b2PolygonDef();
            shapeDef.SetAsBox(halfWidth, halfHeight);
            shapeDef.density = 1;     // 密度 [kg/m^2]
            shapeDef.restitution = 0.1;  // 反発係数、通常は0～1
            shapeDef.friction = 1.5;
            
            // 箱を動く物体として作る
            var body:b2Body = world.CreateBody(bodyDef);
            body.CreateShape(shapeDef);//形状描画
            body.SetMassFromShapes();//動く
            
            
            var Image:Sprite = new Sprite();
            //Image.graphics.lineStyle(1,0x000000);
            Image.graphics.beginFill(0xffff00,0);            
            
            Image.graphics.drawRect(0, 0, Math.abs(mouseX - boxBegin.x), Math.abs(mouseY - boxBegin.y));
            Image.graphics.endFill();
            
            
            //Image.width = 0.3 * DRAW_SCALE;
            //Image.height = 0.3 * DRAW_SCALE;
            Image.x = -Image.width / 2;
            Image.y = -Image.height / 2;
            body.m_userData = new Sprite();
            body.GetUserData().x = body.GetWorldCenter().x * DRAW_SCALE;
            body.GetUserData().y = body.GetWorldCenter().y * DRAW_SCALE;
            body.GetUserData().addChild(Image);
            addChild(body.GetUserData());
            body.GetUserData().addEventListener(MouseEvent.MOUSE_OVER,function():void{
                var w:Number = Image.width-1;
                
                var h:Number = Image.height-1;
                Image.graphics.clear();
                //Image.graphics.lineStyle(1,0x000000);
                Image.graphics.beginFill(0x00ff00,0);            
            
                Image.graphics.drawRect(0, 0, w, h);
                Image.graphics.endFill();
            });

            
            
        }
        
        private function enterFrameHandler(event:Event):void {//-----------------------------
            
             // ワールド内の全てのb2Bodyに対する処理
            for (var b:b2Body = world.GetBodyList(); b; b = b.GetNext()) {
                if (b.GetUserData() is Sprite) {
                    // 物理エンジン内での位置と回転角度を反映させる
                    b.GetUserData().x = b.GetWorldCenter().x * DRAW_SCALE;
                    b.GetUserData().y = b.GetWorldCenter().y * DRAW_SCALE;
                    b.GetUserData().rotation = b.GetAngle() * 180 / Math.PI;
                    if(b.IsFrozen() == true){
                        world.DestroyBody(b);
                        removeChild(b.m_userData);
                    }

                }
                
            }
            
            // Flashはデフォルトで秒間24フレームなので、
            // 物理シミュレーションを1/24秒進める
            world.Step(1 / 24, 10);
        }
    }




//------------------------------------------------------------------------------

import flash.geom.Point;
import caurina.transitions.Tweener;
import flash.display.*;
import flash.text.*;
import flash.events.*;
import flash.ui.*;
import flash.utils.*;

class node extends Sprite{//======================================================
        
        private var scale:Number = 1;
        
        public var wheel:int;//ホイール回転量
        private var zoom:Number = 1.0;//拡大率
        public var map:Sprite;//フィールド
        
        private var mapFocusX:Number=0;
        private var mapFocusY:Number=0;
        private var scrFocusX:int=0; 
        private var scrFocusY:int=0; 
        
        private var scalingPanel:Sprite;
        private var base:Sprite;
              
        private var mapscale:int=0;
        
        private var dragPanel:Sprite = new Sprite();
        
        //ozmap状態フラグ
        private const testMode:Boolean = false;//テスト表示

        private var mapBrowseMode:Boolean;//マップ移動操作
        private var mapDragMode:Boolean;//マップドラッグ中はtrue
        private var mapRotationMode:Boolean;//マップ回転操作
        
        private var endZoomOut:int = 150; 
        private var endZoomIn:int = -70;
        
        //コンストラクタ 
        public function node():void{//-----------------------------
            
            //カーソル位置描画
            //scalingPanel ズーム中心
            scalingPanel = new Sprite();//ズーム中心
            if(testMode == true){ 
                var t1:TextField = new TextField();
                t1.textColor = 0x00ff00;
                t1.selectable = false;
                t1.y = -20;
                t1.text = "scalingPanel";
                scalingPanel.addChild(t1);
                scalingPanel.graphics.lineStyle(1,0x00ff00,0.3);
                scalingPanel.graphics.moveTo(-100,0);
                scalingPanel.graphics.lineTo(100,0);
                scalingPanel.graphics.moveTo(0,-100);
                scalingPanel.graphics.lineTo(0,100);
            }
            addChild(scalingPanel);
            
            
            //マップ基準座標
            base = new Sprite();
            if(testMode == true){
                var t2:TextField = new TextField();
                t2.textColor = 0xff0000;
                t2.selectable = false;
                t2.y = -20;
                t2.text = "base";
                base.addChild(t2);
                base.graphics.lineStyle(1,0xff0000,0.3);
                base.graphics.moveTo(-100,0);
                base.graphics.lineTo(100,0);
                base.graphics.moveTo(0,-100);
                base.graphics.lineTo(0,100);
            }            
            scalingPanel.addChild(base);
            
            //マップ上への配置
            map = new Sprite();
            
            if(testMode == true){
                var t3:TextField = new TextField();
                t3.textColor = 0x0000ff;
                t3.selectable = false;
                t3.y = -20;
                t3.text = "map 0,0";
                map.addChild(t3);
                map.graphics.lineStyle(1,0x0000ff,0.3);
                map.graphics.moveTo(-100,0);
                map.graphics.lineTo(100,0);
                map.graphics.moveTo(0,-100);
                map.graphics.lineTo(0,100);
            } 
            
            browseOn();
 
            base.addChildAt(map,0); 
            map.addChild(dragPanel);
            if(testMode == true){
 
                var t4:TextField = new TextField();
                t4.textColor = 0x0000ff;
                t4.selectable = false;
                t4.y = -40;
                t4.text = "dragPanel 0,0";
                dragPanel.addChild(t4);
            }

            
            dragPanel.doubleClickEnabled = true;
            
            
            
            update();
        }
        
        public function get scaleSize():int{//-----------------------------
            return mapscale;
        }
        
        //マップ移動操作状態
        public function get IsBrowseMode():Boolean{//-----------------------------
            return mapBrowseMode;
        }
        //マップドラッグスクロール状態
        public function get IsDragMode():Boolean{//-----------------------------
            return mapDragMode;
        }        
        //マップ回転操作状態
        public function get IsRotationMode():Boolean{//-----------------------------
            return mapRotationMode;
        }

        //
        public function returnHome():void{//-----------------------------
            map.x = 0;
            map.y = 0;
            map.scaleX = map.scaleY = 1.0;
            mapscale = 0;
            update();
            
        }

        
        
        //画面移動操作の受付　ON・OFF切り替え
        public function browseOn():void{//-----------------------------
            mapBrowseMode = true;
            //Mouse.hide();
            map.addEventListener(MouseEvent.MOUSE_DOWN,down1);
            map.addEventListener(MouseEvent.MOUSE_UP,up1);
            dragPanel.addEventListener(MouseEvent.DOUBLE_CLICK,onDouble);
            this.addEventListener(MouseEvent.MOUSE_WHEEL,on_wheel,true);//ホイール操作 
            map.addChild(dragPanel);
        }
        
        
        public function browseOff():void{//-----------------------------
            wheel = 0;
            mapBrowseMode = false;
            //Mouse.show();
            map.removeEventListener(MouseEvent.MOUSE_DOWN,down1);
            map.removeEventListener(MouseEvent.MOUSE_UP,up1);
            dragPanel.removeEventListener(MouseEvent.DOUBLE_CLICK,onDouble);
            this.removeEventListener(MouseEvent.MOUSE_WHEEL,on_wheel,true);//ホイール操作 
            map.removeChild(dragPanel);
        }
        
       

        
        //ダブルクリックでマップブラウズモード解除　⇒　オブジェクト操作モードに移行
        private function onDouble(e:MouseEvent):void{//-----------------------------
            browseOff();
            //ホイール操作でブラウズモードに移行
            stage.addEventListener(MouseEvent.MOUSE_WHEEL,function():void{
                browseOn();
            });
        }


  
        //マップドラッグ
        private function down1(e:MouseEvent):void{//-----------------------------
            wheel=0;//ズーム操作ストップ
            
      　    e.currentTarget.startDrag();
      　    addEventListener(MouseEvent.MOUSE_MOVE,onMove);
      　    stage.removeEventListener(Event.ENTER_FRAME,onFrame);
      　    e.stopPropagation();//イベントの伝播を止める
      　    
        }
        private function up1(event:MouseEvent):void{//-----------------------------
            event.currentTarget.stopDrag();
            removeEventListener(MouseEvent.MOUSE_MOVE,onMove);
            event.stopPropagation();//イベントの伝播を止める
        }
        
        //マップドラッグ中
        private function onMove(e:MouseEvent):void{//-----------------------------
            update();
        }
    
        //ホイール操作
        private function on_wheel(event:MouseEvent):void{//-----------------------------
            wheel += event.delta;
            if(wheel != 0)addEventListener(Event.ENTER_FRAME,onFrame);
            //else removeEventListener(Event.ENTER_FRAME,onFrame);
        }
  
        private function onFrame(e:Event):void {//-----------------------------
            if(wheel==0)removeEventListener(Event.ENTER_FRAME,onFrame);
            
            on_zoom(1+(0.005*wheel));
        }
        
        
        //マップ表示位置を更新
        private function update(z:Number=1, x:Number=0, y:Number=0, a:Number=0):void{//-----------------------------
            var mX:int,mY:int;
            if(1<=z){//ズームイン
                mX = mouseX;
                mY = mouseY;//カーソル位置    
            }
            else{//ズームアウト
                mX = this.root.loaderInfo.width/2;
                mY = this.root.loaderInfo.height/2;//カーソル位置
            }
            
            //ズーム中心
            scalingPanel.x = mX;
            scalingPanel.y = mY; 
            //マップ位置
            base.x -= (mX-scrFocusX)/zoom;
            base.y -= (mY-scrFocusY)/zoom;
            //フォーカス位置
            scrFocusX = mX;
            scrFocusY = mY;
            

            //フィールドドラッグ用
            dragPanel.graphics.clear();
            dragPanel.graphics.beginFill(0xffffff,0.3);
            dragPanel.graphics.drawCircle(-(map.x+map.parent.x)/map.scaleX,-(map.y+map.parent.y)/map.scaleY,600/map.scaleX);
            dragPanel.graphics.endFill();
            
            //if(testMode == true){
                var i:int;
                var c:uint = 0x00aa00;
                const j:int = 32;
                for(i= -20-(map.y/j);i<20-(map.y/j);i++){
                    if(Math.abs(i)%2 == 1)dragPanel.graphics.lineStyle(0,c,(zoom*0.5)-0.5);
                    else dragPanel.graphics.lineStyle(0,c,0.5);
                    dragPanel.graphics.moveTo((-600-map.x)/map.scaleX , i*j/map.scaleX);
                    dragPanel.graphics.lineTo((1600-map.x)/map.scaleX , i*j/map.scaleX);
                }
                for(i=-20-(map.x/j);i<20-(map.x/j);i++){
                    if(Math.abs(i)%2 == 1)dragPanel.graphics.lineStyle(0,c,(zoom*0.5)-0.5);
                    else dragPanel.graphics.lineStyle(0,c,0.5);
                    dragPanel.graphics.moveTo(i*j/map.scaleX, (-600-map.y)/map.scaleX);
                    dragPanel.graphics.lineTo(i*j/map.scaleX, (1600-map.y)/map.scaleX);
                }
            //}
      
        }

        
        
        private function on_zoom(z:Number=0):void{//-----------------------------
            if(z==0)return;
            update(z);//基準点更新
            if(z>1 && endZoomIn > mapscale){
                wheel = 0;
            }
            else if(z<1 && endZoomOut < mapscale){
                wheel = 0;
            }
            else zoom *= z;    
                
            if(2 < zoom){

                map.scaleX *= 2;
                map.scaleY *= 2;
                zoom /= 2;
                map.x += map.x+base.x;
                map.y += map.y+base.y;
                    
                mapscale--;
                
            }
            else if(zoom < 1.0){
             
                map.x -= (map.x+base.x)/2;
                map.y -= (map.y+base.y)/2;
                zoom *= 2;
                map.scaleX /= 2;
                map.scaleY /= 2;
                    
                mapscale++;
                    
            }    
            scalingPanel.scaleX = zoom;
            scalingPanel.scaleY = zoom;        
          
        }
        
    }
 
 
 
    
//------------------------------------------------------




// forked from naoto5959's お絵描きツール

    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    
class SimpleDrawing extends Sprite{//===================================
        private static const CANVAS_WIDTH:Number = 435;
        private static const CANVAS_HEIGHT:Number = 465;
        private static const RECOVERBLE:Number = 10;//リドゥ回数
        
        public function SimpleDrawing(){//-----------------------------
            var bitmapData:BitmapData = new BitmapData(2, 2, true, 0x33AB7C10);
            bitmapData.setPixel(0, 0, 0x33ffffff);
            var background:Sprite = new Sprite();
            //background.graphics.lineStyle(0,0x000000);
            background.graphics.beginFill(0xffffff);
            background.graphics.drawRect(0,0,CANVAS_WIDTH, CANVAS_HEIGHT);
            background.graphics.endFill();
            //background.graphics.beginBitmapFill(bitmapData);
            //background.graphics.drawRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
            
            var canvas:Canvas = new Canvas(CANVAS_WIDTH, CANVAS_HEIGHT, background, RECOVERBLE);
            canvas.attach("pen", new PenTool());
            canvas.change("pen");
            canvas.options = {thickness:2, color:0x000000};
            canvas.activate();

            addChild(canvas);

            var btn_recover:Sprite = new Sprite();
            btn_recover.graphics.beginFill(0xff0000);
            btn_recover.graphics.drawRect(0,0,30, 30);
            btn_recover.x = canvas.width;
            btn_recover.y = 0;
            btn_recover.addEventListener(MouseEvent.CLICK,
            function(event:MouseEvent):void
            {
                    canvas.recover();
            }
            );
            var txt_recover:TextField = new TextField();
            txt_recover.x = txt_recover.y = 0;
            txt_recover.autoSize = TextFieldAutoSize.LEFT;
            txt_recover.text = "戻す";
            txt_recover.mouseEnabled = false;
            btn_recover.addChild(txt_recover);
            addChild(btn_recover);

            var btn_recoverAll:Sprite = new Sprite();
            btn_recoverAll.graphics.beginFill(0x00ff00);
            //btn_recoverAll.graphics.drawRect(0,0,30, 30);
            btn_recoverAll.graphics.drawRoundRect(0,0,30,30,10)
            btn_recoverAll.x = canvas.width;
            btn_recoverAll.y = btn_recover.height;
            btn_recoverAll.addEventListener(MouseEvent.CLICK,
            function(event:MouseEvent):void
            {
                    canvas.recoverAll();
            }
            );
            var txt_recoverAll:TextField = new TextField();
            txt_recoverAll.x = txt_recoverAll.y = 0;
            txt_recoverAll.autoSize = TextFieldAutoSize.LEFT;
            txt_recoverAll.text = "消す";
            txt_recoverAll.mouseEnabled = false;
            btn_recoverAll.addChild(txt_recoverAll);

            addChild(btn_recoverAll);
        }
}    







import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.DisplayObject;
import flash.display.IBitmapDrawable;
import flash.display.Shape;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;

/**
 * drawing canvas
 * @author naoto koshikawa
 */
class Canvas extends Sprite{//=========================================
    private var _cache:Sprite;
    private var _mask:Shape;
    private var _background:Bitmap;
    private var _original:BitmapData;
    private var _history:Array;
    private var _length:int;
    private var _recoverableCount:uint;
    private var _width:Number;
    private var _height:Number;
    
    private var _currentTool:ITool;
    public function get currentTool():ITool//-----------------------------
    {
        return _currentTool;
    }
    
    private var _tools:Object;
    public function set options(options:Object):void//-----------------------------
    {
        if (_currentTool) _currentTool.options = options;
    }
    
    public function get recoverable():Boolean//-----------------------------
    {
        return (_length) ? true:false;
    }
    
    private var _recoverableAll:Boolean;//-----------------------------
    public function get recoverableAll():Boolean
    {
        return _recoverableAll;
    }
    
    public function Canvas(w:Number, h:Number, background:IBitmapDrawable, recoverableCount:uint = 0) 
    {//-----------------------------
        _tools = { };
        _history = [];
        _recoverableAll = false;
        _recoverableCount = recoverableCount;
        _width = w;
        _height = h;
        _cache = new Sprite();
        _cache.graphics.beginFill(0, 0);
        _cache.graphics.drawRect(0, 0, _width, _height);
        addChildAt(_cache, 0);
        
        _mask = new Shape();
        _mask.graphics.beginFill(0, 0);
        _mask.graphics.drawRect(0, 0, _width, _height);
        mask = _mask;
        addChildAt(_mask, 0);
        
        if (background) updateBackground(background);
    }
    
    public function activate():void//-----------------------------
    {
        addEventListener(MouseEvent.MOUSE_DOWN, mouseDownListener);
    }
    
    public function inactivate():void//-----------------------------
    {
        removeEventListener(MouseEvent.MOUSE_DOWN, mouseDownListener);
        removeEventListener(MouseEvent.MOUSE_UP, mouseUpListener);
        removeEventListener(MouseEvent.MOUSE_OUT, mouseUpListener);
        removeEventListener(Event.ENTER_FRAME, enterFrameListener);
    }
    
    public function getDrawingData():BitmapData//-----------------------------
    {
        return getBitmapData(this);
    }
    
    public function stack(displayObject:DisplayObject):void//-----------------------------
    {
        _history.push(displayObject);
        _length = _history.length;
        if (_length <= _recoverableCount) return;
        
        var i:uint;
        for (i = 1; i < _length; i++)
        {
            _history[i]["visible"] = false;
        }
        updateBackground(this);
        _history.shift();
        _length--;
        _cache.removeChildAt(0);
        
        for (i = 0; i < _length; i++)
        {
            _history[i]["visible"] = true;
        }
    }
    
    public function attach(key:String, tool:ITool):String//-----------------------------
    {
        if (!_tools[key]) _tools[key] = tool;
        return key;
    }
    
    public function change(key:String):void//-----------------------------
    {
        if (_tools[key]) _currentTool = _tools[key];
    }
    
    public function recover():void//-----------------------------
    {
        if (_length) 
        {
            trace(_length);
            _cache.removeChildAt(--_length);
            _history.pop();
        }
    }
    
    public function recoverAll():void//-----------------------------
    {
        for (var i:uint = 0; i < _length; i++)
        {
            _cache.removeChildAt(0);
        }
        _history = [];
        _length = 0;
        
        if (_background && contains(_background)) removeChild(_background);
        _background = new Bitmap(_original);
        addChildAt(_background, 0);
        _recoverableAll = false;
    }
    
    private function updateBackground(background:IBitmapDrawable):void//-----------------------------
    {
        var bitmapData:BitmapData = getBitmapData(background);
        if (!_original) _original = bitmapData;
        if (_background && contains(_background)) removeChildAt(0);
        _background = new Bitmap(bitmapData);
        addChildAt(_background, 0);
    }
    
    private function getBitmapData(background:IBitmapDrawable):BitmapData//-----------------------------
    {
        var bitmapData:BitmapData = new BitmapData(_width, _height);
        bitmapData.draw(background);
        return bitmapData;
    }
    
    // _____________________________________________________ Listener
    /**
     * MouseEvent.MOUSE_DOWN
     * @param    event
     */
    private function mouseDownListener(event:MouseEvent):void//-----------------------------
    {
        var e:DrawingEvent = new DrawingEvent(DrawingEvent.START_DRAWING, true, true, mouseX, mouseY);
        dispatchEvent(e);
        if (!e.isDefaultPrevented())
        {
            addEventListener(MouseEvent.MOUSE_UP, mouseUpListener);
            addEventListener(MouseEvent.MOUSE_OUT, mouseUpListener);
            addEventListener(Event.ENTER_FRAME, enterFrameListener);
            if (_currentTool) 
            {
                _currentTool.start(mouseX, mouseY);
                _cache.addChildAt(_currentTool.displayObject, _length);
                _recoverableAll = true;
            }
        }
    }
    
    /**
     * Event.ENTER_FRAME
     * @param    event
     */
    private function enterFrameListener(event:Event):void//-----------------------------
    {
        var e:DrawingEvent = new DrawingEvent(DrawingEvent.MOVE_DRAWING, true, true, mouseX, mouseY);
        dispatchEvent(e);
        if (!e.isDefaultPrevented())
        {
            if (_currentTool) _currentTool.move(mouseX, mouseY);
        }
    }
    
    /**
     * MouseEvent.MOUSE_UP
     * @param    event
     */
    private function mouseUpListener(event:MouseEvent):void//-----------------------------
    {
        var e:DrawingEvent = new DrawingEvent(DrawingEvent.STOP_DRAWING, true, true, mouseX, mouseY);
        dispatchEvent(e);
        if (!e.isDefaultPrevented())
        {
            inactivate();
            activate();
            if (_currentTool)
            {
                stack(_currentTool.displayObject);
                _currentTool.stop(mouseX, mouseY);
            }
        }
    }
}


import flash.events.Event;

/**
 * drawing event
 * @author naoto koshikawa
 */
class DrawingEvent extends Event //==========================================
{
    public static const START_DRAWING:String = "startDrawing";
    public static const MOVE_DRAWING:String = "moveDrawing";
    public static const STOP_DRAWING:String = "stopDrawing";
    
    private var _x:Number;
    public function get x():Number//-----------------------------
    {
        return _x;
    }
    
    private var _y:Number;
    public function get y():Number//-----------------------------
    {
        return _y;
    }
    
    public function DrawingEvent(type:String, bubbles:Boolean=false, cancelable:Boolean=false, x:Number = 0, y:Number = 0) 
    { //-----------------------------
        super(type, bubbles, cancelable);
        _x = x;
        _y = y;
    } 
    
    public override function clone():Event//----------------------------- 
    { 
        return new DrawingEvent(type, bubbles, cancelable, _x, _y);
    } 
    
    public override function toString():String //-----------------------------
    { 
        return formatToString("DrawingEvent", "type", "bubbles", "cancelable", "eventPhase", "x", "y"); 
    }
    
}

import flash.display.DisplayObject;

/**
 * jp.ppworks.drawing.simple
 * パッケージで使用できるツールのインターフェースです
 * 
 * @author naoto koshikawa
 */
interface ITool //==========================================
{
    function get displayObject():DisplayObject;
    function set options(options:Object):void;
    function get options():Object;
    function start(x:Number, y:Number):void;
    function move(x:Number, y:Number):void;
    function stop(x:Number, y:Number):void;
}

import flash.display.DisplayObject;
import flash.display.Shape;

/**
 * Pen Tool
 * @author naoto koshikawa
 */
class PenTool implements ITool//=============================
{
    private var _displayObject:Shape;
    public function get displayObject():DisplayObject
    {
        return _displayObject;
    }
    
    private var _options:Object;
    public function get options():Object
    {
        return _options;
    }
    public function set options(options:Object):void
    {
        if (options && options.thickness) _options.thickness = options.thickness;
        if (options && options.color) _options.color = options.color;
    }
    
    // _____________________________________________________ Method
    public function PenTool() 
    {
        _options = {
            thickness:3,
            color:0x000000
        };
    }
    
    public function start(x:Number, y:Number):void
    {
        _displayObject = new Shape();
        _displayObject.graphics.lineStyle(
            _options.thickness,
            _options.color
        );
        _displayObject.graphics.moveTo(x, y);
    }
    
    public function move(x:Number, y:Number):void
    {
        if (!_displayObject) return;
        _displayObject.graphics.lineTo(x, y);
    }
    
    public function stop(x:Number, y:Number):void
    {
        if (!_displayObject) return;
        if (_displayObject.width == _options.thickness
            && _displayObject.height == _options.thickness)
        {
            _displayObject.graphics.clear();
            _displayObject.graphics.beginFill(_options.color);
            _displayObject.graphics.drawCircle(x, y, _options.thickness/2);
        }
        else
        {
            move(x, y);
        }
    }
}





//-----SVG----------------------------------



    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    
    [SWF(backgroundColor="0xffffff", frameRate="60", width="465", height="465")]

    /**
     * @author Saqoosha
     */
    class airpen extends Sprite {//=======================================



        private static const SCALE:Number = 0.02;


        private var _index:int;
        private var _points:Vector.<Number> = new Vector.<Number>();


        public function airpen() {
            var loader:URLLoader = new URLLoader();
            loader.addEventListener(Event.COMPLETE, _onLoaded);
            loader.load(new URLRequest('http://saqoo.sh/a/labs/wonderfl/110224 174249.svg'));
        }


        private function _onLoaded(event:Event):void {
            var data:XML = new XML(event.target.data);
            var svg:Namespace = data.namespace();
            for each (var path:XML in data..svg::path) {
                for each (var p:String in path.@d.match(/\d+/g)) {
                    _points.push(Number(p) * SCALE);
                }
            }
            graphics.clear();
            _index = 0;
            addEventListener(Event.ENTER_FRAME, _onEnterFrame);
        }


        private function _onEnterFrame(e:Event):void {
            var n:int = _points.length/600;
            while (n--) {
                _draw();//線描画
                if (_index == _points.length) {
                    removeEventListener(Event.ENTER_FRAME, _onEnterFrame);
                    addEventListener(MouseEvent.CLICK,replay);
                    break;
                }
            }
        }

        private function replay(e:MouseEvent):void{
            graphics.clear();
            _index = 0;
            addEventListener(Event.ENTER_FRAME, _onEnterFrame);
        }

        //線描画
        private function _draw():void {
            graphics.lineStyle(1, 0xff);
            graphics.moveTo(_points[_index++], _points[_index++]);
            graphics.lineTo(_points[_index++], _points[_index++]);
        }
    }


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {//============================
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}


//////////////////////////////////////////////////
// ActionMenuクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.DropShadowFilter;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;
import flash.geom.ColorTransform;
import flash.events.Event;
import flash.events.MouseEvent;

class ActionMenu extends Sprite {//=============================
    public var id:uint;
    private var shade:Shape;
    private var base:Shape;
    private var front:Shape;
    private var light:Shape;
    private var reflection:Shape;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 32;
    private static var corner:uint = 6;
    private static var tHeight:uint = 17;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private var baseColor:uint = 0x0066CC;
    private var lightColor:uint = 0x00FFFF;
    private var overColor:uint = 0x3333FF;
    private static var tColor:uint = 0xFFFFFF;
    private var defaultColorTrans:ColorTransform;
    private static var disableColor:uint = 0xCCCCCC;
    private static var disableColorTrans:ColorTransform;
    private var mode:int;
    private var _selected:Boolean = false;
    private var _enabled:Boolean = true;

    public function ActionMenu() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        draw();
    }
    public function colorize(color:uint, list:Array):void {
        var bTrans:ColorTransform = new ColorTransform();
        bTrans.color = color;
        defaultColorTrans = bTrans;
        base.transform.colorTransform = bTrans;
        front.transform.colorTransform = bTrans;
        lightColor = list[0];
        overColor = list[0];
        createLight(light, _width-2, _height-2, corner);
    }
    private function draw():void {
        defaultColorTrans = new ColorTransform();
        disableColorTrans = new ColorTransform();
        disableColorTrans.color = disableColor;
        shade = new Shape();
        base = new Shape();
        front = new Shape();
        light = new Shape();
        reflection = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(base);
        addChild(front);
        addChild(light);
        addChild(reflection);
        addChild(txt);
        createBase(shade, _width, _height, corner, bColor);
        shade.filters = [new DropShadowFilter(1, 90, sColor, 0.4, 4, 4, 2, 3, false, false)];
        createBase(base, _width-2, _height-2, corner, baseColor);
        createFront(front, _width, _height, corner);
        createLight(light, _width-2, _height-2, corner);
        createReflection(reflection, _width-2, _height-2, corner);
        txt.x = -_width/2;
        txt.y = -tHeight + _height/4;
        txt.width = _width;
        txt.height = tHeight;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 10;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.textColor = tColor;
        txt.text = label;
        txt.filters = [new DropShadowFilter(0, 90, sColor, 0.5, 2, 2, 2, 3, false, false)];
        light.alpha = 0;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent = null):void {
        mode = 1;
        addEventListener(Event.ENTER_FRAME, action, false, 0, true);
    }
    private function rollOut(evt:MouseEvent = null):void {
        mode = -1;
        addEventListener(Event.ENTER_FRAME, action, false, 0, true);
    }
    private function action(evt:Event):void {
        light.alpha += 0.1*mode;
        if (light.alpha < 0) {
            light.alpha = 0;
            removeEventListener(Event.ENTER_FRAME, action);
        }
        if (light.alpha > 1) {
            light.alpha = 1;
            removeEventListener(Event.ENTER_FRAME, action);
        }
    }
    private function _up():void {
        base.transform.colorTransform = defaultColorTrans;
        front.transform.colorTransform = defaultColorTrans;
    }
    private function _down():void {
        base.transform.colorTransform = defaultColorTrans;
        front.transform.colorTransform = defaultColorTrans;
        light.alpha = 1;
    }
    private function _disable():void {
        base.transform.colorTransform = disableColorTrans;
        front.transform.colorTransform = disableColorTrans;
    }
    public function get selected():Boolean {
        return _selected;
    }
    public function set selected(param:Boolean):void {
        _selected = param;
        enabled = !_selected;
        if (_selected) {
            _down();
        } else {
            _up();
            rollOut();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
        } else {
            _disable();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);
        target.graphics.endFill();
    }
    private function createFront(target:Shape, w:uint, h:uint, c:uint):void {
        var colors:Array = [baseColor, baseColor];
        var alphas:Array = [0, 0.5];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(w, h, 0.5*Math.PI, -w/2, -h/2);
        target.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        target.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);
        target.graphics.endFill();
    }
    private function createLight(target:Shape, w:uint, h:uint, c:uint):void {
        target.graphics.clear();
        var colors:Array = [lightColor, overColor];
        var alphas:Array = [1, 0];
        var ratios:Array = [40, 160];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(w*2, h*3, 0, -w, -h*0.9);
        target.graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        target.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);
        target.graphics.endFill();
    }
    private function createReflection(target:Shape, w:uint, h:uint, c:uint):void {
        target.graphics.beginFill(bColor, 0.3);
        target.graphics.drawEllipse(-w*1.125, -h*4.375, w*2.25, h*4.375);
        target.graphics.endFill();
        var _mask:Shape = new Shape();
        _mask.graphics.beginFill(sColor);
        _mask.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);
        _mask.graphics.endFill();
        addChild(_mask);
        target.mask = _mask;
    }

}





//-------------------------------------    
    
    

    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.text.*;
  
    class twit1 extends Sprite {
        private var _resultStage:Sprite = new Sprite();
        private var maxID:String;//これより古いIDを取得
        private var sinceID:String;//これより新しいIDを取得
        private var keyword:String;
        public function twit1():void {
            //ヘッダーのサーチエリア
            //背景
            var titleArea:Shape = new Shape();
            titleArea.graphics.beginFill(0x39CCFF);
            titleArea.graphics.drawRect(0, 0, 465, 23);
            addChild(titleArea);
            //Serchの文字
            var serchWord:TextField = new TextField();
            serchWord.text = "Serch:";
            serchWord.width = 33;
            serchWord.height = 18;
            serchWord.x = 2;
            serchWord.y = 2;
            serchWord.textColor = 0xFFFFFF;
            addChild(serchWord);
            //テキスト入力欄。キーボードのキーを押し上げた際にonKeyUpが実行される
            var title:TextField = new TextField();
            title.text = "wonderfl";
            title.width = 426;
            title.height = 18;
            title.x = 36;
            title.y = 2;
            title.border = true;
            title.borderColor = 0xFFFFFF;
            title.background = true;
            title.backgroundColor = 0x99DDFF;
            title.type = TextFieldType.INPUT;
            title.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
            addChild(title);
            
            //検索結果を配置するSpriteをaddChild
            _resultStage.y = 25;
            addChild(_resultStage);
            
            //初期状態で検索結果画面が出るように、検索を実行する。
            serch(title.text);
        }
        
        private function onKeyUp(e:KeyboardEvent):void {
            //Enterキーのキーコード13だったら、serchメソッドを実行。引数には適すと入力欄の文字列
            if (e.keyCode == 13) {
                serch(e.currentTarget.text)
            }
        }
        
        public function serch(serchWord:String):void {
            //検索APIにリクエストを投げる
            //http://search.twitter.com/crossdomain.xml上で許可をしているので
            //特に指定しなくても自動的に確認して、許可を得られる
            keyword = serchWord;
            var myURLLoader:URLLoader = new URLLoader();
            myURLLoader.addEventListener(Event.COMPLETE, onCompleteXML);
            myURLLoader.addEventListener(IOErrorEvent.IO_ERROR, onIoError);
            var xmlURL:String = "http://search.twitter.com/search.atom?q=";
            //encodeURIComponent()を使うことによって、#や日本語にも対応
            xmlURL += encodeURIComponent(serchWord);        //*1
            myURLLoader.load(new URLRequest(xmlURL));
        }
        
        public function moreRequest():void{
            
            var myURLLoader:URLLoader = new URLLoader();
            myURLLoader.addEventListener(Event.COMPLETE, onCompleteXML2);
            myURLLoader.addEventListener(IOErrorEvent.IO_ERROR, onIoError);
            var xmlURL:String = "http://search.twitter.com/search.atom?q=";
            //encodeURIComponent()を使うことによって、#や日本語にも対応
            xmlURL += encodeURIComponent(keyword);        //*1
            xmlURL += "&max_id="+sinceID;
            myURLLoader.load(new URLRequest(xmlURL));
        }

        
        public function onIoError(e:IOErrorEvent):void {
            trace(e.type);
        }
        
        private function idNum(id:String):String{
            var reg:RegExp = new RegExp();
            reg = /:\d+/;
           // if(reg.test(id)==false)return -1;
            var result:Object = reg.exec(id);
            //return result.index;
            var str:String = id.substring(result.index+1);
            
            
            return str;
        }

        
        private function onCompleteXML(e:Event):void {
            //eventListenerを削除
            e.currentTarget.removeEventListener(Event.COMPLETE, onCompleteXML);
            //_resultStage上のオブジェクトを全て削除
            while (_resultStage.numChildren) {
                _resultStage.removeChildAt(0);
            }
            
            //XML型にキャスト
            var myXML:XML = new XML(e.currentTarget.data);
            //namespaceを設定
            default xml namespace = new Namespace("http://www.w3.org/2005/Atom");        //*2
            
            //ヘッダーの下
            var tfY:int = 0;
            //要素を取り出して、textFieldを作りならべる
            var itemLength:int = myXML.entry.length();
            maxID=myXML.max_id;
            var ID1:TextField = new TextField();
            

            //addChild(ID1);
            ID1.background = true;
            ID1.y = -50;
            ID1.width = 800;
            ID1.height = 400;
            for (var i:int = 0; i < itemLength; i++) {
                //xmlからlink,authorName,titleの各値を取得
                var ts:String = myXML.entry[i].published;
                var idStr:String = myXML.entry[i].id;
                var id:String = idNum(idStr);
                var link:String = myXML.entry[i].link[0].@href;
                var authorName:String = myXML.entry[i].author.name;
                var title:String = myXML.entry[i].title;
                //idの評価
                if(maxID==null)maxID=id;
                else{
                    if( Number(maxID) < Number(id) )maxID=id;
                }
                if(sinceID==null)sinceID=id;
                else{
                    if( Number(id) < Number(sinceID) )sinceID=id;
                    
                }


                
                //アイコン画像のURLを取得
                var imgURL:String = myXML.entry[i].link[1].@href;
                //bmpフォーマットのアイコン画像を使っている人も少なくないため、Flashで使えるファイルの拡張子かどうかを判別
                var extention:String = imgURL.substr( -4);
                extention = extention.toLowerCase();
                if (extention != ".jpg" && extention != ".gif" && extention != ".png") {
                    //Flashで使える画像の拡張子ではなかった場合にはデフォルトアイコンを指定
                    imgURL = "http://s.twimg.com/a/1254440757/images/default_profile_mini.png";
                }
                //画像のファイル名が日本語などの規定外の文字である場合を考慮しエンコードする
                imgURL = encodeURI(imgURL);        //*3
                //小さい画像で十分なので、名前を差し替える
                //imgURL = imgURL.replace(/_normal\./, "_mini\.");
                
                //得られた各値をhtmlTextに入るように整形
                var htmldata:String = "";
                htmldata = "<a href='" + link + "' target='_blank'>";
                htmldata += "<b>" + ts +id+"</b> ";
                htmldata += "<img src='" + imgURL + "' width='24' height='24' />";
                htmldata += "<b>" + authorName + "</b> ";
                htmldata += title + "</a>";
                //検索結果のテキストフィールド
                var myTextField:TextField = new TextField();
                myTextField.width = 460;
                myTextField.x = 2;
                myTextField.wordWrap = true;
                myTextField.background = true;
                myTextField.backgroundColor = 0xFFFFFF;
                myTextField.border = true;
                myTextField.borderColor = 0x39CCFF;
                myTextField.htmlText = htmldata;
                myTextField.autoSize = "left";
                //テキストフィールドのy座標はtfYに加算していくことにより、決定
                myTextField.y = tfY;
                tfY += myTextField.height + 3;
                _resultStage.addChild(myTextField);
            }
            tfY2=tfY;
        }
        
        private var tfY2:int;
        private function onCompleteXML2(e:Event):void {
            //eventListenerを削除
            e.currentTarget.removeEventListener(Event.COMPLETE, onCompleteXML2);
            //_resultStage上のオブジェクトを全て削除
            /*
            while (_resultStage.numChildren) {
                _resultStage.removeChildAt(0);
            }
            */
            
            //XML型にキャスト
            var myXML:XML = new XML(e.currentTarget.data);
            //namespaceを設定
            default xml namespace = new Namespace("http://www.w3.org/2005/Atom");        //*2
            
            //ヘッダーの下
            var tfY:int = tfY2;
            //要素を取り出して、textFieldを作りならべる
            var itemLength:int = myXML.entry.length();
            maxID=myXML.max_id;
            var ID1:TextField = new TextField();
            

            //addChild(ID1);
            ID1.background = true;
            ID1.y = -50;
            ID1.width = 800;
            ID1.height = 400;
            for (var i:int = 1; i < itemLength; i++) {
                //xmlからlink,authorName,titleの各値を取得
                var ts:String = myXML.entry[i].published;
                var idStr:String = myXML.entry[i].id;
                var id:String = idNum(idStr);
                var link:String = myXML.entry[i].link[0].@href;
                var authorName:String = myXML.entry[i].author.name;
                var title:String = myXML.entry[i].title;
                //idの評価
                //if(Number(id)<Number(maxID))maxID=id;
                if( Number(id) < Number(sinceID) )sinceID=id;


                
                //アイコン画像のURLを取得
                var imgURL:String = myXML.entry[i].link[1].@href;
                //bmpフォーマットのアイコン画像を使っている人も少なくないため、Flashで使えるファイルの拡張子かどうかを判別
                var extention:String = imgURL.substr( -4);
                extention = extention.toLowerCase();
                if (extention != ".jpg" && extention != ".gif" && extention != ".png") {
                    //Flashで使える画像の拡張子ではなかった場合にはデフォルトアイコンを指定
                    imgURL = "http://s.twimg.com/a/1254440757/images/default_profile_mini.png";
                }
                //画像のファイル名が日本語などの規定外の文字である場合を考慮しエンコードする
                imgURL = encodeURI(imgURL);        //*3
                //小さい画像で十分なので、名前を差し替える
                //imgURL = imgURL.replace(/_normal\./, "_mini\.");
                
                //得られた各値をhtmlTextに入るように整形
                var htmldata:String = "";
                htmldata = "<a href='" + link + "' target='_blank'>";
                htmldata += "<b>" + ts +id+"</b> ";
                htmldata += "<img src='" + imgURL + "' width='24' height='24' />";
                htmldata += "<b>" + authorName + "</b> ";
                htmldata += title + "</a>";
                //検索結果のテキストフィールド
                var myTextField:TextField = new TextField();
                myTextField.width = 460;
                myTextField.x = 2;
                myTextField.wordWrap = true;
                myTextField.background = true;
                myTextField.backgroundColor = 0xFFFFFF;
                myTextField.border = true;
                myTextField.borderColor = 0x39CCFF;
                myTextField.htmlText = htmldata;
                myTextField.autoSize = "left";
                //テキストフィールドのy座標はtfYに加算していくことにより、決定
                myTextField.y = tfY;
                tfY += myTextField.height + 3;
                _resultStage.addChild(myTextField);
            }
        tfY2 = tfY;
        }
    }

// forked from gazlag's forked from: whatever 8
// forked from wh0's whatever 8

    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    class Draw3D extends Sprite {
        
        private static const K:Number = 4 / 3 * (Math.SQRT2 - 1);
        private static const R1:Number = 32;
        private static const R2:Number = 30;
        private static const L:Number = 64;
        public var color01:uint = 0x00ff00;
        private var c:C;
        
        public function Draw3D(color:uint=0xff0000) {
            color01 = color;
            c = new C();
            c.m = new Matrix3D();
            c.o = new Vector3D(320, 240, 0, 0);//初期位置
            click(null);//回転セット
            this.addEventListener(MouseEvent.CLICK, click);
            this.addEventListener(Event.ENTER_FRAME, frame);
            //stage.frameRate = 60;
        }
        
        private function click(e:MouseEvent):void {
            c.v = uv();//回転量設定
            c.m.identity();
            c.m.appendRotation(2, uv());
        }
        
        //フレーム
        private function frame(e:Event):void {
            c.v = c.m.transformVector(c.v);//角度変更
            graphics.clear();//画像クリア
            r(graphics, c.o, c.v);//レンダリング
        }
        
        private static function uv():Vector3D {
            var v:Vector3D = new Vector3D(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5);
            v.normalize();
            return v;
        }
        
        //レンダリングフェーズ
        private function r(g:Graphics, o:Vector3D, v:Vector3D):void {
            var i:Vector3D = v.clone();
            var j:Vector3D = i.crossProduct(Vector3D.Z_AXIS);
            if (j.normalize() < 0.001) {
                g.drawCircle(o.x, o.y, R1);
                return;
            }
            var k:Vector3D = i.crossProduct(j);
            if (k.x * i.x + k.y * i.y > 0) {
                k.scaleBy(-1);
                rh(g, o, i, j, k, false,0xffffff);
                rh(g, o, i, j, k, true,color01);
            } else {
                rh(g, o, i, j, k, true,color01);
                rh(g, o, i, j, k, false,0xffffff);
            }
        }
        
        private function rh(g:Graphics, o:Vector3D, i:Vector3D, j:Vector3D, k:Vector3D, h:Boolean, color:uint=0xffffff):void {
            i = i.clone();
            i.scaleBy(h ? L : -L);
            j = j.clone();
            j.scaleBy(h ? R1 : -R2);
            k = k.clone();
            k.scaleBy(h ? R1 : -R2);
            
            g.beginFill(color,h ? 1:0.8);
            g.lineStyle(2, 0x000000);
            g.moveTo(o.x + j.x, o.y + j.y);//描画開始位置
            g.lineTo(o.x + j.x + i.x, o.y + j.y + i.y);
            //cubicCurveTo:三次ベジェ曲線
            g.cubicCurveTo(
                o.x + j.x + i.x - K * j.y,//x1
                o.y + j.y + i.y + K * j.x,//y1
                o.x + i.x - j.y + K * j.x,//x2
                o.y + i.y + j.x + K * j.y,//y2
                o.x + i.x - j.y,//x3
                o.y + i.y + j.x//y3
            );
            g.cubicCurveTo(
                o.x + i.x - j.y - K * j.x, o.y + i.y + j.x - K * j.y,
                o.x - j.x + i.x - K * j.y, o.y - j.y + i.y + K * j.x,
                o.x - j.x + i.x, o.y - j.y + i.y
            );
            g.lineTo(o.x - j.x, o.y - j.y);
            //g.moveTo(o.x-j.x,o.y-j.y);
            g.cubicCurveTo(
                o.x - j.x + K * k.x, o.y - j.y + K * k.y,
                o.x + k.x - K * j.x, o.y + k.y - K * j.y,
                o.x + k.x, o.y + k.y
            );
            g.cubicCurveTo(
                o.x + k.x + K * j.x, o.y + k.y + K * j.y,
                o.x + j.x + K * k.x, o.y + j.y + K * k.y,
                o.x + j.x, o.y + j.y
            );
        }
        
    }


internal class C {
    
    public var o:flash.geom.Vector3D;
    public var v:flash.geom.Vector3D;
    public var m:flash.geom.Matrix3D;
    
}

// forked from umhr's 敵機急速接近中！

    import flash.display.GradientType;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.geom.Matrix3D;
    import flash.geom.Vector3D;
    
    /**
     * 引き出し線（leader line）

     */
    
    class Main1 extends Sprite {
        private var _canvas:Sprite = new Sprite();
        private var _count:int;
        private var _nodeList:Vector.<Node> = new Vector.<Node>();
        /**
         * Nodeにまとめちゃうともっとみやすいコードになりそうだけど、
         * 計算時間が倍近くかかるので、躊躇
         */
        private var _pointXList:Vector.<Number> = new Vector.<Number>();
        private var _pointYList:Vector.<Number> = new Vector.<Number>();
        private var _pointList:Vector.<Vector3D> = new Vector.<Vector3D>();
        public function Main1() 
        {
            init();
        }
        private function init():void 
        {
            if (stage) onInit();
            else addEventListener(Event.ADDED_TO_STAGE, onInit);
        }
        
        private function onInit(event:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            with(_canvas.graphics){//背景描画
                beginFill(0x000000);
                drawRect(-200,-200, 465, 465);
                endFill();
            }
            this.addChild(_canvas);
            
            var n:int = 20;
            _canvas.x = 200;
            _canvas.y = 200;
            for (var i:int = 0; i < n; i++) 
            {
                _nodeList[i] = new Node(i);
                _nodeList[i].text = "node "+(i+1);
                _canvas.addChild(_nodeList[i]);
                _pointList[i] = new Vector3D(400 * (Math.random() - 0.5), 400 * (Math.random() - 0.5), 400 * (Math.random() - 0.5));
                _nodeList[i].color = 0x00ff00;
                _nodeList[i].alpha = 0.5;
            }
            //onEnterFrame(null);
            this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void 
        {
            var matrix3D:Matrix3D = new Matrix3D();
            var vector3D:Vector3D = new Vector3D(0.5, 0.8, 0.4);
            vector3D.normalize();
            matrix3D.appendRotation(_count, vector3D);
            
            var n:int = _pointList.length;
            for (var i:int = 0; i < n; i++) 
            {
                vector3D = pertrans(matrix3D.transformVector(_pointList[i]));
                _pointXList[i] = vector3D.x;
                _pointYList[i] = vector3D.y;
            }
            
            escaper();
            _count ++;
        }
        
        private function pertrans(vector3D:Vector3D):Vector3D {
            var result:Vector3D = new Vector3D();
            var per:Number = 1000 / (1000 + vector3D.z);
            return new Vector3D(vector3D.x * per, vector3D.y * per, per);
        }
        
        /**
         * 文字がぶつからないように、近くのノードとは反対方向を割り出す。
         * 10フレームに一度だけにして、計算コストを低減。
         */
        private function escaper():void {
            //var time:Number = new Date().time;
            var _radianList:Vector.<Number> = new Vector.<Number>();
            var n:int = _pointXList.length;
            var direction:Array = [];
            var i:int;
            var j:int;
            
            if (_count%20 == 0) {//処理間隔
                    
                for (i = 0; i < n; i++) {//ノード
                    //八方向に
                    direction = [0, 0, 0, 0, 0, 0, 0, 0];
                    for (j = 0; j < n; j++){
                        if (i == j) { continue };//同一ノードを省略
                        var px:Number = _pointXList[i] - _pointXList[j];
                        var py:Number = _pointYList[i] - _pointYList[j];
                        var length:Number = px * px + py * py;
                        
                        if (length > 2500) { continue };
                        var r:int = int((8.5 + 4 * Math.atan2(py, px) / Math.PI) %8);
                        length = 1 / length;
                        
                        direction[(6 + r) % 8] += length * 0.5;
                        direction[(7 + r) % 8] += length * 0.7;
                        direction[r] += length;
                        direction[(1 + r) % 8] += length * 0.7;
                        direction[(2 + r) % 8] += length * 0.5;
                    }
                    var compass:int = direction.sort(Array.NUMERIC | Array.RETURNINDEXEDARRAY)[7];
                    _nodeList[i].radian = Math.PI * compass / 4;
                }
                
            }
            for (i = 0; i < n; i++){
                _nodeList[i].draw(_pointXList[i], _pointYList[i]);
            }
        }
    }
    


/**
 * ノードです。
 */
import flash.display.*;
import flash.text.TextField;
class Node extends Sprite {
    private var _radian:Number;
    private var direction:Number = 0;
    private var _textField:TextField = new TextField();
    private var _target:Shape = new Shape();
    private var _color:uint = 0xccccff;
    
    //エントリ
    public function Node(index:int) {
        with(_textField){//テキストスタイル
            textColor = _color;//カラー
            autoSize = "left";
            cacheAsBitmap = true;//内部表現キャッシュ
            multiline = false;
            selectable = false;//テキスト選択不可
        }
        this.addChild(_textField);
        if(index == 0){
            _target.graphics.beginFill(0xFF0000, 1);
        }else {
            _target.graphics.beginFill(0x009966, 1);
        }
        _target.graphics.drawCircle(x , y , 2);//ノード
        _target.graphics.endFill();
        this.addChild(_target);
    }
    
    public function draw2(x:Number,y:Number,tx:Number,ty:Number):void{
        this.graphics.clear();
        StageAlign.TOP_LEFT
        _textField.y = ty;
        _target.x = x;
        _target.y = y;
        with(this.graphics){
            lineStyle(0, _color);
            moveTo(x , y );
            if(x+tx < x){
                _textField.x = tx + x-_textField.textWidth;
                lineTo(x+tx, ty +_textField.textHeight);
                moveTo(x+tx,ty+_textField.textHeight);
                lineTo(x+tx-_textField.textWidth,ty+_textField.textHeight);
            }
            else{
                _textField.x = tx + x;
                lineTo(tx + x, ty +_textField.textHeight);
                moveTo(x+tx,ty+_textField.textHeight);
                lineTo(x+tx+_textField.textWidth,ty+_textField.textHeight);
            }
        }
    }

    //描画
    public function draw(x:Number, y:Number, tx:Number=0, ty:Number=0):void {
        this.graphics.clear();
        
        direction = radian * 0.1 + direction * 0.9;
        
        //テキスト位置
        var tx:Number = Math.cos(direction) * 40;
        var ty:Number = Math.sin(direction) * 20;
        var x2:Number = x+(tx/4);
        var y2:Number = y+(ty/4);
        _textField.y = ty + y2 -_textField.height;
        _target.x = x;
        _target.y = y;
        with(this.graphics){
            lineStyle(0, _color);
            moveTo(x2 , y2 );
            if(x+tx < x){
                _textField.x = tx + x2-_textField.textWidth;
                lineTo(x2+tx, ty + y2 );
                moveTo(x2+tx,y2+ty);
                lineTo(x2+tx-_textField.textWidth,y2+ty);
            }
            else{
                _textField.x = tx + x2;
                lineTo(tx + x2, ty + y2 );
                moveTo(x2+tx,y2+ty);
                lineTo(x2+tx+_textField.textWidth,y2+ty);
            }

            
        }
        
    }
    public function get color():uint { return _color; };
    public function set color( value:uint ):void {
        _color = value;
        _textField.textColor = _color;
    }

    public function get text():String{ return _textField.text; };
    public function set text(s:String):void{ _textField.text = s; };
    public function get radian():Number { return _radian; }
    
    public function set radian(value:Number):void 
    {
        if (Math.abs(value-direction) > Math.PI) {
            if (value>direction) {
                value -= Math.PI * 2;
            }else {
                direction -= Math.PI * 2;
            }
        }
        
        _radian = value;
    }
}

/* ------------------------------------------------------------------------------------------------
 * MiniChat
 * ------------------------------------------------------------------------------------------------
 */
//package {
    import com.bit101.components.PushButton;
    import com.bit101.components.Style;
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.net.*;
    import flash.media.*;
    import flash.text.*;
    import flash.ui.*;
    import net.user1.logger.Logger;
    import net.user1.reactor.IClient;
    import net.user1.reactor.Reactor;
    import net.user1.reactor.ReactorEvent;
    import net.user1.reactor.Room;
    import net.user1.reactor.RoomEvent;
    import net.user1.reactor.UpdateLevels;
    
    //public 
    class MiniChat extends Sprite {
        private var _so:SharedObject;
        private var _isReactorShared:Boolean;
        private var _reactor:Reactor;
        private var _roomID:String;
        private var _room:Room;
        private var _messageLogSize:int;
        private var _messages:Vector.<String>;
        // ステータスバー
        private var _title:String;
        private var _statusBar:TextField;
        private var _minimizeButton:PushButton;
        // ウインドウ
        private var _window:Sprite;
        private var _messageDisplay:TextField;
        private var _nameInput:TextField;
        private var _messageInput:TextField;
        
        private var inputHeight:Number=20;
        
        private var color1:uint = 0x00aaff;
        
        public function MiniChat(roomID:String, args:Object = null) {
            var now:Date = new Date();
            updateTime = now.getTime();
            
            _so = SharedObject.getLocal("MiniChat");
            if (!_so.data.name) { _so.data.name = "名無し"; }
            
            if (!args) { args = { }; }
            var logSize:int =  10;
            var textColor:uint = 0xFFFFFF;
            var backgroundColor:uint = 0x404040;
            var defaultUserName:String =  _so.data.name;
            var initiallyMinimized:Boolean =  false;
            var draggable:Boolean = true;
            var minimizable:Boolean = true;
            var renamable:Boolean = true;
            
            _isReactorShared = false;
            _reactor =  new Reactor();
            _roomID = roomID;
            _messageLogSize = Math.max(1, logSize);
            _messages = new Vector.<String>();
            _title = "現在の参加";
            //_title = _roomID;
            // MinimalcompsのStyleを一時保存してから変更する
            var tempEmbedFonts:Boolean = Style.embedFonts;
            var tempFontName:String = Style.fontName;
            var tempFontSize:Number = Style.fontSize;
            Style.embedFonts = false;
            Style.fontName = "_sans";
            Style.fontSize = 12;
            
            // UIの作成
            addChild(_statusBar = createStatusBar(draggable, textColor, backgroundColor));
            
            _messageDisplay = createMessageDisplay(logSize);
            _window = createWindow(_messageDisplay.height);
            addChild(_window);
            _window.addChild(_messageDisplay);
            _nameInput = createInputText(0, _window.height-inputHeight, 60, 8, defaultUserName);
            if (renamable) {
                _window.addChild(_nameInput);
                _window.addChild(_messageInput = createInputText(60, _nameInput.y, 170, 50, ""));
            }else {
                _window.addChild(createSayLabel(_window.height - 19));
                _window.addChild(_messageInput = createInputText(31, _window.height - 19, 200, 50, ""));
            }
            _messageInput.addEventListener(KeyboardEvent.KEY_DOWN, sendMessage);
            // MinimalcompsのStyleを元に戻す
            Style.embedFonts = tempEmbedFonts;
            Style.fontName = tempFontName;
            Style.fontSize = tempFontSize;
            addChild(_minimizeButton = createMinimizeButton());
            if (initiallyMinimized) { minimize(); }
            addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
            addEventListener(Event.REMOVED_FROM_STAGE, removedFromStageHandler);
        }
        
        //ステータスバー
        private function createStatusBar(draggable:Boolean, textColor:uint, backgroundColor:uint):TextField {
            var result:TextField = new TextField();
            result.width = 232; result.height = 20;
            var format:TextFormat = new TextFormat("_sans", 10, color1);
            format.align = TextFormatAlign.CENTER;
            result.defaultTextFormat = format;
            //result.background = true; result.backgroundColor = backgroundColor;
            result.filters = [new BevelFilter(1, 45, 0xFFFFFF, 0.8, 0x000000, 0.8, 1, 1)];
            result.mouseEnabled = result.selectable = false;
            if (draggable) {
                result.mouseEnabled = true;
                result.addEventListener(MouseEvent.MOUSE_DOWN, startDragHandler);
                result.addEventListener(MouseEvent.MOUSE_UP, stopDragHandler);
            }
            return result;
        }
        private function startDragHandler(event:MouseEvent):void { startDrag(); }
        private function stopDragHandler(event:MouseEvent):void { stopDrag(); }
        
        //最小化ボタン
        private function createMinimizeButton():PushButton {
            var result:PushButton = new PushButton(null, 215, 3, "-", minimize);
            result.width = result.height = 14; result.draw();
            return result;
        }
        private function minimize(event:MouseEvent = null):void {
            _window.visible = !_window.visible;
            if (_minimizeButton) { _minimizeButton.label = (_window.visible) ? "-" : "+"; }
        }
          
        //ウィンドウ
        private function createWindow(messageDisplayHeight:int):Sprite {
            var result:Sprite = new Sprite();
            result.y = 20;
            result.graphics.lineStyle(0,color1);
            result.graphics.beginFill(0x000010, 0.8);
            result.graphics.drawRect(0, 0, 232, messageDisplayHeight+inputHeight );
            result.graphics.endFill();

            result.mouseEnabled = true;
            result.addEventListener(MouseEvent.MOUSE_DOWN, startDragHandler);
            result.addEventListener(MouseEvent.MOUSE_UP, stopDragHandler);

            return result;
        }
        
        //メッセージ欄
        private function createMessageDisplay(logSize:int):TextField {
            var result:TextField = new TextField();
            result.width = 232;
            result.defaultTextFormat = new TextFormat("_sans", 12, color1);
            //result.filters = [new DropShadowFilter(0, 0, 0x000055, 3,3,2,2)];
            //result.border =true;
            result.mouseEnabled = result.selectable = false;
            result.wordWrap = true;
            for (var i:int = 0; i < logSize; i++) { result.appendText(i + "\n"); }
            result.height = result.textHeight + 4; result.text = "";
            return result;
        }
        //入力ボックス
        private function createInputText(x:int, y:int, width:int, maxChars:int, text:String):TextField {
            var result:TextField = new TextField();
            result.x = x; result.y = y;
            result.width = width; result.height = 18;
            result.defaultTextFormat = new TextFormat("_sans", 10, 0x00aaff);
            result.border = true;
            result.borderColor=0x00aaff;
            result.maxChars = maxChars;
            result.selectable = true;
            result.type = TextFieldType.INPUT;
            result.text = text;
            return result;
        }
        
        private function createSayLabel(y:int):TextField {
            var result:TextField = new TextField();
            result.x = 1; result.y = y;
            result.width = 30; result.height = 18;
            result.defaultTextFormat = new TextFormat("_sans", 10, 0xFFFFFF, null, null, null, null, null, TextFormatAlign.CENTER);
            result.filters = [new GlowFilter(0x000000, 1, 2, 2)];
            result.mouseEnabled = result.selectable = false;
            result.text = "発言:";
            return result;
        }
        
        private function addedToStageHandler(event:Event):void {
            _reactor.addEventListener(ReactorEvent.READY, joinRoom);
            _reactor.addEventListener(ReactorEvent.CLOSE, leaveRoom);
            leaveRoom();
            
            if (_isReactorShared) {
                if (_reactor.isReady()) { joinRoom(); }
            } else {
                _reactor.getConnectionMonitor().setAutoReconnectFrequency(5000);
                _reactor.getLog().setLevel(Logger.FATAL);
                _reactor.connect("ozworks.dip.jp", 9100);
            }
        }
        
        private function removedFromStageHandler(event:Event):void {
            _reactor.removeEventListener(ReactorEvent.READY, joinRoom);
            _reactor.removeEventListener(ReactorEvent.CLOSE, leaveRoom);
            leaveRoom();
            
            if (!_isReactorShared) { _reactor.disconnect(); }
        }
        
        private function joinRoom(event:ReactorEvent = null):void {
            var updateLevels:UpdateLevels = new UpdateLevels();
            updateLevels.clearAll();
            updateLevels.occupantCount = updateLevels.roomMessages = true;
            
            _room = _reactor.getRoomManager().createRoom(_roomID);
            roomOccupantCountHandler();
            _room.addEventListener(RoomEvent.OCCUPANT_COUNT, roomOccupantCountHandler);
            _room.addMessageListener("CHAT_MESSAGE", receiveMessage);
            _room.join(null, updateLevels);
            
        }
        
        private function roomOccupantCountHandler(event:RoomEvent = null):void {
            _statusBar.text = _title + " " + _room.getNumOccupants() + "人";
            alart1();
        }
        
        private function leaveRoom(event:ReactorEvent = null):void {
            if (_room) {
                _room.removeEventListener(RoomEvent.OCCUPANT_COUNT, roomOccupantCountHandler);
                _room.removeMessageListener("CHAT_MESSAGE", receiveMessage);
                _room.leave();
            }
            
            _statusBar.text = "サーバーに接続中...";
        }
        
        //メッセージ送信
        private function sendMessage(event:KeyboardEvent):void {
            
            var now:Date = new Date();
            updateTime = now.getTime();
            
            if (!_reactor.isReady() || event.keyCode != Keyboard.ENTER || _messageInput.text == "") { return; }
            _room.sendMessage("CHAT_MESSAGE", true, null, _nameInput.text, _messageInput.text);
            _so.data.name = _nameInput.text;
            _messageInput.text = "";
        }
        
        //メッセージ受信
        private function receiveMessage(from:IClient, senderName:String, messageText:String):void {
            _messages.push(senderName + ": " + messageText);
            if (_messages.length > _messageLogSize) { _messages.shift(); }
            
            _messageDisplay.text = "";
            var messagesLength:int = _messages.length;
            for (var i:int = 0; i < messagesLength; i++) {
                _messageDisplay.appendText(_messages[i] + "\n");
            }
            
            alart1();
        }
        
        
        
        
        private function alart1():void{
            var now:Date = new Date();
            if(updateTime+1000*120 < now.getTime()){
                playSnd("http://ozworks.dip.jp/sound/l.mp3");
                updateTime = now.getTime();
            }
        }

        private var updateTime:Number;
        private var sndList:Array = new Array();
        private function playSnd(url:String):void{
            if(sndList[url]==null){
                var req:URLRequest = new URLRequest(url)
                var sound:Sound = new Sound(req);
                sndList[url]=sound;
            }
            sndList[url].play();
        }
    }
//}