/**
 * Copyright gurumi ( http://wonderfl.net/user/gurumi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ayqe
 */

// forked from set0's forked from: flash on 2009-6-2
package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.text.*;
    
    [SWF(width=465, height=465, frameRate=60, backgroundColor=0x000000)]
    
    public class FlashTest extends Sprite
    {
        private var max_line:uint = 8
        private var color_array:Array = [0xff0000, 0x0000ff];
        private var old_x_array:Array = [];
        private var old_y_array:Array = [];
        private var tmp_x_array:Array = [];
        private var tmp_y_array:Array = [];
        private var sp_array:Array = [];
        private var plate:Sprite = new Sprite();
        private var plate_target:Array =[];
        private var txt:TextField;
       
        public function FlashTest()
        {
           addChild(plate);
           var d:Number = 360 / max_line;
      
           for(var i:int=0;i<max_line;i++) {
               sp_array[i] = new Sprite();
               sp_array[i] = makeSprite(i);
               drawRing(sp_array[i], i);
               
               plate_target[i] = new Sprite();
               plate.addChild(plate_target[i]);

               plate_target[i].x = Math.cos(d * i * Math.PI / 180) * 50;
               plate_target[i].y = Math.sin(d * i * Math.PI / 180) * 50;
               old_x_array[i] = 0;
               old_y_array[i] = 0;
               tmp_x_array[i] = 0;
               tmp_y_array[i] = 0;
           }
           
           addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
          
        private function drawLines(now_x:Number, now_y:Number, i:int):void
        {
            var sp:Sprite = new Sprite();
            var color_number:uint = i % 2;

            addChild(sp);            
            sp.graphics.lineStyle(1, 0xffffff, 0.3, false, "none");
            sp.graphics.moveTo (old_x_array[i], old_y_array[i]);
            sp.graphics.lineTo(now_x, now_y);
            
            
            sp.filters = [new GlowFilter(color_array[color_number])];
            
            old_x_array[i] = now_x;
            old_y_array[i] = now_y;
            
            sp.addEventListener(Event.ENTER_FRAME, onEnterFrameLine);
       
        }
        
        private function makeSprite(i:int):Sprite
        {
            var sp:Sprite = new Sprite();
            addChild(sp);
            sp.x = i * 20;
            sp.y = i * 20;
            
            return sp;
        }
        
        private function drawRing(sp:Sprite, i:int):void
        {
            var color_number:uint = i % 2;
        
            sp.graphics.lineStyle(1, 0xffffff, 0.8, false, "none");
            sp.graphics.beginFill(0xffffff, 1.0);
            sp.graphics.drawCircle(0, 0, 0.4);
            sp.filters = [new GlowFilter(color_array[color_number])];
       
        }
        
        private function onEnterFrame(event:Event):void
        {
           var sp:Sprite = event.target as Sprite;
           var global_point:Point;
           
           plate.x = stage.mouseX;
           plate.y = stage.mouseY;
           plate.rotation += 40;
       
           
           for(var i:int=0;i<max_line;i++) {
               global_point = plate_target[i].localToGlobal(new Point(plate_target[i].x, plate_target[i].y));
               
               tmp_x_array[i] += (global_point.x - sp_array[i].x)/20;
               tmp_y_array[i] += (global_point.y - sp_array[i].y)/20;
           
               //tmp_x_array[i] *= (0.92 - i * 0.02);
               //tmp_y_array[i] *= (0.92 - i * 0.02);
               
               tmp_x_array[i] *= (0.92);
               tmp_y_array[i] *= (0.92);
           
               sp_array[i].x += tmp_x_array[i];
               sp_array[i].y += tmp_y_array[i];
            
               drawLines(sp_array[i].x, sp_array[i].y, i);
               setChildIndex(sp_array[i],this.numChildren-1);
           }
           
           
           
        }
        
        private function onEnterFrameLine(event:Event):void
        {
            var sp:Sprite = event.target as Sprite;
             
            if(sp.alpha >= 0) {
                sp.alpha  -= 0.02;
            } else {
                sp.graphics.clear();
                sp.removeEventListener(Event.ENTER_FRAME, onEnterFrameLine);
                removeChild(sp);
                sp = null;
            }
       }
       
}
    
}